/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import generic.theme.IconValue;
import ghidra.util.datastruct.WeakStore;
import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;
import resources.icons.DerivedImageIcon;
import resources.icons.RotateIcon;
import resources.icons.TranslateIcon;
import resources.icons.UrlImageIcon;

public class GIcon
implements Icon {
    private static WeakStore<GIcon> inUseIcons = new WeakStore();
    private String id;
    private Icon delegate;

    public static void refreshAll(GThemeValueMap currentValues) {
        for (GIcon gIcon : inUseIcons.getValues()) {
            gIcon.refresh(currentValues);
        }
    }

    public GIcon(String id) {
        this.id = id;
        this.delegate = Gui.getIcon(id);
        inUseIcons.add((Object)this);
    }

    public String getId() {
        return this.id;
    }

    public URL getUrl() {
        return this.getUrl(this.delegate);
    }

    private URL getUrl(Icon icon) {
        if (icon instanceof UrlImageIcon) {
            UrlImageIcon urlIcon = (UrlImageIcon)icon;
            return urlIcon.getUrl();
        }
        if (icon instanceof TranslateIcon) {
            TranslateIcon translateIcon = (TranslateIcon)icon;
            return this.getUrl(translateIcon.getBaseIcon());
        }
        if (icon instanceof DerivedImageIcon) {
            DerivedImageIcon derivedIcon = (DerivedImageIcon)icon;
            return this.getUrl(derivedIcon.getSourceIcon());
        }
        if (icon instanceof RotateIcon) {
            RotateIcon rotateIcon = (RotateIcon)icon;
            return this.getUrl(rotateIcon.getSourceIcon());
        }
        if (icon instanceof GIcon) {
            return this.getUrl(((GIcon)icon).delegate);
        }
        return null;
    }

    public ImageIcon getImageIcon() {
        return ResourceManager.getImageIcon(this.delegate);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.delegate.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public void refresh(GThemeValueMap currentValues) {
        Icon icon;
        IconValue value = currentValues.getIcon(this.id);
        Icon icon2 = icon = value == null ? null : value.get(currentValues);
        if (icon != null) {
            this.delegate = icon;
        }
    }

    public Icon getDelegate() {
        return this.delegate;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GIcon other = (GIcon)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        URL url = this.getUrl();
        if (url == null) {
            return this.id;
        }
        return this.getUrl().toString();
    }
}

