/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.FontValue;
import generic.theme.ThemeValueUtils;
import java.awt.Font;
import java.text.ParseException;
import java.util.List;

public class FontModifier {
    private String family;
    private Integer style;
    private Integer size;

    private FontModifier() {
    }

    public FontModifier(String family, Integer style, Integer size) {
        this.family = family;
        this.style = style;
        this.size = size;
    }

    public void addFamilyModifier(String newFamily) {
        if (this.family != null) {
            throw new IllegalStateException("Multiple font family names specified");
        }
        this.family = newFamily;
    }

    public void addSizeModfier(int newSize) {
        if (this.size != null) {
            throw new IllegalStateException("Multiple font sizes specified");
        }
        this.size = newSize;
    }

    public void addStyleModifier(int newStyle) {
        if (this.style == null) {
            this.style = newStyle;
            return;
        }
        if (this.style == 0 || newStyle == 0) {
            throw new IllegalStateException("Attempted to set incompable styles");
        }
        this.style = this.style | newStyle;
    }

    public Font modify(Font font) {
        if (this.family == null) {
            if (this.style != null && this.size != null) {
                return font.deriveFont((int)this.style, this.size.intValue());
            }
            if (this.style != null) {
                return font.deriveFont(this.style);
            }
            return font.deriveFont((float)this.size.intValue());
        }
        int newStyle = this.style != null ? this.style.intValue() : font.getStyle();
        int newSize = this.size != null ? this.size.intValue() : font.getSize();
        return new Font(this.family, newStyle, newSize);
    }

    public String getSerializationString() {
        StringBuilder builder = new StringBuilder();
        if (this.family != null) {
            builder.append("[" + this.family + "]");
        }
        if (this.size != null) {
            builder.append("[" + this.size + "]");
        }
        if (this.style != null) {
            switch (this.style) {
                case 0: {
                    builder.append("[plain]");
                    break;
                }
                case 1: {
                    builder.append("[bold]");
                    break;
                }
                case 2: {
                    builder.append("[italic]");
                    break;
                }
                case 3: {
                    builder.append("[bold][italic]");
                }
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.getSerializationString();
    }

    public static FontModifier parse(String value) throws ParseException {
        List<String> modifierValues = ThemeValueUtils.parseGroupings(value, '[', ']');
        if (modifierValues.isEmpty()) {
            return null;
        }
        FontModifier modifier = new FontModifier();
        for (String modifierString : modifierValues) {
            if (FontModifier.setSize(modifier, modifierString) || FontModifier.setStyle(modifier, modifierString)) continue;
            FontModifier.setFamily(modifier, modifierString);
        }
        if (modifier.hadModifications()) {
            return modifier;
        }
        return null;
    }

    private static void setFamily(FontModifier modifier, String modifierString) throws ParseException {
        try {
            modifier.addFamilyModifier(modifierString);
        }
        catch (IllegalStateException e) {
            throw new ParseException("Multiple Font Families specfied", 0);
        }
    }

    private boolean hadModifications() {
        return this.family != null || this.size != null || this.style != null;
    }

    private static boolean setStyle(FontModifier modifier, String modifierString) throws ParseException {
        int style = FontValue.getStyle(modifierString);
        if (style >= 0) {
            try {
                modifier.addStyleModifier(style);
            }
            catch (IllegalStateException e) {
                throw new ParseException("Illegal style combination", 0);
            }
            return true;
        }
        return false;
    }

    private static boolean setSize(FontModifier modifier, String modifierString) {
        try {
            int size = Integer.parseInt(modifierString);
            modifier.addSizeModfier(size);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

