/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import db.DBRecord;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.StringRecord;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.util.NumericUtilities;

public class FunctionRecord
extends DatabaseObject
implements FidHashQuad {
    public static final int HAS_TERMINATOR_FLAG = 1;
    public static final int AUTO_PASS_FLAG = 2;
    public static final int AUTO_FAIL_FLAG = 4;
    public static final int FORCE_SPECIFIC_FLAG = 8;
    public static final int FORCE_RELATION_FLAG = 16;
    final DBRecord record;
    final FidDB fidDb;

    FunctionRecord(FidDB fid, DBObjectCache<FunctionRecord> cache, DBRecord record) {
        super(cache, record.getKey());
        this.record = record;
        this.fidDb = fid;
    }

    public FidDB getFidDb() {
        return this.fidDb;
    }

    @Override
    public short getCodeUnitSize() {
        return this.record.getShortValue(0);
    }

    @Override
    public long getFullHash() {
        return this.record.getLongValue(1);
    }

    @Override
    public byte getSpecificHashAdditionalSize() {
        return this.record.getByteValue(2);
    }

    @Override
    public long getSpecificHash() {
        return this.record.getLongValue(3);
    }

    public String getName() {
        StringRecord lookupString = this.fidDb.getStringsTable().lookupString(this.record.getLongValue(5));
        if (lookupString != null) {
            return lookupString.getValue();
        }
        return null;
    }

    public long getEntryPoint() {
        return this.record.getLongValue(6);
    }

    public String getDomainPath() {
        StringRecord lookupString = this.fidDb.getStringsTable().lookupString(this.record.getLongValue(7));
        if (lookupString != null) {
            return lookupString.getValue();
        }
        return null;
    }

    public boolean hasTerminator() {
        byte val = this.record.getByteValue(8);
        return (val & 1) != 0;
    }

    public boolean autoPass() {
        byte val = this.record.getByteValue(8);
        return (val & 2) != 0;
    }

    public boolean autoFail() {
        byte val = this.record.getByteValue(8);
        return (val & 4) != 0;
    }

    public boolean isForceSpecific() {
        byte val = this.record.getByteValue(8);
        return (val & 8) != 0;
    }

    public boolean isForceRelation() {
        byte val = this.record.getByteValue(8);
        return (val & 0x10) != 0;
    }

    public long getID() {
        return this.record.getKey();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NumericUtilities.toHexString((long)this.getID()));
        sb.append(" - ");
        sb.append(this.getName());
        sb.append(" (");
        sb.append(NumericUtilities.toHexString((long)this.getLibraryID()));
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.getID() ^ this.getID() >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionRecord other = (FunctionRecord)obj;
        return this.getID() == other.getID();
    }

    public long getLibraryID() {
        return this.record.getLongValue(4);
    }

    protected boolean refresh() {
        return false;
    }
}

