/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import docking.widgets.OptionDialog;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.task.SaveTask;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DefaultDomainFileFilter;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class VTWizardUtils {
    public static final DomainFileFilter VT_SESSION_FILTER = new DefaultDomainFileFilter(VTSession.class, true);

    public static DomainFile chooseProgramFile(Component parent, String domainIdentifier, DomainFile fileToSelect) {
        final DataTreeDialog dataTreeDialog = new DataTreeDialog(parent, "Choose " + domainIdentifier, DataTreeDialogType.OPEN, (DomainFileFilter)new DefaultDomainFileFilter(Program.class, true));
        final DomainFileBox box = new DomainFileBox();
        dataTreeDialog.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                box.df = dataTreeDialog.getDomainFile();
                if (box.df == null) {
                    return;
                }
                dataTreeDialog.close();
            }
        });
        dataTreeDialog.selectDomainFile(fileToSelect);
        dataTreeDialog.showComponent();
        return box.df;
    }

    public static boolean askUserToSave(Component parent, DomainFile domainFile) {
        boolean doSave;
        String filename = domainFile.getName();
        int result = OptionDialog.showYesNoDialog((Component)parent, (String)"Save Version Tracking Changes?", (String)("<html>Unsaved Version Tracking changes found for session: " + HTMLUtilities.escapeHTML((String)filename) + ".  <br>Would you like to save these changes?"));
        boolean bl = doSave = result == 1;
        if (doSave) {
            SaveTask saveTask = new SaveTask(domainFile);
            new TaskLauncher((Task)saveTask, parent);
            return saveTask.didSave();
        }
        return false;
    }

    public static boolean askUserToSaveBeforeClosing(Component parent, DomainFile domainFile) {
        boolean doSave;
        String filename = domainFile.getName();
        int result = OptionDialog.showYesNoCancelDialog((Component)parent, (String)"Save Version Tracking Changes?", (String)("<html>Unsaved Version Tracking changes found for session: " + HTMLUtilities.escapeHTML((String)filename) + ".  <br>Would you like to save these changes?"));
        if (result == 0) {
            return false;
        }
        boolean bl = doSave = result == 1;
        if (doSave) {
            SaveTask saveTask = new SaveTask(domainFile);
            new TaskLauncher((Task)saveTask, parent);
            return saveTask.didSave();
        }
        return true;
    }

    private static class DomainFileBox {
        DomainFile df;

        private DomainFileBox() {
        }
    }
}

