/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.duallisting;

import docking.dnd.DragGestureAdapter;
import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemDestinationAddressEditStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.gui.duallisting.VTMarkupItemTransferable;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.ApplyMarkupAtDestinationAddressTask;
import ghidra.features.base.codecompare.listing.ListingCodeComparisonView;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Duo;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;

public class VTDualListingDragNDropHandler
implements Draggable,
Droppable {
    private Duo<ListingPanel> listingPanels;
    private VTController controller;
    ListingCodeComparisonView dualListingProvider;
    private DragSource dragSource;
    private DragGestureAdapter dragGestureAdapter;
    private DragSrcAdapter dragSourceAdapter;
    private int dragAction = 2;
    private DropTarget dropTarget;
    private DropTgtAdapter dropTargetAdapter;
    private DataFlavor[] acceptableFlavors;

    public VTDualListingDragNDropHandler(VTController controller, ListingCodeComparisonView dualListingProvider) {
        this.controller = controller;
        this.dualListingProvider = dualListingProvider;
        ListingPanel leftPanel = dualListingProvider.getListingPanel(Duo.Side.LEFT);
        ListingPanel rightPanel = dualListingProvider.getListingPanel(Duo.Side.RIGHT);
        this.listingPanels = new Duo((Object)leftPanel, (Object)rightPanel);
        this.setUpDragDrop();
    }

    private void setUpDragDrop() {
        this.setUpDrop();
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new DragSrcAdapter((Draggable)this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)((ListingPanel)this.listingPanels.get(Duo.Side.LEFT)).getFieldPanel(), this.dragAction, (DragGestureListener)this.dragGestureAdapter);
    }

    private void setUpDrop() {
        this.setAcceptableFlavors();
        this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, this.acceptableFlavors);
        this.dropTarget = new DropTarget((Component)((ListingPanel)this.listingPanels.get(Duo.Side.RIGHT)).getFieldPanel(), 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.dropTarget.setActive(true);
    }

    private void setAcceptableFlavors() {
        this.acceptableFlavors = new DataFlavor[]{VTMarkupItemTransferable.localMarkupItemFlavor};
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public boolean isStartDragOk(DragGestureEvent e) {
        if (!((ListingPanel)this.listingPanels.get(Duo.Side.LEFT)).isStartDragOk()) {
            return false;
        }
        Point p = e.getDragOrigin();
        ProgramLocation programLocation = ((ListingPanel)this.listingPanels.get(Duo.Side.LEFT)).getProgramLocation(p);
        VTMarkupItem markupItem = this.controller.getCurrentMarkupForLocation(programLocation, this.dualListingProvider.getProgram(Duo.Side.LEFT));
        if (markupItem == null) {
            return false;
        }
        if (markupItem.canApply()) {
            return true;
        }
        VTMarkupItemDestinationAddressEditStatus status = markupItem.getDestinationAddressEditStatus();
        return status == VTMarkupItemDestinationAddressEditStatus.EDITABLE;
    }

    public Transferable getTransferable(Point p) {
        if (!((ListingPanel)this.listingPanels.get(Duo.Side.LEFT)).contains(p)) {
            return null;
        }
        ProgramLocation programLocation = ((ListingPanel)this.listingPanels.get(Duo.Side.LEFT)).getProgramLocation(p);
        VTMarkupItem markupItem = this.controller.getCurrentMarkupForLocation(programLocation, this.dualListingProvider.getProgram(Duo.Side.LEFT));
        if (markupItem == null) {
            return null;
        }
        return new VTMarkupItemTransferable(markupItem);
    }

    public boolean isDropOk(DropTargetDragEvent e) {
        return true;
    }

    public void add(Object obj, DropTargetDropEvent event, DataFlavor f) {
        VTMarkupItem markupItem = (VTMarkupItem)obj;
        VTMarkupType markupType = markupItem.getMarkupType();
        Point p = event.getLocation();
        ProgramLocation loc = ((ListingPanel)this.listingPanels.get(Duo.Side.RIGHT)).getProgramLocation(p);
        Address newDestinationAddress = markupType.getAddress(loc, this.dualListingProvider.getProgram(Duo.Side.RIGHT));
        if (newDestinationAddress == null) {
            Msg.showInfo(this.getClass(), (Component)this.dualListingProvider, (String)"Invalid Drop Location", (Object)(markupType.getDisplayName() + " was not dropped at a valid location."));
            return;
        }
        if (markupItem.getStatus() == VTMarkupItemStatus.SAME && SystemUtilities.isEqual((Object)markupItem.getDestinationAddress(), (Object)newDestinationAddress)) {
            Msg.showInfo(this.getClass(), (Component)this.dualListingProvider, (String)"Already The Same", (Object)(markupType.getDisplayName() + " was dropped at its expected\ndestination where the value is already the same."));
            return;
        }
        ArrayList<VTMarkupItem> arrayList = new ArrayList<VTMarkupItem>();
        arrayList.add(markupItem);
        ApplyMarkupAtDestinationAddressTask task = new ApplyMarkupAtDestinationAddressTask(this.controller.getSession(), arrayList, newDestinationAddress, this.controller.getOptions());
        this.controller.runVTTask(task);
    }
}

