/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class ConsumeRemaining
extends AssignAction {
    private StorageClass resourceType;
    private ParamEntry[] tiles;

    private void initializeEntries() throws InvalidInputException {
        this.tiles = this.resource.extractTiles(this.resourceType);
        if (this.tiles.length == 0) {
            throw new InvalidInputException("Could not find matching resources for action: consume_remaining");
        }
    }

    protected ConsumeRemaining(ParamListStandard res) {
        super(res);
        this.resourceType = StorageClass.GENERAL;
    }

    public ConsumeRemaining(StorageClass store, ParamListStandard res) throws InvalidInputException {
        super(res);
        this.resourceType = store;
        this.initializeEntries();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new ConsumeRemaining(this.resourceType, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        ConsumeRemaining otherAction = (ConsumeRemaining)op;
        if (this.resourceType != otherAction.resourceType) {
            return false;
        }
        if (this.tiles.length != otherAction.tiles.length) {
            return false;
        }
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i].isEquivalent(otherAction.tiles[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        for (int iter = 0; iter != this.tiles.length; ++iter) {
            ParamEntry entry = this.tiles[iter];
            if (status[entry.getGroup()] != 0) continue;
            status[entry.getGroup()] = -1;
        }
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_CONSUME_REMAINING);
        encoder.writeString(AttributeId.ATTRIB_STORAGE, this.resourceType.toString());
        encoder.closeElement(ElementId.ELEM_CONSUME_REMAINING);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_CONSUME_REMAINING.name()});
        this.resourceType = StorageClass.getClass(elem.getAttribute(AttributeId.ATTRIB_STORAGE.name()));
        parser.end(elem);
        try {
            this.initializeEntries();
        }
        catch (InvalidInputException e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

