/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.NoneLocationTrackingSpec;
import ghidra.debug.api.action.GoToInput;
import ghidra.debug.api.action.LocationTracker;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.watch.WatchRow;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.exec.SleighUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.stack.TraceStack;
import java.util.Objects;
import javax.swing.Icon;
import org.antlr.runtime.tree.Tree;

public class WatchLocationTrackingSpec
implements LocationTrackingSpec {
    public static final String CONFIG_PREFIX = "TRACK_WATCH_";
    private final String expression;
    private final String label;

    public static boolean isTrackable(WatchRow watch) {
        return SleighUtils.recoverAddressOf(null, (String)watch.getExpression()) != null;
    }

    public static WatchLocationTrackingSpec fromWatch(WatchRow watch) {
        return new WatchLocationTrackingSpec(watch.getExpression());
    }

    public WatchLocationTrackingSpec(String expression) {
        this.expression = expression;
        SleighUtils.AddressOf addrOf = SleighUtils.recoverAddressOf(null, (String)expression);
        this.label = SleighUtils.generateSleighExpression((Tree)addrOf.offset());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WatchLocationTrackingSpec)) {
            return false;
        }
        WatchLocationTrackingSpec that = (WatchLocationTrackingSpec)obj;
        return this.expression.equals(that.expression);
    }

    public String getConfigName() {
        return CONFIG_PREFIX + this.expression;
    }

    public String getMenuName() {
        return "Track address of watch: " + this.expression;
    }

    public Icon getMenuIcon() {
        return DebuggerResources.ICON_REGISTER_MARKER;
    }

    public String computeTitle(DebuggerCoordinates coordinates) {
        return "&(" + this.expression + ")";
    }

    public String getLocationLabel() {
        return this.label;
    }

    public LocationTracker getTracker() {
        return new WatchLocationTracker();
    }

    class WatchLocationTracker
    implements LocationTracker {
        private AddressSetView reads;
        private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
        private PcodeExecutor<DebuggerPcodeUtils.WatchValue> exec = null;
        private PcodeExpression compiled;

        WatchLocationTracker() {
        }

        public Address computeTraceAddress(ServiceProvider provider, DebuggerCoordinates coordinates) {
            if (!Objects.equals(this.current, coordinates) || this.exec == null) {
                this.current = coordinates;
                this.exec = this.current.getPlatform() == null ? null : DebuggerPcodeUtils.buildWatchExecutor(provider, coordinates);
            } else {
                this.exec.getState().clear();
            }
            if (this.current.getTrace() == null) {
                return null;
            }
            this.compiled = DebuggerPcodeUtils.compileExpression(provider, this.current, WatchLocationTrackingSpec.this.expression);
            DebuggerPcodeUtils.WatchValue value = (DebuggerPcodeUtils.WatchValue)this.compiled.evaluate(this.exec);
            return value == null ? null : value.address();
        }

        public GoToInput getDefaultGoToInput(ServiceProvider provider, DebuggerCoordinates coordinates, ProgramLocation location) {
            TracePlatform platform = this.current.getPlatform();
            String defaultSpace = platform == null ? "ram" : platform.getLanguage().getDefaultSpace().getName();
            SleighUtils.AddressOf addrOf = SleighUtils.recoverAddressOf((String)defaultSpace, (String)WatchLocationTrackingSpec.this.expression);
            if (addrOf == null) {
                return NoneLocationTrackingSpec.INSTANCE.getDefaultGoToInput(provider, coordinates, location);
            }
            return new GoToInput(addrOf.space(), SleighUtils.generateSleighExpression((Tree)addrOf.offset()));
        }

        public boolean affectedByBytesChange(AddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
            return LocationTrackingSpec.changeIsCurrent((AddressSpace)space, (TraceAddressSnapRange)range, (DebuggerCoordinates)coordinates) && (this.reads == null || this.reads.intersects(range.getX1(), range.getX2()));
        }

        public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
            return false;
        }

        public boolean shouldDisassemble() {
            return false;
        }
    }
}

