/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import docking.options.OptionsService;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.LaunchErrorDialog;
import ghidra.util.ManualViewerCommandWrappedOption;
import ghidra.util.Msg;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class BrowserLoader {
    public static void display(URL url) {
        BrowserLoader.display(url, null, null);
    }

    public static void display(URL url, URL fileURL, ServiceProvider serviceProvider) {
        if (url == null) {
            return;
        }
        new Thread(new BrowserRunner(url, fileURL, serviceProvider)).start();
    }

    private static void displayFromBrowserRunner(URL url, URL fileURL, ServiceProvider serviceProvider) {
        try {
            if (serviceProvider == null) {
                BrowserLoader.displayBrowserForExternalURL(url);
            } else {
                BrowserLoader.displayBrowser(url, fileURL, serviceProvider);
            }
        }
        catch (Exception e) {
            Msg.showError(BrowserLoader.class, null, (String)"Error Loading Browser", (Object)("Error loading browser for URL: " + String.valueOf(url)), (Throwable)e);
        }
    }

    private static void displayBrowserForExternalURL(URL url) throws Exception {
        String[] arguments = BrowserLoader.generateCommandArguments(url, null, ManualViewerCommandWrappedOption.getDefaultBrowserLoaderOptions());
        Process p = Runtime.getRuntime().exec(arguments);
        p.waitFor();
        p.exitValue();
    }

    private static void displayBrowser(URL url, URL fileURL, ServiceProvider serviceProvider) {
        OptionsService service = (OptionsService)serviceProvider.getService(OptionsService.class);
        ToolOptions options = service.getOptions("Processor Manuals");
        ImmediateOptionsChangeListener listener = new ImmediateOptionsChangeListener();
        options.addOptionsChangeListener((OptionsChangeListener)listener);
        ManualViewerCommandWrappedOption defaultOption = ManualViewerCommandWrappedOption.getDefaultBrowserLoaderOptions();
        ManualViewerCommandWrappedOption customOption = (ManualViewerCommandWrappedOption)options.getCustomOption("Manual Viewer Options", (CustomOption)defaultOption);
        boolean success = BrowserLoader.tryToDisplayBrowser(url, fileURL, customOption);
        while (!success) {
            LaunchErrorDialog dialog = new LaunchErrorDialog(url, fileURL);
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                return;
            }
            service.showOptionsDialog("Processor Manuals", "Processor Manuals");
            if (!listener.hasChanged()) {
                return;
            }
            customOption = (ManualViewerCommandWrappedOption)options.getCustomOption("Manual Viewer Options", (CustomOption)defaultOption);
            success = BrowserLoader.tryToDisplayBrowser(url, fileURL, customOption);
        }
    }

    private static boolean tryToDisplayBrowser(URL url, URL fileURL, ManualViewerCommandWrappedOption option) {
        String[] processCommands = BrowserLoader.generateCommandArguments(url, fileURL, option);
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(processCommands);
        }
        catch (Exception exc) {
            return false;
        }
        try {
            p.waitFor();
            p.exitValue();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private static String[] generateCommandArguments(URL url, URL fileURL, ManualViewerCommandWrappedOption option) {
        String[] commandArguments;
        ArrayList<String> argumentList = new ArrayList<String>();
        argumentList.add(option.getCommandString());
        for (String string : commandArguments = option.getCommandArguments()) {
            argumentList.add(string);
        }
        String urlString = option.getUrlReplacementString();
        if (urlString.equals("${HTTP_URL}") || fileURL == null) {
            argumentList.add(url.toExternalForm());
        } else if (urlString.equals("${FILE_URL}")) {
            argumentList.add(fileURL.toExternalForm());
        } else {
            argumentList.add(new File(fileURL.getFile()).getAbsolutePath());
        }
        return argumentList.toArray(new String[argumentList.size()]);
    }

    static class BrowserRunner
    implements Runnable {
        private final URL url;
        private final ServiceProvider serviceProvider;
        private final URL fileURL;

        private BrowserRunner(URL url, URL fileURL, ServiceProvider serviceProvider) {
            this.url = url;
            this.fileURL = fileURL;
            this.serviceProvider = serviceProvider;
        }

        @Override
        public void run() {
            BrowserLoader.displayFromBrowserRunner(this.url, this.fileURL, this.serviceProvider);
        }
    }

    static class ImmediateOptionsChangeListener
    implements OptionsChangeListener {
        private boolean hasChanged = false;

        ImmediateOptionsChangeListener() {
        }

        public void optionsChanged(ToolOptions theOptions, String name, Object oldValue, Object newValue) {
            this.hasChanged = true;
        }

        boolean hasChanged() {
            return this.hasChanged;
        }
    }
}

