/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.SelectFromListDialog;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ListMountedFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)((ActionBuilder)new ActionBuilder("FSB List Mounted Filesystems", this.context.plugin().getName()).description("List Mounted Filesystems")).withContext(FSBActionContext.class).enabledWhen(FSBActionContext::notBusy).toolBarIcon(FSBIcons.LIST_MOUNTED).toolBarGroup("ZZZZ").popupMenuIcon(FSBIcons.LIST_MOUNTED).popupMenuPath(new String[]{"List Mounted Filesystems"}).popupMenuGroup("L").onAction(ac -> {
            ArrayList<FSRL> sortedFSRLs = new ArrayList<FSRL>();
            sortedFSRLs.addAll(this.context.plugin().getCurrentlyOpenBrowsers());
            sortedFSRLs.sort((f1, f2) -> f1.toString().compareTo(f2.toString()));
            FSRL fsrl = (FSRL)SelectFromListDialog.selectFromList(sortedFSRLs, (String)"Select filesystem", (String)"Choose filesystem to view", f -> this.getPrettyFSRLString((FSRL)f));
            if (fsrl != null) {
                this.context.plugin().showProvider(this.context.plugin().getProviderFor(fsrl));
            }
        }).build());
    }

    private String getPrettyFSRLString(FSRL fsrl) {
        FileSystemService fsService = this.context.fsService();
        LocalFileSystem localFS = fsService.getLocalFS();
        if (localFS.getRootDir().getFSRL().equals(fsrl)) {
            return "My Computer";
        }
        if (fsrl.getNestingDepth() == 1) {
            return new File(fsrl.getPath()).getPath();
        }
        if (fsrl.getPath().equals("/")) {
            fsrl = fsrl.getFS();
        }
        Object result = "";
        List<FSRL> fsrlParts = fsrl.split();
        for (int i = 0; i < fsrlParts.size(); ++i) {
            FSRL part = fsrlParts.get(i);
            if (i == 0) {
                result = new File(part.getPath()).getPath();
                continue;
            }
            if (part instanceof FSRLRoot) continue;
            result = (String)result + "|" + part.getPath();
        }
        return result;
    }
}

