/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.help.AboutDomainObjectUtils;
import ghidra.app.services.FileSystemBrowserService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileBytesProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.AddToProgramDialog;
import ghidra.plugin.importer.ImporterDialog;
import ghidra.plugin.importer.LoadLibrariesOptionsDialog;
import ghidra.plugins.importer.batch.BatchImportDialog;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import util.CollectionUtils;

public class ImporterUtilities {
    public static final GhidraFileFilter LOADABLE_FILES_FILTER = ExtensionFileFilter.forExtensions((String)"Loadable files", (String[])new String[]{"exe", "dll", "obj", "drv", "bin", "hex", "o", "a", "so", "class", "lib", "dylib"});
    public static final GhidraFileFilter CONTAINER_FILES_FILTER = ExtensionFileFilter.forExtensions((String)"Container files", (String[])new String[]{"zip", "tar", "tgz", "jar", "gz", "ipsw", "img3", "dmg", "apk", "cpio", "rpm", "lib"});
    private static final FileSystemService fsService = FileSystemService.getInstance();

    static List<LanguageCompilerSpecPair> getPairs(Collection<LoadSpec> loadSpecs) {
        HashSet<LanguageCompilerSpecPair> pairs = new HashSet<LanguageCompilerSpecPair>();
        for (LoadSpec loadSpec : loadSpecs) {
            LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
            if (pair == null) continue;
            pairs.add(pair);
        }
        return CollectionUtils.asList(pairs);
    }

    public static void showImportDialog(PluginTool tool, ProgramManager programManager, FSRL fsrl, DomainFolder destinationFolder, String suggestedPath) {
        TaskLauncher.launchModal((String)"Import", monitor -> ImporterUtilities.showImportDialog(tool, programManager, fsrl, destinationFolder, suggestedPath, monitor));
    }

    public static void showImportDialog(PluginTool tool, ProgramManager programManager, FSRL fsrl, DomainFolder destinationFolder, String suggestedPath, TaskMonitor monitor) {
        block14: {
            Objects.requireNonNull(monitor);
            try (RefdFile referencedFile = fsService.getRefdFile(fsrl, monitor);){
                if (!ImporterUtilities.ensureFileImportable(referencedFile, monitor)) {
                    return;
                }
                FSRL fullFsrl = fsService.getFullyQualifiedFSRL(fsrl, monitor);
                GFileSystem fs = referencedFile.fsRef.getFilesystem();
                if (fs instanceof GFileSystemProgramProvider) {
                    ImporterUtilities.doFsImport(referencedFile, fullFsrl, destinationFolder, programManager, tool);
                    return;
                }
                if (fsService.isFileFilesystemContainer(fullFsrl, monitor)) {
                    ImporterUtilities.importFromContainer(tool, programManager, destinationFolder, suggestedPath, monitor, referencedFile, fullFsrl);
                    break block14;
                }
                ImporterUtilities.showImportSingleFileDialog(fullFsrl, destinationFolder, suggestedPath, tool, programManager, monitor);
                return;
            }
            catch (IOException ioe) {
                String message = ioe.getMessage();
                Msg.showError(ImporterUtilities.class, null, (String)"Import Error", (Object)("Unable to import file " + fsrl.getName() + (String)(message != null ? "\n\nCause: " + message : "")), (Throwable)ioe);
            }
            catch (CancelledException e) {
                Msg.info(ImporterUtilities.class, (Object)"Show Import Dialog canceled");
            }
        }
    }

    private static void importFromContainer(PluginTool tool, ProgramManager programManager, DomainFolder destinationFolder, String suggestedPath, TaskMonitor monitor, RefdFile referencedFile, FSRL fullFsrl) {
        Window parent = tool.getActiveWindow();
        FileSystemBrowserService fsbService = (FileSystemBrowserService)tool.getService(FileSystemBrowserService.class);
        int choice = 0;
        choice = fsbService == null ? OptionDialog.showOptionDialog((Component)parent, (String)"Container File Detected", (String)("The file " + referencedFile.file.getName() + " seems to have nested files in it.  Select an import mode:"), (String)"Single file", (String)"Batch", (int)3) : OptionDialog.showOptionDialog((Component)parent, (String)"Container File Detected", (String)("The file " + referencedFile.file.getName() + " seems to have nested files in it.  Select an import mode:"), (String)"Single file", (String)"Batch", (String)"File System", (int)3);
        if (choice == 1) {
            ImporterUtilities.showImportSingleFileDialog(fullFsrl, destinationFolder, suggestedPath, tool, programManager, monitor);
        } else if (choice == 2) {
            BatchImportDialog.showAndImport(tool, null, List.of(fullFsrl), destinationFolder, programManager);
        } else if (choice == 3) {
            fsbService.openFileSystem(fullFsrl);
        }
    }

    public static void showAddToProgramDialog(FSRL fsrl, Program program, PluginTool tool, TaskMonitor monitor) {
        Objects.requireNonNull(monitor);
        if (!program.canLock()) {
            Msg.showWarn(null, null, (String)"Add To Program", (Object)"Cannot Add To Program while program is locked.  Please wait or stop running tasks.");
            return;
        }
        try {
            ByteProvider provider = fsService.getByteProvider(fsrl, false, monitor);
            if (provider.length() == 0L) {
                Msg.showWarn(null, null, (String)("Error opening " + fsrl.getName()), (Object)"The item does not correspond to a valid file.");
                provider.close();
                return;
            }
            LoaderMap loaderMap = LoaderService.getSupportedLoadSpecs(provider, loader -> loader.supportsLoadIntoProgram(program));
            SystemUtilities.runSwingLater(() -> {
                AddToProgramDialog dialog = new AddToProgramDialog(tool, fsrl, loaderMap, provider, program);
                tool.showDialog((DialogComponentProvider)dialog);
            });
        }
        catch (IOException e) {
            Msg.showError(ImporterUtilities.class, null, (String)"Error Reading Resource", (Object)("I/O error reading " + fsrl.getName()), (Throwable)e);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public static void showLoadLibrariesDialog(Program program, PluginTool tool, TaskMonitor monitor) {
        Objects.requireNonNull(monitor);
        if (!program.canLock()) {
            Msg.showWarn(null, null, (String)"Load Libraries", (Object)"Cannot Load Libraries while program is locked.  Please wait or stop running tasks.");
            return;
        }
        try {
            ByteProvider provider = ImporterUtilities.getProvider(program);
            if (provider == null) {
                Msg.showWarn(null, null, (String)"Load Libraries", (Object)"Cannot Load Libraries. Program does not have file bytes associated with it.");
                return;
            }
            LoadSpec loadSpec = ImporterUtilities.getLoadSpec(provider, program);
            if (loadSpec == null || loadSpec.getLoader().getDefaultOptions(provider, loadSpec, null, false, false).stream().noneMatch(e -> e.getName().equals("Only Load Libraries"))) {
                Msg.showWarn(null, null, (String)"Load Libraries", (Object)"Cannot Load Libraries. Program does not support library loading.");
                return;
            }
            AddressFactory addressFactory = loadSpec.getLanguageCompilerSpec().getLanguage().getAddressFactory();
            SystemUtilities.runSwingLater(() -> {
                LoadLibrariesOptionsDialog dialog = new LoadLibrariesOptionsDialog(provider, program, tool, loadSpec, () -> addressFactory);
                tool.showDialog((DialogComponentProvider)dialog);
            });
        }
        catch (LanguageNotFoundException e2) {
            Msg.showError(null, null, (String)"Load Libraries", (Object)"Language not found.", (Throwable)e2);
        }
    }

    public static void showImportSingleFileDialog(FSRL fsrl, DomainFolder destinationFolder, String suggestedPath, PluginTool tool, ProgramManager programManager, TaskMonitor monitor) {
        try {
            ByteProvider provider = fsService.getByteProvider(fsrl, true, monitor);
            LoaderMap loaderMap = LoaderService.getAllSupportedLoadSpecs(provider);
            SystemUtilities.runSwingLater(() -> {
                ImporterDialog importerDialog = new ImporterDialog(tool, programManager, loaderMap, provider, suggestedPath);
                if (destinationFolder != null) {
                    importerDialog.setDestinationFolder(destinationFolder);
                }
                tool.showDialog((DialogComponentProvider)importerDialog);
            });
        }
        catch (IOException ioe) {
            Msg.showError(ImporterUtilities.class, (Component)tool.getActiveWindow(), (String)"Error Importing File", (Object)("Error when importing file " + String.valueOf(fsrl)), (Throwable)ioe);
        }
        catch (CancelledException e) {
            Msg.info(ImporterUtilities.class, (Object)("Import single file " + String.valueOf(fsrl) + " cancelled"));
        }
    }

    private static void doFsImport(RefdFile refdFile, FSRL fsrl, DomainFolder destFolderParam, ProgramManager programManager, PluginTool tool) {
        TaskLauncher.launchNonModal((String)"Import File (FileSystem specific)", monitor -> {
            GFile gfile = refdFile.file;
            try {
                Object consumer = new Object();
                DomainFolder destFolder = destFolderParam == null ? AppInfo.getActiveProject().getProjectData().getRootFolder() : destFolderParam;
                Program program = ImporterUtilities.doFSImportHelper((GFileSystemProgramProvider)((Object)refdFile.fsRef.getFilesystem()), gfile, destFolder, consumer, monitor);
                if (program == null) {
                    return;
                }
                try (LoadResults<Program> loadResults = new LoadResults<Program>(new Loaded<Program>(program, program.getName(), fsrl, tool.getProject(), destFolder.getPathname(), false, consumer));){
                    ImporterUtilities.doPostImportProcessing(tool, programManager, loadResults, "", monitor);
                }
            }
            catch (Exception e) {
                FSUtilities.displayException(ImporterUtilities.class, tool.getActiveWindow(), "Problem Encountered During Import", "Unable to import file " + refdFile.file.getName() + " using special purpose loader built into the " + gfile.getFilesystem().getDescription() + " filesystem.", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Program doFSImportHelper(GFileSystemProgramProvider pfs, GFile gfile, DomainFolder destFolder, Object consumer, TaskMonitor monitor) throws Exception {
        Program program = pfs.getProgram(gfile, DefaultLanguageService.getLanguageService(), monitor, consumer);
        if (program == null) {
            return null;
        }
        boolean success = false;
        try {
            String importFilename = ProjectDataUtils.getUniqueName((DomainFolder)destFolder, (String)program.getName());
            if (importFilename == null) {
                throw new IOException("Unable to find unique name for " + program.getName());
            }
            destFolder.createFile(importFilename, (DomainObject)program, monitor);
            success = true;
            Program program2 = program;
            return program2;
        }
        finally {
            if (!success) {
                program.release(consumer);
            }
        }
    }

    public static void importSingleFile(PluginTool tool, ProgramManager programManager, FSRL fsrl, String projectRootPath, boolean mirrorFsLayout, LoadSpec loadSpec, String importName, List<Option> options, TaskMonitor monitor) {
        Objects.requireNonNull(monitor);
        try (ByteProvider bp2 = fsService.getByteProvider(fsrl, false, monitor);){
            MessageLog messageLog = new MessageLog();
            Loader.ImporterSettings settings = new Loader.ImporterSettings(bp2, importName, tool.getProject(), projectRootPath, mirrorFsLayout, loadSpec, options, new Object(), messageLog, monitor);
            try (LoadResults<? extends DomainObject> loadResults = loadSpec.getLoader().load(settings);){
                loadResults.save(monitor);
                ImporterUtilities.doPostImportProcessing(tool, programManager, loadResults, messageLog.toString(), monitor);
            }
        }
        catch (CancelledException bp2) {
        }
        catch (Exception e) {
            Msg.showError(ImporterUtilities.class, (Component)tool.getActiveWindow(), (String)"Error Importing File", (Object)"Error importing file: %s (%s)".formatted(fsrl.getName(), e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<DomainFile> doPostImportProcessing(PluginTool pluginTool, ProgramManager programManager, LoadResults<? extends DomainObject> loadResults, String importMessages, TaskMonitor monitor) throws CancelledException {
        boolean firstProgram = true;
        HashSet<DomainFile> importedFilesSet = new HashSet<DomainFile>();
        for (Loaded<? extends DomainObject> loaded : loadResults) {
            monitor.checkCancelled();
            Object consumer = new Object();
            DomainObject obj = loaded.getDomainObject(consumer);
            try {
                if (obj instanceof Program) {
                    if (programManager != null) {
                        int openState = firstProgram ? 1 : 2;
                        programManager.openProgram((Program)obj, openState);
                    }
                    importedFilesSet.add(obj.getDomainFile());
                }
                if (firstProgram) {
                    ImporterUtilities.displayResults(pluginTool, obj, obj.getDomainFile(), importMessages);
                    if (!Loader.loggingDisabled && !importMessages.isEmpty()) {
                        Msg.info(ImporterUtilities.class, (Object)("Additional info:\n" + importMessages));
                    }
                }
                firstProgram = false;
            }
            finally {
                obj.release(consumer);
            }
        }
        ImporterUtilities.selectFiles(importedFilesSet);
        return importedFilesSet;
    }

    private static void selectFiles(Set<DomainFile> importedFilesSet) {
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        if (frontEndTool != null) {
            frontEndTool.selectFiles(importedFilesSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContentToProgram(PluginTool tool, Program program, FSRL fsrl, LoadSpec loadSpec, List<Option> options, TaskMonitor monitor) {
        Objects.requireNonNull(monitor);
        MessageLog messageLog = new MessageLog();
        Object consumer = new Object();
        program.addConsumer(consumer);
        try (ByteProvider bp = fsService.getByteProvider(fsrl, false, monitor);){
            Loader.ImporterSettings settings = new Loader.ImporterSettings(bp, bp.getName(), tool.getProject(), program.getDomainFile().getPathname(), false, loadSpec, options, consumer, messageLog, monitor);
            loadSpec.getLoader().loadInto(program, settings);
            ImporterUtilities.displayResults(tool, (DomainObject)program, program.getDomainFile(), messageLog.toString());
            if (!Loader.loggingDisabled && messageLog.hasMessages()) {
                Msg.info(ImporterUtilities.class, (Object)("Additional info:\n" + messageLog.toString()));
            }
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            Msg.showError(ImporterUtilities.class, null, (String)"Error Importing File", (Object)("Error importing file " + fsrl.getName()), (Throwable)e);
        }
        finally {
            program.release(consumer);
        }
    }

    private static void displayResults(PluginTool tool, DomainObject obj, DomainFile df, String info) {
        DomainFile domainFile = obj.getDomainFile();
        Map metadata = obj.getMetadata();
        if (df != null) {
            domainFile = df;
            metadata = df.getMetadata();
        }
        HelpLocation helpLocation = new HelpLocation("About", "About_Program");
        AboutDomainObjectUtils.displayInformation((PluginTool)tool, (DomainFile)domainFile, (Map)metadata, (String)"Import Results Summary", (String)info, (HelpLocation)helpLocation);
    }

    static ByteProvider getProvider(Program program) {
        List allFileBytes = program.getMemory().getAllFileBytes();
        return !allFileBytes.isEmpty() ? new FileBytesProvider((FileBytes)allFileBytes.get(0)) : null;
    }

    static LoadSpec getLoadSpec(ByteProvider provider, Program program) {
        LoaderMap loaderMap = LoaderService.getSupportedLoadSpecs(provider, loader -> loader.getName().equalsIgnoreCase(program.getExecutableFormat()));
        if (loaderMap.isEmpty()) {
            return null;
        }
        Loader loader2 = (Loader)loaderMap.firstKey();
        if (loader2 == null) {
            return null;
        }
        LanguageCompilerSpecPair programLcs = program.getLanguageCompilerSpecPair();
        return ((Collection)loaderMap.get(loader2)).stream().filter(e -> programLcs.equals((Object)e.getLanguageCompilerSpec())).findFirst().orElse(null);
    }

    public static LoadSpec getLoadSpec(Program program) {
        ByteProvider provider;
        if (program == null || (provider = ImporterUtilities.getProvider(program)) == null) {
            return null;
        }
        return ImporterUtilities.getLoadSpec(provider, program);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean ensureFileImportable(RefdFile refdFile, TaskMonitor monitor) {
        GFile f = refdFile.file;
        GFileSystem fs = refdFile.fsRef.getFilesystem();
        monitor.initialize(0L);
        monitor.setMessage("Testing file access: " + f.getName());
        try (ByteProvider bp = fs.getByteProvider(f, monitor);){
            if (bp.length() == 0L) {
                Msg.showError(ImporterUtilities.class, null, (String)"File is empty", (Object)"File %s is empty, nothing to import".formatted(f.getPath()));
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (CryptoException e) {
            Msg.showError(ImporterUtilities.class, null, (String)"Crypto / Password Error", (Object)("Unable to access the specified file.\nThis could be caused by not entering the correct password or because of missing crypto information.\n\n" + e.getMessage()));
            return false;
        }
        catch (IOException e) {
            Msg.showError(ImporterUtilities.class, null, (String)"File IO Error", (Object)("Unable to access the specified file.\n\n" + e.getMessage()));
            return false;
        }
        catch (CancelledException e) {
            return false;
        }
    }
}

