/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.framework.options.Options;
import ghidra.program.model.data.DataTypeDisplayOptions;

public class OptionsBasedDataTypeDisplayOptions
implements DataTypeDisplayOptions {
    public static final String DISPLAY_ABBREVIATED_DEFAULT_LABELS = "Operands Field.Display Abbreviated Default Label Names";
    public static final String MAXIMUM_DEFAULT_LABEL_LENGTH = "Operands Field.Maximum Length of String in Default Labels";
    private final Options options;

    public OptionsBasedDataTypeDisplayOptions(Options options) {
        this.options = options;
        options.registerOption(DISPLAY_ABBREVIATED_DEFAULT_LABELS, (Object)false, null, "Uses a shortened form of the label name for dynamic String data types in the display of operand references (e.g., STR_01234567)");
        options.registerOption(MAXIMUM_DEFAULT_LABEL_LENGTH, (Object)32, null, "Sets the maximumn number of characters from a String to include in dynamic String labels in operand references");
    }

    public int getLabelStringLength() {
        return this.options.getInt(MAXIMUM_DEFAULT_LABEL_LENGTH, 32);
    }

    public boolean useAbbreviatedForm() {
        return this.options.getBoolean(DISPLAY_ABBREVIATED_DEFAULT_LABELS, false);
    }
}

