/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import org.junit.Assert;

public class StringComparer {
    public static void compareLines(List<String> expectedList, File actualFile) throws Exception {
        FilePrinter filePrinter = new FilePrinter(actualFile);
        int index = 0;
        boolean hasFailure = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(actualFile));){
            String actualLine;
            int excess = 0;
            while ((actualLine = reader.readLine()) != null) {
                if (index >= expectedList.size()) {
                    ++excess;
                    continue;
                }
                String expectedLine = expectedList.get(index++);
                actualLine = actualLine.trim();
                boolean match = (expectedLine = expectedLine.trim()).equals(actualLine) || actualLine.startsWith(expectedLine);
                hasFailure |= !match;
                if (match) continue;
                filePrinter.print();
                Msg.debug(StringComparer.class, (Object)("Expected line does not match actual line (" + index + "): \nExpected: " + expectedLine + "\nActual: " + actualLine));
            }
            if (excess > 0) {
                filePrinter.print();
                String message = "Actual file contains " + excess + " more lines than expected";
                Msg.debug(StringComparer.class, (Object)message);
                Assert.fail((String)message);
            } else if (!hasFailure && index < expectedList.size()) {
                filePrinter.print();
                int fewer = expectedList.size() - index;
                String message = "Actual file contains " + fewer + " fewer lines than expected";
                Msg.debug(StringComparer.class, (Object)message);
                Assert.fail((String)message);
            }
            if (hasFailure) {
                Assert.fail((String)"One or more failures--see output for data");
            }
        }
    }

    private static class FilePrinter {
        private File f;
        private boolean printed;

        FilePrinter(File f) {
            this.f = f;
        }

        void print() {
            if (!this.printed) {
                Msg.debug((Object)this, (Object)("Test file: " + String.valueOf(this.f)));
                this.printed = true;
            }
        }
    }
}

