/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PrebindChecksumCommand
extends LoadCommand {
    private int cksum;

    PrebindChecksumCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.cksum = reader.readNextInt();
    }

    public int getCheckSum() {
        return this.cksum;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "cksum", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "prebind_cksum_command";
    }
}

