/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.util.datastruct.WeakValueHashMap;
import java.io.IOException;
import java.nio.charset.Charset;

public class StringTable {
    protected BinaryReader reader;
    protected WeakValueHashMap<Long, String> cache = new WeakValueHashMap();
    private Charset charset;

    public static StringTable of(BinaryReader reader, Charset charset) {
        if (reader == null) {
            return null;
        }
        return new StringTable(reader, charset);
    }

    public StringTable(BinaryReader reader, Charset charset) {
        this.reader = reader;
        this.charset = charset;
    }

    public boolean isValid(long offset) {
        return this.reader.isValidIndex(offset);
    }

    public void clear() {
        this.reader = null;
        this.cache.clear();
    }

    public String getStringAtOffset(long offset) throws IOException {
        if (!this.isValid(offset)) {
            throw new IOException("Invalid offset requested %d [0x%x]".formatted(offset, offset));
        }
        String s = (String)this.cache.get((Object)offset);
        if (s == null) {
            s = this.reader.readString(offset, this.charset, 1);
            this.cache.put((Object)offset, (Object)s);
        }
        return s;
    }
}

