/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.util.AddressInput;
import ghidra.app.util.NamespaceUtils;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.ProgramFileChooser;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class EditExternalLocationPanel
extends JPanel {
    private JButton clearButton;
    private JButton editButton;
    private GhidraComboBox<String> extLibNameComboBox;
    private JLabel extTypeLabel;
    private JTextField extLibPathTextField;
    private JTextField extLabelTextField;
    private AddressInput extAddressInputWidget;
    private JCheckBox functionCheckBox;
    private DocumentListener nameDocumentListener;
    private ItemListener nameItemListener;
    private boolean isValidState;
    private Program program;
    private ExternalLocation externalLocation;
    private String startingExternalLibraryName;
    private String autoDeterminedExternalLibraryPath;
    private String startingLocationName;
    private Address startingLocationAddress;
    private JTextField extOriginalLabelTextField;
    private String startingOriginalName;
    private JButton restoreButton;

    EditExternalLocationPanel(ExternalLocation externalLocation) {
        this.program = externalLocation.getSymbol().getProgram();
        this.externalLocation = externalLocation;
        this.startingExternalLibraryName = externalLocation.getLibraryName();
        ExternalManager externalManager = this.program.getExternalManager();
        this.autoDeterminedExternalLibraryPath = externalManager.getExternalLibraryPath(this.startingExternalLibraryName);
        Symbol s = externalLocation.getSymbol();
        this.startingLocationName = NamespaceUtils.getNamespaceQualifiedName((Namespace)s.getParentNamespace(), (String)externalLocation.getLabel(), (boolean)true);
        this.startingLocationAddress = externalLocation.getAddress();
        this.startingOriginalName = externalLocation.getOriginalImportedName();
        this.buildPanel();
        this.initialize();
    }

    EditExternalLocationPanel(Program program, String externalLibraryName) {
        this.program = program;
        this.startingExternalLibraryName = externalLibraryName != null ? externalLibraryName : "<EXTERNAL>";
        ExternalManager externalManager = program.getExternalManager();
        this.autoDeterminedExternalLibraryPath = externalManager.getExternalLibraryPath(this.startingExternalLibraryName);
        this.buildPanel();
        this.initialize();
    }

    private void buildPanel() {
        JPanel topPanel = new JPanel((LayoutManager)new PairLayout(5, 10, 160));
        topPanel.setBorder(new CompoundBorder(new TitledBorder("External Program"), new EmptyBorder(0, 5, 5, 5)));
        topPanel.add((Component)new GLabel("Name:", 4));
        this.extLibNameComboBox = new GhidraComboBox();
        this.extLibNameComboBox.setEditable(true);
        this.nameDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditExternalLocationPanel.this.extProgNameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditExternalLocationPanel.this.extProgNameChanged();
            }
        };
        this.extLibNameComboBox.addDocumentListener(this.nameDocumentListener);
        this.nameItemListener = e -> {
            this.extProgNameChanged();
            this.updateExtLibPath();
        };
        this.extLibNameComboBox.addItemListener(this.nameItemListener);
        topPanel.add((Component)this.extLibNameComboBox);
        this.extLibPathTextField = new JTextField();
        this.extLibPathTextField.setBackground(this.getBackground());
        this.extLibPathTextField.setEditable(false);
        this.extLibPathTextField.setFocusable(false);
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Remove Link to External Program");
        this.clearButton.addActionListener(e -> this.extLibPathTextField.setText(null));
        this.editButton = new JButton("Edit");
        this.editButton.setToolTipText("Edit Link to External Program");
        this.editButton.addActionListener(e -> this.popupProgramChooser());
        JPanel pathPanel = new JPanel(new BorderLayout());
        pathPanel.add((Component)this.extLibPathTextField, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        buttonPanel.add(this.clearButton);
        buttonPanel.add(this.editButton);
        pathPanel.add((Component)buttonPanel, "East");
        topPanel.add((Component)new GLabel("Path:", 4));
        topPanel.add(pathPanel);
        JPanel bottomPanel = new JPanel((LayoutManager)new PairLayout(10, 10, 160));
        bottomPanel.setBorder(new CompoundBorder(new TitledBorder("External Location"), new EmptyBorder(0, 5, 5, 5)));
        bottomPanel.add((Component)new GLabel("Type:", 4));
        this.extTypeLabel = new GDLabel("Function");
        bottomPanel.add(this.extTypeLabel);
        bottomPanel.add((Component)new GDLabel("Label:", 4));
        this.extLabelTextField = new JTextField();
        bottomPanel.add(this.extLabelTextField);
        bottomPanel.add((Component)new GLabel("Address:", 4));
        this.extAddressInputWidget = new AddressInput();
        bottomPanel.add(this.extAddressInputWidget);
        if (this.startingOriginalName != null) {
            bottomPanel.add((Component)new GLabel("Original Label:", 4));
            bottomPanel.add(this.buildOriginalLableFieldAndRestoreButton());
        }
        this.setLayout((LayoutManager)new VerticalLayout(5));
        this.add(topPanel);
        this.add(bottomPanel);
        if (this.externalLocation == null) {
            this.functionCheckBox = new GCheckBox("Make External Function");
            this.add(this.functionCheckBox);
        }
    }

    private Component buildOriginalLableFieldAndRestoreButton() {
        JPanel panel = new JPanel(new BorderLayout());
        this.extOriginalLabelTextField = new JTextField("Original");
        this.extOriginalLabelTextField.setEditable(false);
        panel.add((Component)this.extOriginalLabelTextField, "Center");
        this.restoreButton = new JButton("Restore");
        this.restoreButton.addActionListener(e -> this.restoreOriginalName());
        panel.add((Component)this.restoreButton, "East");
        return panel;
    }

    private void restoreOriginalName() {
        String originalName = this.extOriginalLabelTextField.getText().trim();
        if (originalName.length() > 0) {
            this.extLabelTextField.setText(originalName);
        }
    }

    private void extProgNameChanged() {
        boolean hasText = this.extLibNameComboBox.getText().trim().length() != 0;
        this.clearButton.setEnabled(hasText);
        this.editButton.setEnabled(hasText);
        this.extLibPathTextField.setText(null);
    }

    private void populateExternalNames() {
        Object[] names = this.program.getExternalManager().getExternalLibraryNames();
        this.extLibNameComboBox.clearModel();
        this.extLibNameComboBox.addItem((Object)"<EXTERNAL>");
        Arrays.sort(names);
        for (Object name : names) {
            if ("<EXTERNAL>".equals(name)) continue;
            this.extLibNameComboBox.addItem(name);
        }
    }

    private void updateExtLibPath() {
        SystemUtilities.runSwingNow(() -> {
            String name = this.extLibNameComboBox.getText().trim();
            if ("<EXTERNAL>".equals(name)) {
                this.extLibPathTextField.setText("");
                this.editButton.setEnabled(false);
                this.clearButton.setEnabled(false);
            } else {
                String path = null;
                if (name.length() != 0) {
                    name = name.trim();
                    ExternalManager externalManager = this.program.getExternalManager();
                    path = externalManager.getExternalLibraryPath(name);
                }
                this.extLibPathTextField.setText(path);
                this.editButton.setEnabled(true);
                this.clearButton.setEnabled(true);
            }
        });
    }

    private void popupProgramChooser() {
        ProgramFileChooser dialog = new ProgramFileChooser(this.getParent(), "Choose External Program");
        dialog.addOkActionListener(e -> {
            DomainFile df = dialog.getDomainFile();
            if (df == null) {
                return;
            }
            String pathName = df.getPathname();
            if (pathName.equals(this.program.getDomainFile().getPathname())) {
                dialog.setStatusText("Selected program is the same as current program");
                return;
            }
            dialog.close();
            this.extLibPathTextField.setText(df.getPathname());
        });
        DockingWindowManager.showDialog((Component)this, (DialogComponentProvider)dialog);
    }

    private void initialize() {
        boolean isFunction;
        this.populateExternalNames();
        this.restoreLibraryName();
        this.extTypeLabel.setText(this.externalLocation != null && this.externalLocation.isFunction() ? "Function" : "Data");
        this.extLabelTextField.setText(this.startingLocationName);
        if (this.extOriginalLabelTextField != null) {
            this.extOriginalLabelTextField.setText(this.startingOriginalName);
        }
        this.extAddressInputWidget.setProgram(this.program);
        if (this.startingLocationAddress != null) {
            this.extAddressInputWidget.setAddress(this.startingLocationAddress);
        } else {
            this.extAddressInputWidget.clear();
        }
        boolean bl = isFunction = this.externalLocation != null ? this.externalLocation.isFunction() : false;
        if (this.externalLocation == null) {
            this.functionCheckBox.setSelected(isFunction);
        }
        this.extLibNameComboBox.requestFocus();
        this.isValidState = true;
    }

    private String getExtLibName() {
        String extLibName = null;
        if (this.extLibNameComboBox != null && (extLibName = this.extLibNameComboBox.getText()) != null) {
            extLibName = extLibName.trim();
        }
        return extLibName;
    }

    private String getExtLibPath() {
        String extLibPath = this.extLibPathTextField.getText();
        if (extLibPath != null) {
            extLibPath = extLibPath.trim();
        }
        return extLibPath;
    }

    private String getLocationName() {
        String locationName = this.extLabelTextField.getText();
        if (locationName != null) {
            locationName = locationName.trim();
        }
        return locationName;
    }

    private boolean validateChanges() {
        return this.validLibName() && this.validLibPath() && this.validLocation();
    }

    private boolean validLibName() {
        String extLibName = this.getExtLibName();
        if (extLibName == null || extLibName.length() == 0) {
            this.showInputErr("An external library 'Name' must be specified.");
            return false;
        }
        return true;
    }

    private boolean validLibPath() {
        Project project;
        ProjectData projectData;
        DomainFile file;
        String extLibPath = this.getExtLibPath();
        if (extLibPath != null && extLibPath.length() > 0 && !SystemUtilities.isEqual((Object)this.autoDeterminedExternalLibraryPath, (Object)extLibPath) && (file = (projectData = (project = AppInfo.getActiveProject()).getProjectData()).getFile(extLibPath, ProgramFileChooser.PROGRAM_FILE_FILTER)) == null) {
            this.showInputErr("Cannot find the program for the specified library 'Path' of " + extLibPath + ".");
            return false;
        }
        return true;
    }

    private boolean validLocation() {
        String locationName = this.getLocationName();
        boolean hasLocationName = locationName != null && locationName.length() > 0;
        boolean hasLocationAddress = this.extAddressInputWidget.hasInput();
        if (!hasLocationName && !hasLocationAddress) {
            this.showInputErr("Either (or both) an external 'Label' and/or 'Address' must be specified.");
            return false;
        }
        if (!this.validLocationName()) {
            return false;
        }
        return this.validLocationAddress();
    }

    private boolean validLocationName() {
        int result;
        ExternalManager externalManager;
        Set externalLocations;
        String extLibName = this.getExtLibName();
        if (extLibName == null || extLibName.length() == 0) {
            return true;
        }
        String locationName = this.getLocationName();
        if (locationName != null && locationName.length() > 0 && (externalLocations = (externalManager = this.program.getExternalManager()).getExternalLocations(extLibName, locationName)).size() == 1 && !externalLocations.contains(this.externalLocation) && (result = OptionDialog.showYesNoDialog(null, (String)"Duplicate External Name", (String)("Another symbol named '" + locationName + "' already exists in the '" + extLibName + "' library. Are you sure you want to create another?"))) == 2) {
            this.selectLocationName();
            return false;
        }
        return true;
    }

    private boolean validLocationAddress() {
        Address locationAddress;
        AddressSpace locationAddressSpace = this.extAddressInputWidget.getAddressSpace();
        if (locationAddressSpace != null && this.extAddressInputWidget.hasInput() && (locationAddress = this.extAddressInputWidget.getAddress()) == null) {
            this.showInputErr("Invalid address specified, " + locationAddressSpace.getName() + " offset must be in range: " + locationAddressSpace.getMinAddress().toString(false) + " to " + locationAddressSpace.getMaxAddress().toString(false));
            return false;
        }
        return true;
    }

    public boolean applyLocation() {
        if (!this.isValidState) {
            throw new IllegalStateException();
        }
        if (!this.validateChanges()) {
            return false;
        }
        String name = this.extLibNameComboBox.getText();
        if (name == null || name.trim().length() == 0) {
            this.showInputErr("An external program 'Name' must be specified.");
            return false;
        }
        name = name.trim();
        String libraryProgramPathname = this.extLibPathTextField.getText();
        Address addr = this.extAddressInputWidget.getAddress();
        String label = this.getLocationName();
        if (addr == null && this.extAddressInputWidget.hasInput()) {
            AddressSpace space = this.extAddressInputWidget.getAddressSpace();
            this.showInputErr("Invalid address specified, " + space.getName() + " offset must be in range: " + space.getMinAddress().toString(false) + " to " + space.getMaxAddress().toString(false));
            return false;
        }
        if (addr == null && (label == null || label.length() == 0)) {
            this.showInputErr("Either (or both) an external 'Label' and/or 'Address' must be specified.");
            return false;
        }
        try {
            if (this.externalLocation != null) {
                this.updateExternalLocation(this.externalLocation, name, libraryProgramPathname, label, addr);
                return true;
            }
            ExternalLocation extLocation = this.addExternalLocation(this.externalLocation, name, libraryProgramPathname, label, addr, this.functionCheckBox.isSelected());
            return extLocation != null;
        }
        catch (DuplicateNameException | InvalidInputException e) {
            this.showInputErr(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalLocation addExternalLocation(ExternalLocation extLocation, String libraryName, String libraryProgramPathname, String label, Address addr, boolean shouldBeFunction) throws InvalidInputException, DuplicateNameException {
        int txId = this.program.startTransaction("Create External Location");
        boolean success = false;
        try {
            ExternalManager externalManager = this.program.getExternalManager();
            this.getOrCreateExternalLibrary(libraryName, libraryProgramPathname);
            extLocation = externalManager.addExtLocation(libraryName, label, addr, SourceType.USER_DEFINED);
            if (shouldBeFunction && !extLocation.isFunction()) {
                extLocation.createFunction();
            }
            success = true;
            ExternalLocation externalLocation = extLocation;
            return externalLocation;
        }
        finally {
            this.program.endTransaction(txId, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalLocation(ExternalLocation extLocation, String libraryName, String libraryProgramPathname, String label, Address addr) throws InvalidInputException, DuplicateNameException {
        int txId = this.program.startTransaction("Create External Location");
        boolean success = false;
        try {
            Library library = this.getOrCreateExternalLibrary(libraryName, libraryProgramPathname);
            Symbol symbol = extLocation.getSymbol();
            Namespace parentNamespace = symbol.getParentNamespace();
            if (parentNamespace != library) {
                try {
                    symbol.setNamespace((Namespace)library);
                }
                catch (CircularDependencyException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            }
            extLocation.setLocation(label, addr, SourceType.USER_DEFINED);
            success = true;
        }
        finally {
            this.program.endTransaction(txId, success);
        }
    }

    private void restoreLibraryName() {
        if (this.startingExternalLibraryName != null) {
            this.extLibNameComboBox.setSelectedItem((Object)this.startingExternalLibraryName);
            ExternalManager externalManager = this.program.getExternalManager();
            this.autoDeterminedExternalLibraryPath = externalManager.getExternalLibraryPath(this.startingExternalLibraryName);
        }
        this.extProgNameChanged();
        this.updateExtLibPath();
    }

    private void selectLibraryName() {
        this.extLibNameComboBox.requestFocusInWindow();
        if (this.startingExternalLibraryName != null) {
            this.extLibNameComboBox.setSelectedItem((Object)this.startingExternalLibraryName);
            ExternalManager externalManager = this.program.getExternalManager();
            this.autoDeterminedExternalLibraryPath = externalManager.getExternalLibraryPath(this.startingExternalLibraryName);
        }
    }

    private void selectLocationName() {
        this.extLabelTextField.requestFocusInWindow();
        this.extLabelTextField.selectAll();
    }

    private Library getOrCreateExternalLibrary(String libraryName, String libraryProgramPathname) throws InvalidInputException {
        Library library;
        if (libraryName == null) {
            return null;
        }
        ExternalManager externalManager = this.program.getExternalManager();
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol s = symbolTable.getLibrarySymbol(libraryName);
        if (s != null) {
            library = (Library)s.getObject();
        } else {
            try {
                library = externalManager.addExternalLibraryName(libraryName, SourceType.USER_DEFINED);
            }
            catch (DuplicateNameException e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                this.showInputErr("Couldn't create external library name. " + message);
                this.restoreLibraryName();
                this.selectLibraryName();
                return null;
            }
        }
        if (libraryProgramPathname != null && libraryProgramPathname.length() > 0) {
            externalManager.setExternalPath(libraryName, libraryProgramPathname, true);
        }
        return library;
    }

    protected void showInputErr(String error) {
        Msg.showError((Object)this, (Component)this, (String)"Edit External Location Error", (Object)error);
    }

    void cleanup() {
        this.program = null;
        this.extLibNameComboBox.removeDocumentListener(this.nameDocumentListener);
        this.nameDocumentListener = null;
        this.extLibNameComboBox.removeItemListener(this.nameItemListener);
        this.nameItemListener = null;
        this.externalLocation = null;
        this.startingExternalLibraryName = null;
        this.startingLocationName = null;
        this.startingLocationAddress = null;
        this.autoDeterminedExternalLibraryPath = null;
    }
}

