/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.translate;

import docking.action.MenuData;
import ghidra.app.plugin.core.string.translate.AbstractTranslateAction;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.TranslationSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramTask;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ToggleShowTranslationAction
extends AbstractTranslateAction {
    private static final MenuData CODE_VIEWER_MENU_DATA = new MenuData(new String[]{"Data", "Translate", "Toggle show translation value"}, META_GROUP);
    private static final MenuData DATA_LIST_MENU_DATA = new MenuData(new String[]{"Translate", "Toggle show translation value"}, META_GROUP);

    public ToggleShowTranslationAction(String owner) {
        super("Toggle Show Translated Value", owner, CODE_VIEWER_MENU_DATA, DATA_LIST_MENU_DATA);
        this.setPopupMenuData(CODE_VIEWER_MENU_DATA);
        this.setHelpLocation(new HelpLocation(owner, "Toggle_Show_Translated_Value_Menuitem"));
    }

    @Override
    public void actionPerformed(Program program, List<ProgramLocation> dataLocations) {
        ToggleShowTranslationTask task = new ToggleShowTranslationTask(program, dataLocations);
        TaskLauncher.launch((Task)task);
    }

    private static class ToggleShowTranslationTask
    extends ProgramTask {
        private List<ProgramLocation> dataLocations;

        protected ToggleShowTranslationTask(Program program, List<ProgramLocation> dataLocations) {
            super(program, "Toggle show translated string", true, true, true);
            this.dataLocations = dataLocations;
        }

        protected void doRun(TaskMonitor monitor) {
            monitor.initialize((long)this.dataLocations.size());
            for (ProgramLocation progLoc : this.dataLocations) {
                Data data;
                TranslationSettingsDefinition.TRANSLATION.setShowTranslated((Settings)data, !TranslationSettingsDefinition.TRANSLATION.isShowTranslated((Settings)(data = DataUtilities.getDataAtLocation((ProgramLocation)progLoc))));
            }
        }
    }
}

