/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.iterators;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import java.util.Iterator;

public class DataSearchAddressIterator
implements AddressIterator {
    private DataIterator dataIterator;
    private Data currentData;
    private Iterator<Address> currentIterator;
    private boolean forward;

    public DataSearchAddressIterator(DataIterator dataIterator, boolean forward) {
        this.dataIterator = dataIterator;
        this.forward = forward;
    }

    public boolean hasNext() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        return this.dataIterator.hasNext();
    }

    public Address next() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        this.currentData = this.dataIterator.next();
        AddressSet addresses = new AddressSet(this.currentData.getProgram(), this.currentData.getMinAddress(), this.currentData.getMaxAddress());
        this.currentIterator = addresses.getAddresses(this.forward);
        return this.currentIterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterator<Address> iterator() {
        return this;
    }
}

