/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.actions.KeyBindingUtils;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.FocusableEditor;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.textfield.GValidatedTextField;
import generic.theme.GColor;
import ghidra.app.plugin.core.compositeeditor.ComponentCellEditor;
import ghidra.app.plugin.core.compositeeditor.ComponentCellEditorListener;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModelListener;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerModel;
import ghidra.app.plugin.core.compositeeditor.DataTypeCellRenderer;
import ghidra.app.plugin.core.compositeeditor.DndTableCellRenderer;
import ghidra.app.plugin.core.compositeeditor.SearchControlPanel;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.app.util.datatype.NavigationDirection;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeTransferable;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.ColorUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.UsrException;
import ghidra.util.layout.VerticalLayout;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public abstract class CompositeEditorPanel<T extends Composite, M extends CompositeEditorModel<T>>
extends JPanel
implements CompositeEditorModelListener,
ComponentCellEditorListener,
Droppable {
    protected static final Border BEVELED_BORDER = BorderFactory.createLoweredBevelBorder();
    protected CompositeEditorProvider<T, M> provider;
    protected M model;
    protected GTable table;
    private JLabel statusLabel;
    private boolean editorAdjusting = false;
    protected DndTableCellRenderer dndTableCellRenderer;
    protected DndTableCellRenderer dndDtiCellRenderer;
    private DropTarget dropTarget;
    private DropTgtAdapter dropTargetAdapter;
    private DataFlavor[] acceptableFlavors;
    protected int lastDndAction = 0;
    protected SearchControlPanel searchPanel;

    public CompositeEditorPanel(M model, CompositeEditorProvider<T, M> provider) {
        super(new BorderLayout());
        JPanel infoPanel;
        this.provider = provider;
        this.model = model;
        this.createTable();
        JPanel lowerPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        JPanel bitViewerPanel = this.createBitViewerPanel();
        if (bitViewerPanel != null) {
            lowerPanel.add(bitViewerPanel);
        }
        if ((infoPanel = this.createInfoPanel()) != null) {
            this.adjustCompositeInfo();
            lowerPanel.add(infoPanel);
        }
        lowerPanel.add(this.createStatusPanel());
        this.add((Component)lowerPanel, "South");
        ((CompositeEditorModel)model).addCompositeEditorModelListener(this);
        this.setUpDragDrop();
        this.setFocusTraversalPolicy(new CompFocusTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
    }

    protected abstract boolean hasUncomittedEntry();

    protected abstract boolean hasInvalidEntry();

    protected abstract void comitEntryChanges();

    protected abstract List<Component> getFocusComponents();

    protected Composite getOriginalComposite() {
        return ((CompositeViewerModel)this.model).getOriginalComposite();
    }

    protected abstract void adjustCompositeInfo();

    public JTable getTable() {
        return this.table;
    }

    protected M getModel() {
        return this.model;
    }

    public void addEditorModelListener(CompositeEditorModelListener listener) {
        ((CompositeEditorModel)this.model).addCompositeEditorModelListener(listener);
    }

    public void removeEditorModelListener(CompositeEditorModelListener listener) {
        ((CompositeEditorModel)this.model).removeCompositeEditorModelListener(listener);
    }

    private void setupTableCellRenderer() {
        GTableCellRenderer cellRenderer = new GTableCellRenderer();
        DataTypeCellRenderer dtiCellRenderer = new DataTypeCellRenderer(((CompositeViewerModel)this.model).getOriginalDataTypeManager());
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)cellRenderer);
        this.table.setDefaultRenderer(DataTypeInstance.class, (TableCellRenderer)((Object)dtiCellRenderer));
    }

    boolean launchBitFieldEditor(int modelRow, int modelColumn) {
        return false;
    }

    private void setupTableCellEditor() {
        this.table.addPropertyChangeListener("tableCellEditor", evt -> {
            TableCellEditor fieldEditor = (TableCellEditor)evt.getNewValue();
            if (fieldEditor == null) {
                Swing.runLater(() -> ((CompositeEditorModel)this.model).endEditingField());
            } else {
                Swing.runLater(() -> {
                    int editingColumn;
                    int modelColumn;
                    int editingRow = this.table.getEditingRow();
                    if (editingRow < 0) {
                        return;
                    }
                    int modelRow = this.table.convertRowIndexToModel(editingRow);
                    if (!this.launchBitFieldEditor(modelRow, modelColumn = this.table.convertColumnIndexToModel(editingColumn = this.table.getEditingColumn()))) {
                        ((CompositeEditorModel)this.model).beginEditingField(modelRow, modelColumn);
                    }
                });
            }
        });
        ComponentStringCellEditor cellEditor = new ComponentStringCellEditor();
        ComponentOffsetCellEditor offsetCellEditor = new ComponentOffsetCellEditor();
        ComponentDataTypeCellEditor dataTypeCellEditor = new ComponentDataTypeCellEditor();
        ComponentNameCellEditor nameCellEditor = new ComponentNameCellEditor();
        cellEditor.setComponentCellEditorListener(this);
        offsetCellEditor.setComponentCellEditorListener(this);
        nameCellEditor.setComponentCellEditorListener(this);
        this.table.setDefaultEditor(String.class, (TableCellEditor)((Object)cellEditor));
        TableColumnModel tcm = this.table.getColumnModel();
        int numCols = tcm.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            int column = this.table.convertColumnIndexToModel(i);
            if (column == ((CompositeEditorModel)this.model).getNameColumn()) {
                tcm.getColumn(column).setCellEditor((TableCellEditor)((Object)nameCellEditor));
                continue;
            }
            if (column == ((CompositeEditorModel)this.model).getDataTypeColumn()) {
                tcm.getColumn(column).setCellEditor(dataTypeCellEditor);
                continue;
            }
            if (column == ((CompositeEditorModel)this.model).getOffsetColumn()) {
                tcm.getColumn(column).setCellEditor((TableCellEditor)((Object)offsetCellEditor));
                continue;
            }
            tcm.getColumn(column).setCellEditor((TableCellEditor)((Object)cellEditor));
        }
    }

    public void selectField(String fieldName) {
        if (!((CompositeEditorModel)this.model).isLoaded()) {
            return;
        }
        int row = this.findRowForFieldName(fieldName);
        if (row == -1) {
            return;
        }
        this.table.getSelectionModel().setSelectionInterval(row, row);
    }

    private int findRowForFieldName(String fieldName) {
        int n = ((CompositeEditorModel)this.model).getRowCount();
        for (int row = 0; row < n; ++row) {
            DataTypeComponent dtc = ((CompositeEditorModel)this.model).getComponent(row);
            if (dtc == null) continue;
            String dtcFieldName = dtc.getFieldName();
            if (Objects.equals(fieldName, dtcFieldName)) {
                return row;
            }
            String defaultName = dtc.getDefaultFieldName();
            if (!Objects.equals(fieldName, defaultName)) continue;
            return row;
        }
        return -1;
    }

    protected void cancelCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        this.provider.closeDependentEditors();
    }

    protected void stopCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected void startCellEditing(int row, int viewColumn) {
        if (row >= 0 && viewColumn >= 0) {
            this.table.editCellAt(row, viewColumn, (EventObject)new KeyEvent((Component)this.table, 401, System.currentTimeMillis(), 0, 113, '\uffff'));
        }
    }

    @Override
    public void moveCellEditor(int direction, String value) {
        this.stopCellEditing();
        Swing.runLater(() -> this.doMoveCellEditor(direction, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doMoveCellEditor(int direction, String value) {
        if (this.editorAdjusting) {
            return;
        }
        try {
            this.editorAdjusting = true;
            if (this.table.isEditing()) {
                return;
            }
            int currentRow = ((CompositeEditorModel)this.model).getRow();
            switch (direction) {
                case 1: {
                    this.editNextField(currentRow);
                    return;
                }
                case 2: {
                    this.editPreviousField(currentRow);
                    return;
                }
                case 3: {
                    this.editAboveField();
                    return;
                }
                case 4: {
                    this.editBelowField();
                    return;
                }
            }
            return;
        }
        finally {
            this.editorAdjusting = false;
        }
    }

    private boolean beginEditField(int row, int modelColumn) {
        int viewColumn = this.table.convertColumnIndexToView(modelColumn);
        this.scrollToCell(row, viewColumn);
        this.table.setColumnSelectionInterval(viewColumn, viewColumn);
        this.startCellEditing(row, viewColumn);
        return this.table.isEditing();
    }

    protected boolean locateNextEditField(int currentRow) {
        int row = currentRow;
        int modelColumn = ((CompositeEditorModel)this.model).getColumn();
        boolean foundEditable = false;
        int index = row;
        int fieldNum = this.table.convertColumnIndexToView(modelColumn);
        int numFields = this.table.getColumnCount();
        int numComps = ((CompositeEditorModel)this.model).getRowCount();
        while (index < numComps) {
            if (++fieldNum < numFields) {
                if (this.table.isCellEditable(index, fieldNum)) {
                    foundEditable = true;
                }
            } else {
                if (++index >= numComps && index != numComps) break;
                fieldNum = 0;
                if (this.table.isCellEditable(index, fieldNum)) {
                    foundEditable = true;
                }
            }
            if (!foundEditable) continue;
        }
        if (foundEditable) {
            row = index;
            modelColumn = this.table.convertColumnIndexToModel(fieldNum);
            this.table.setRowSelectionInterval(row, row);
            ((CompositeEditorModel)this.model).setRow(row);
            ((CompositeEditorModel)this.model).setColumn(modelColumn);
        }
        return foundEditable;
    }

    protected boolean locatePreviousEditField(int currentRow) {
        int row = currentRow;
        int modelColumn = ((CompositeEditorModel)this.model).getColumn();
        boolean foundEditable = false;
        int index = row;
        int fieldNum = this.table.convertColumnIndexToView(modelColumn);
        do {
            if (--fieldNum >= 0) {
                if (!((CompositeEditorModel)this.model).isCellEditable(index, this.table.convertColumnIndexToModel(fieldNum))) continue;
                foundEditable = true;
                continue;
            }
            if (--index < 0) break;
            fieldNum = ((CompositeEditorModel)this.model).getColumnCount() - 1;
            if (!((CompositeEditorModel)this.model).isCellEditable(index, this.table.convertColumnIndexToModel(fieldNum))) continue;
            foundEditable = true;
        } while (!foundEditable);
        if (foundEditable) {
            row = index;
            modelColumn = this.table.convertColumnIndexToModel(fieldNum);
            this.table.setRowSelectionInterval(row, row);
            ((CompositeEditorModel)this.model).setRow(row);
            ((CompositeEditorModel)this.model).setColumn(modelColumn);
        }
        return foundEditable;
    }

    protected boolean editAboveField() {
        int row = ((CompositeEditorModel)this.model).getRow();
        int modelColumn = ((CompositeEditorModel)this.model).getColumn();
        int index = row;
        if (--index >= 0) {
            row = index;
            this.table.setRowSelectionInterval(row, row);
            if (((CompositeEditorModel)this.model).isCellEditable(row, modelColumn)) {
                return this.beginEditField(row, modelColumn);
            }
        }
        return false;
    }

    protected boolean editBelowField() {
        int row = ((CompositeEditorModel)this.model).getRow();
        int modelColumn = ((CompositeEditorModel)this.model).getColumn();
        int index = row;
        int numComps = ((CompositeEditorModel)this.model).getRowCount();
        if (++index < numComps) {
            row = index;
            this.table.setRowSelectionInterval(row, row);
            if (((CompositeEditorModel)this.model).isCellEditable(row, modelColumn)) {
                return this.beginEditField(row, modelColumn);
            }
        }
        return false;
    }

    protected boolean editNextField(int currentRow) {
        if (this.locateNextEditField(currentRow)) {
            return this.beginEditField(((CompositeEditorModel)this.model).getRow(), ((CompositeEditorModel)this.model).getColumn());
        }
        return false;
    }

    protected boolean editPreviousField(int currentRow) {
        if (this.locatePreviousEditField(currentRow)) {
            return this.beginEditField(((CompositeEditorModel)this.model).getRow(), ((CompositeEditorModel)this.model).getColumn());
        }
        return false;
    }

    private void scrollToCell(int rowIndex, int columnIndex) {
        Rectangle cellRect;
        if (this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(rowIndex, columnIndex, false)) != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        ((CompositeEditorModel)this.model).removeCompositeEditorModelListener(this);
        this.table.dispose();
    }

    private void createTable() {
        this.table = new CompositeEditorTable((TableModel)this.model);
        TableColumnModel columnModel = this.table.getColumnModel();
        if (columnModel instanceof GTableColumnModel) {
            GTableColumnModel gColumnModel = (GTableColumnModel)columnModel;
            List<TableColumn> hiddenColumns = ((CompositeViewerModel)this.model).getHiddenColumns();
            for (TableColumn column : hiddenColumns) {
                gColumnModel.addHiddenColumn(column);
            }
        }
        this.table.setAutoEditEnabled(false);
        this.table.addMouseListener((MouseListener)new CompositeTableMouseListener());
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ((CompositeEditorModel)this.model).setSelection(this.table.getSelectedRows());
            if (this.table.getAutoscrolls()) {
                this.table.scrollToSelectedRow();
            }
        });
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            TableColumnModel cm = this.table.getColumnModel();
            int[] selected = cm.getSelectedColumns();
            if (selected.length == 1) {
                int viewIndex = selected[0];
                int modelIndex = this.table.convertColumnIndexToModel(viewIndex);
                ((CompositeEditorModel)this.model).setColumn(modelIndex);
            } else {
                ((CompositeEditorModel)this.model).setColumn(e.getFirstIndex());
            }
        });
        JPanel tablePanel = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane((Component)this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(((CompositeEditorModel)this.model).getWidth(), 250));
        this.table.setSelectionMode(2);
        tablePanel.add((Component)sp, "Center");
        this.searchPanel = new SearchControlPanel(this);
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.searchPanel, new HelpLocation("DataTypeEditors", "Searching_In_Editor"));
        tablePanel.add((Component)this.searchPanel, "South");
        this.add((Component)tablePanel, "Center");
        JTableHeader header = this.table.getTableHeader();
        header.setUpdateTableInRealTime(true);
        this.table.setAutoResizeMode(3);
        for (int i = 0; i < ((CompositeEditorModel)this.model).getColumnCount(); ++i) {
            TableColumn tc = this.table.getColumn((Object)((CompositeEditorModel)this.model).getColumnName(i));
            tc.setPreferredWidth(((CompositeEditorModel)this.model).getFieldWidth(i));
        }
        this.setupTableCellRenderer();
        this.setupTableCellEditor();
        this.selectionChanged();
        Color gridColor = this.table.getGridColor();
        Color tableBackground = this.table.getBackground();
        if (tableBackground.equals(gridColor)) {
            this.table.setGridColor((Color)new GColor("color.bg.table.grid"));
        }
    }

    protected JPanel createBitViewerPanel() {
        return null;
    }

    protected JPanel createInfoPanel() {
        return null;
    }

    private JPanel createStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.statusLabel = new GDLabel(" ");
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setForeground((Color)new GColor("color.fg.dialog.status.normal"));
        this.statusLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CompositeEditorPanel.this.updateStatusToolTip();
            }
        });
        panel.add((Component)this.statusLabel, "Center");
        this.statusLabel.setName("Editor Status");
        return panel;
    }

    public void setStatus(String status) {
        if (StringUtils.isEmpty((CharSequence)status)) {
            status = " ";
        }
        if (this.statusLabel != null) {
            this.statusLabel.setText(status);
            this.updateStatusToolTip();
        } else {
            this.provider.setStatusMessage(status);
        }
    }

    private void updateStatusToolTip() {
        String text = this.statusLabel.getText();
        FontMetrics fm = this.statusLabel.getFontMetrics(this.statusLabel.getFont());
        int messageWidth = 0;
        if (fm != null && text != null) {
            messageWidth = fm.stringWidth(text);
        }
        if (messageWidth > this.statusLabel.getWidth()) {
            this.statusLabel.setToolTipText(text);
        } else {
            this.statusLabel.setToolTipText("Editor messages appear here.");
        }
    }

    protected JPanel createNamedTextPanel(JTextField textField, String name) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        GLabel label = new GLabel(name + ":", 4);
        label.setPreferredSize(new Dimension(label.getPreferredSize()));
        panel.add((Component)label);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(textField);
        this.provider.registerHelp(textField, name);
        return panel;
    }

    protected JPanel createHorizontalPanel(JComponent[] comps) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0) {
                panel.add(Box.createHorizontalStrut(10));
            }
            panel.add(comps[i]);
        }
        return panel;
    }

    protected JPanel createVerticalPanel(JComponent[] comps) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0) {
                panel.add(Box.createVerticalStrut(5));
            }
            panel.add(comps[i]);
        }
        return panel;
    }

    private void setUpDragDrop() {
        TableCellRenderer defRenderer = this.table.getDefaultRenderer(String.class);
        this.dndTableCellRenderer = new DndTableCellRenderer(defRenderer, (JTable)this.table);
        this.dndTableCellRenderer.setBorderColor(ColorUtils.deriveBackground((Color)this.table.getSelectionBackground(), (float)0.41666666f));
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)this.dndTableCellRenderer);
        TableCellRenderer dtiRenderer = this.table.getDefaultRenderer(DataTypeInstance.class);
        this.dndDtiCellRenderer = new DndTableCellRenderer(dtiRenderer, (JTable)this.table);
        this.dndDtiCellRenderer.setBorderColor(ColorUtils.deriveBackground((Color)this.table.getSelectionBackground(), (float)0.41666666f));
        this.table.setDefaultRenderer(DataTypeInstance.class, (TableCellRenderer)this.dndDtiCellRenderer);
        this.acceptableFlavors = new DataFlavor[]{DataTypeTransferable.localDataTypeFlavor, DataTypeTransferable.localBuiltinDataTypeFlavor};
        this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, this.acceptableFlavors);
        this.dropTarget = new DropTarget((Component)this.table, 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.dropTarget.setActive(true);
    }

    public boolean isDropOk(DropTargetDragEvent e) {
        return true;
    }

    public void add(Object obj, DropTargetDropEvent e, DataFlavor f) {
        if (!(obj instanceof DataType)) {
            ((CompositeEditorModel)this.model).setStatus("Only data types can be dropped here.", true);
            return;
        }
        ((CompositeEditorModel)this.model).clearStatus();
        DataType draggedDataType = (DataType)obj;
        Point p = e.getLocation();
        if (e.getDropAction() == 1) {
            this.insertAtPoint(p, draggedDataType);
        } else {
            this.addAtPoint(p, draggedDataType);
        }
    }

    public void insertAtPoint(Point p, DataType dt) {
        this.endFieldEditing();
        int currentIndex = this.table.rowAtPoint(p);
        try {
            ((CompositeEditorModel)this.model).insert(currentIndex, dt);
        }
        catch (UsrException e) {
            ((CompositeEditorModel)this.model).setStatus(e.getMessage(), true);
        }
    }

    public void addAtPoint(Point p, DataType dt) {
        this.endFieldEditing();
        int currentIndex = this.table.rowAtPoint(p);
        try {
            ((CompositeEditorModel)this.model).add(currentIndex, dt);
        }
        catch (UsrException e) {
            ((CompositeEditorModel)this.model).setStatus(e.getMessage(), true);
        }
        this.provider.contextChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        GTable gTable = this.table;
        synchronized (gTable) {
            int dropAction = e.getDropAction();
            boolean actionChanged = false;
            if (dropAction != this.lastDndAction) {
                actionChanged = true;
                this.lastDndAction = dropAction;
            }
            if (this.table.isEditing()) {
                this.table.editingCanceled(null);
            }
            this.dndTableCellRenderer.selectRange(true);
            this.dndDtiCellRenderer.selectRange(true);
            Point p = e.getLocation();
            int row = this.table.rowAtPoint(p);
            boolean setRow = this.dndTableCellRenderer.setRowForFeedback(row);
            boolean setDtiRow = this.dndDtiCellRenderer.setRowForFeedback(row);
            if (actionChanged || setRow || setDtiRow) {
                this.table.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoDragUnderFeedback() {
        GTable gTable = this.table;
        synchronized (gTable) {
            this.dndTableCellRenderer.setRowForFeedback(-1);
            this.dndDtiCellRenderer.setRowForFeedback(-1);
            this.table.repaint();
        }
    }

    @Override
    public void compositeEditStateChanged(int type) {
        switch (type) {
            case 3: {
                this.cancelCellEditing();
                this.provider.updateTitle();
                break;
            }
            case 4: {
                this.cancelCellEditing();
                this.provider.updateTitle();
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 5: {
                if (this.table.isEditing()) {
                    return;
                }
                this.beginEditField(((CompositeEditorModel)this.model).getRow(), ((CompositeEditorModel)this.model).getColumn());
                break;
            }
            case 6: {
                break;
            }
            default: {
                ((CompositeEditorModel)this.model).setStatus("Unrecognized edit state: " + type, true);
            }
        }
    }

    @Override
    public void endFieldEditing() {
        this.stopCellEditing();
        if (this.table.isEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void statusChanged(String message, boolean beep) {
        if (message == null || message.length() == 0) {
            message = " ";
        }
        this.setStatus(message);
        if (beep) {
            this.getToolkit().beep();
        }
    }

    void search(String searchText, boolean forward) {
        Integer row;
        searchText = searchText.toLowerCase();
        Integer n = row = forward ? this.findForward(searchText) : this.findBackward(searchText);
        if (row != null) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
            Rectangle cellRect = this.table.getCellRect(row.intValue(), 0, true);
            this.table.scrollRectToVisible(cellRect);
        }
    }

    private Integer findForward(String text) {
        int col;
        int row;
        String searchText = text.toLowerCase();
        int colCount = this.table.getColumnCount();
        int currentRow = Math.max(0, ((CompositeEditorModel)this.model).getRow());
        int rowCount = ((CompositeEditorModel)this.model).getRowCount();
        for (row = currentRow + 1; row < rowCount; ++row) {
            for (col = 0; col < colCount; ++col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                return row;
            }
        }
        for (row = 0; row < currentRow; ++row) {
            for (col = 0; col < colCount; ++col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                this.getToolkit().beep();
                return row;
            }
        }
        this.getToolkit().beep();
        return null;
    }

    private Integer findBackward(String text) {
        int col;
        int row;
        String searchText = text.toLowerCase();
        int colCount = this.table.getColumnCount();
        int currentRow = Math.max(0, ((CompositeEditorModel)this.model).getRow());
        for (row = currentRow - 1; row >= 0; --row) {
            for (col = colCount - 1; col >= 0; --col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                return row;
            }
        }
        for (row = ((CompositeEditorModel)this.model).getRowCount() - 1; row >= currentRow; --row) {
            for (col = colCount - 1; col >= 0; --col) {
                if (!this.matchesSearch(searchText, row, col)) continue;
                this.getToolkit().beep();
                return row;
            }
        }
        this.getToolkit().beep();
        return null;
    }

    private boolean matchesSearch(String searchText, int viewRow, int viewCol) {
        int modelRow = viewRow;
        int modelCol = this.table.convertColumnIndexToModel(viewCol);
        Object valueAt = ((CompositeEditorModel)this.model).getValueAt(modelRow, modelCol);
        if (valueAt == null) {
            return false;
        }
        String value = this.getString(valueAt).toLowerCase();
        if (viewCol == ((CompositeEditorModel)this.model).getNameColumn()) {
            return this.nameMatchesSearch(searchText, modelRow, value);
        }
        return value.contains(searchText);
    }

    private boolean nameMatchesSearch(String searchText, int row, String value) {
        if (value.contains(searchText)) {
            return true;
        }
        DataTypeComponent dtc = ((CompositeEditorModel)this.model).getComponent(row);
        if (dtc != null) {
            String defaultName = dtc.getDefaultFieldName().toLowerCase();
            return defaultName.contains(searchText);
        }
        return false;
    }

    private String getString(Object object) {
        if (object instanceof DataTypeInstance) {
            return ((DataTypeInstance)object).getDataType().getName();
        }
        return object.toString();
    }

    @Override
    public void selectionChanged() {
        int[] mRows;
        int[] tRows = this.table.getSelectedRows();
        if (Arrays.equals(tRows, mRows = ((CompositeViewerModel)this.model).getSelectedRows())) {
            return;
        }
        FieldSelection fs = ((CompositeEditorModel)this.model).getSelection();
        ListSelectionModel lsm = this.table.getSelectionModel();
        ListSelectionModel clsm = this.table.getColumnModel().getSelectionModel();
        lsm.clearSelection();
        int num = fs.getNumRanges();
        for (int i = 0; i < num; ++i) {
            FieldRange range = fs.getFieldRange(i);
            BigInteger startIndex = range.getStart().getIndex();
            BigInteger endIndex = range.getEnd().getIndex();
            lsm.addSelectionInterval(startIndex.intValue(), endIndex.intValue() - 1);
        }
        int modelColumn = ((CompositeEditorModel)this.model).getColumn();
        int viewColumn = this.table.convertColumnIndexToView(modelColumn);
        clsm.setSelectionInterval(viewColumn, viewColumn);
    }

    private class CompFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private CompFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            List<Component> list = CompositeEditorPanel.this.getFocusComponents();
            return this.getNext(aComponent, list);
        }

        private Component getNext(Component component, List<Component> list) {
            Component next;
            int currentIndex = list.indexOf(component);
            if (currentIndex < 0) {
                return this.getNextGroupComponent(component, list);
            }
            int nextIndex = currentIndex + 1;
            if (nextIndex == list.size()) {
                nextIndex = 0;
            }
            if (!(next = list.get(nextIndex)).isFocusable() || !next.isEnabled()) {
                return this.getNext(next, list);
            }
            return next;
        }

        private Component getNextGroupComponent(Component component, List<Component> list) {
            Component sibling = this.findSibling(component, list);
            if (sibling == null) {
                return list.get(0);
            }
            return this.getNext(sibling, list);
        }

        private Component getPreviousGroupComponent(Component component, List<Component> list) {
            Component sibling = this.findSibling(component, list);
            if (sibling == null) {
                return list.get(0);
            }
            return this.getPrevious(sibling, list);
        }

        private Component findSibling(Component component, List<Component> list) {
            Component[] siblings;
            Container parent = component.getParent();
            for (Component sibling : siblings = parent.getComponents()) {
                if (!list.contains(sibling)) continue;
                return sibling;
            }
            return null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            List<Component> list = CompositeEditorPanel.this.getFocusComponents();
            return this.getPrevious(aComponent, list);
        }

        private Component getPrevious(Component aComponent, List<Component> list) {
            Component previous;
            int currentIndex = list.indexOf(aComponent);
            if (currentIndex < 0) {
                return this.getPreviousGroupComponent(aComponent, list);
            }
            int previousIndex = currentIndex - 1;
            if (previousIndex == -1) {
                previousIndex = list.size() - 1;
            }
            if (!(previous = list.get(previousIndex)).isFocusable() || !previous.isEnabled()) {
                return this.getPrevious(previous, list);
            }
            return previous;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            List<Component> list = CompositeEditorPanel.this.getFocusComponents();
            return list.get(0);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            List<Component> list = CompositeEditorPanel.this.getFocusComponents();
            return list.get(list.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            List<Component> list = CompositeEditorPanel.this.getFocusComponents();
            return list.get(0);
        }
    }

    private class ComponentStringCellEditor
    extends ComponentCellEditor {
        public ComponentStringCellEditor(JTextField textField) {
            super(textField);
            this.getComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CompositeEditorPanel.this.endFieldEditing();
                }
            });
        }

        public ComponentStringCellEditor() {
            this(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
            ((CompositeEditorModel)CompositeEditorPanel.this.model).clearStatus();
            return super.getTableCellEditorComponent(table1, value, isSelected, row, column);
        }
    }

    private class ComponentOffsetCellEditor
    extends ComponentStringCellEditor {
        JTextField offsetField;

        public ComponentOffsetCellEditor() {
            super((JTextField)new GValidatedTextField.LongField(8));
            this.offsetField = (JTextField)this.editorComponent;
        }

        public boolean stopCellEditing() {
            try {
                ((CompositeEditorModel)CompositeEditorPanel.this.model).validateComponentOffset(CompositeEditorPanel.this.table.getEditingRow(), this.offsetField.getText());
                this.fireEditingStopped();
                return true;
            }
            catch (UsrException ue) {
                ((CompositeEditorModel)CompositeEditorPanel.this.model).setStatus(ue.getMessage(), true);
                return false;
            }
        }
    }

    private class ComponentDataTypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusableEditor {
        private DataTypeSelectionEditor editor;
        private DropDownSelectionTextField<DataType> textField;
        private DataType dt;
        private int maxLength;
        private boolean bitfieldAllowed;

        private ComponentDataTypeCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
            ((CompositeEditorModel)CompositeEditorPanel.this.model).clearStatus();
            this.maxLength = ((CompositeEditorModel)CompositeEditorPanel.this.model).getMaxAddLength(row);
            this.bitfieldAllowed = ((CompositeEditorModel)CompositeEditorPanel.this.model).isBitFieldAllowed();
            this.init();
            DataTypeInstance dti = (DataTypeInstance)value;
            this.dt = dti != null ? dti.getDataType() : null;
            this.editor.setCellEditorValue(this.dt);
            return this.editor.getEditorComponent();
        }

        private void init() {
            Plugin plugin = CompositeEditorPanel.this.provider.getPlugin();
            PluginTool tool = plugin.getTool();
            this.editor = new DataTypeSelectionEditor((DataTypeManager)((CompositeEditorModel)CompositeEditorPanel.this.model).getViewDataTypeManager(), (ServiceProvider)tool, this.bitfieldAllowed ? DataTypeParser.AllowedDataTypes.SIZABLE_DYNAMIC_AND_BITFIELD : DataTypeParser.AllowedDataTypes.SIZABLE_DYNAMIC);
            this.editor.setTabCommitsEdit(true);
            this.editor.setConsumeEnterKeyPress(false);
            this.textField = this.editor.getDropDownTextField();
            this.editor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                    ComponentDataTypeCellEditor.this.cancelCellEditing();
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    ComponentDataTypeCellEditor.this.stopCellEditing();
                }
            });
            this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ComponentDataTypeCellEditor.this.textField.selectAll();
                    ComponentDataTypeCellEditor.this.textField.removeFocusListener((FocusListener)this);
                }
            });
        }

        public void focusEditor() {
            this.textField.requestFocusInWindow();
        }

        @Override
        public Object getCellEditorValue() {
            return this.dt;
        }

        @Override
        public boolean stopCellEditing() {
            int editingColumn = CompositeEditorPanel.this.table.getEditingColumn();
            ((CompositeEditorModel)CompositeEditorPanel.this.model).setStatus("");
            if (!this.isEmptyEditorCell() && !this.validateUserChoice()) {
                return false;
            }
            ListSelectionModel columnSelectionModel = CompositeEditorPanel.this.table.getColumnModel().getSelectionModel();
            columnSelectionModel.setValueIsAdjusting(true);
            DataType dataType = (DataType)this.editor.getCellEditorValue();
            if (dataType != null) {
                if (dataType.equals((Object)this.dt)) {
                    this.fireEditingCanceled();
                } else {
                    this.dt = dataType;
                    this.fireEditingStopped();
                }
            } else {
                this.fireEditingCanceled();
            }
            columnSelectionModel.setSelectionInterval(editingColumn, editingColumn);
            columnSelectionModel.setValueIsAdjusting(false);
            int editingRow = ((CompositeEditorModel)CompositeEditorPanel.this.model).getRow();
            NavigationDirection navigationDirection = this.editor.getNavigationDirection();
            if (navigationDirection == NavigationDirection.BACKWARD) {
                CompositeEditorPanel.this.editPreviousField(editingRow);
            } else if (navigationDirection == NavigationDirection.FORWARD) {
                CompositeEditorPanel.this.editNextField(editingRow);
            }
            return true;
        }

        private boolean isEmptyEditorCell() {
            String cellEditorValueAsText = this.editor.getCellEditorValueAsText();
            String cellText = cellEditorValueAsText.trim();
            return cellText.isEmpty();
        }

        private boolean validateUserChoice() {
            try {
                if (!this.editor.validateUserSelection()) {
                    ((CompositeEditorModel)CompositeEditorPanel.this.model).setStatus("Unrecognized data type of \"" + this.editor.getCellEditorValueAsText() + "\" entered.");
                    return false;
                }
                DataType dataType = (DataType)this.editor.getCellEditorValue();
                int dtLen = dataType.getLength();
                if (this.maxLength >= 0 && dtLen > this.maxLength) {
                    ((CompositeEditorModel)CompositeEditorPanel.this.model).setStatus(dataType.getDisplayName() + " doesn't fit within " + this.maxLength + " bytes, need " + dtLen + " bytes");
                    return false;
                }
            }
            catch (InvalidDataTypeException idte) {
                ((CompositeEditorModel)CompositeEditorPanel.this.model).setStatus(idte.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }
    }

    private class ComponentNameCellEditor
    extends ComponentStringCellEditor {
        private static final long serialVersionUID = 1L;

        public ComponentNameCellEditor() {
            super(new JTextField());
        }

        public boolean stopCellEditing() {
            try {
                ((CompositeEditorModel)CompositeEditorPanel.this.model).validateComponentName(CompositeEditorPanel.this.table.getEditingRow(), ((JTextComponent)this.getComponent()).getText());
                this.fireEditingStopped();
                return true;
            }
            catch (UsrException ue) {
                ((CompositeEditorModel)CompositeEditorPanel.this.model).setStatus(ue.getMessage(), true);
                return false;
            }
        }
    }

    private class CompositeEditorTable
    extends GTable {
        public CompositeEditorTable(TableModel model) {
            super(model);
        }

        protected void installEditKeyBinding() {
            KeyStroke keyStroke = KeyStroke.getKeyStroke("pressed F2");
            KeyBindingUtils.clearKeyBinding((JComponent)((Object)this), (KeyStroke)keyStroke);
        }
    }

    private class CompositeTableMouseListener
    extends MouseAdapter {
        private CompositeTableMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkMouseEvent(e);
        }

        private void checkMouseEvent(MouseEvent e) {
            DataType dt;
            boolean isStringColumn;
            boolean isPopup = e.isPopupTrigger();
            Point point = e.getPoint();
            int row = CompositeEditorPanel.this.table.rowAtPoint(point);
            int column = CompositeEditorPanel.this.table.columnAtPoint(point);
            int modelColumn = CompositeEditorPanel.this.table.convertColumnIndexToModel(column);
            int clickCount = e.getClickCount();
            if (!CompositeEditorPanel.this.table.isEditing() && e.getID() == 501) {
                ((CompositeEditorModel)CompositeEditorPanel.this.model).clearStatus();
            }
            if (isPopup) {
                if (!CompositeEditorPanel.this.table.isRowSelected(row)) {
                    CompositeEditorPanel.this.table.setRowSelectionInterval(row, row);
                }
                return;
            }
            if (clickCount < 2 || e.getButton() != 1) {
                return;
            }
            if (((CompositeEditorModel)CompositeEditorPanel.this.model).isCellEditable(row, modelColumn)) {
                return;
            }
            String columnName = ((CompositeEditorModel)CompositeEditorPanel.this.model).getColumnName(modelColumn);
            String status = columnName + " field is not editable";
            boolean isValidRow = row >= 0 && row < ((CompositeEditorModel)CompositeEditorPanel.this.model).getNumComponents();
            boolean bl = isStringColumn = modelColumn == ((CompositeEditorModel)CompositeEditorPanel.this.model).getNameColumn() || modelColumn == ((CompositeEditorModel)CompositeEditorPanel.this.model).getCommentColumn();
            if (isValidRow && isStringColumn && (dt = ((CompositeEditorModel)CompositeEditorPanel.this.model).getComponent(row).getDataType()) == DataType.DEFAULT) {
                status = columnName + " field is not editable for Undefined byte.";
            }
            ((CompositeEditorModel)CompositeEditorPanel.this.model).setStatus(status);
            e.consume();
        }
    }
}

