/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.trable;

import docking.widgets.trable.AbstractGTrableRowModel;
import docking.widgets.trable.GTrableRow;
import java.util.ArrayList;
import java.util.List;

public class DefaultGTrableRowModel<T extends GTrableRow<T>>
extends AbstractGTrableRowModel<T> {
    protected List<T> rows;

    public DefaultGTrableRowModel(List<T> roots) {
        this.rows = new ArrayList<T>(roots);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public T getRow(int index) {
        return (T)((GTrableRow)this.rows.get(index));
    }

    @Override
    public int getIndentLevel(int rowIndex) {
        return ((GTrableRow)this.rows.get(rowIndex)).getIndentLevel();
    }

    @Override
    public boolean isExpanded(int rowIndex) {
        return ((GTrableRow)this.rows.get(rowIndex)).isExpanded();
    }

    @Override
    public boolean isExpandable(int rowIndex) {
        return ((GTrableRow)this.rows.get(rowIndex)).isExpandable();
    }

    @Override
    public int collapseRow(int lineIndex) {
        GTrableRow row = (GTrableRow)this.rows.get(lineIndex);
        int indentLevel = row.getIndentLevel();
        int removedCount = this.removeIndentedRows(lineIndex + 1, indentLevel + 1);
        row.setExpanded(false);
        this.fireModelChanged();
        return removedCount;
    }

    protected int removeIndentedRows(int startIndex, int indentLevel) {
        int endIndex = this.findNextIndexAtLowerIndentLevel(startIndex, indentLevel);
        this.rows.subList(startIndex, endIndex).clear();
        return endIndex - startIndex;
    }

    protected int findNextIndexAtLowerIndentLevel(int startIndex, int indentLevel) {
        for (int i = startIndex; i < this.rows.size(); ++i) {
            GTrableRow line = (GTrableRow)this.rows.get(i);
            if (line.getIndentLevel() >= indentLevel) continue;
            return i;
        }
        return this.rows.size();
    }

    @Override
    public int expandRow(int lineIndex) {
        GTrableRow row = (GTrableRow)this.rows.get(lineIndex);
        if (!row.isExpandable() || row.isExpanded()) {
            return 0;
        }
        List children = row.getChildRows();
        this.rows.addAll(lineIndex + 1, children);
        row.setExpanded(true);
        this.fireModelChanged();
        return children.size();
    }
}

