/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tab;

import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.tab.GTabBorder;
import docking.widgets.tab.GTabPanel;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.util.layout.HorizontalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import resources.Icons;

public class GTab<T>
extends JPanel {
    private static final Border TAB_BORDER = new GTabBorder(false);
    private static final Border SELECTED_TAB_BORDER = new GTabBorder(true);
    private static final String SELECTED_FONT_TABS_ID = "font.widget.tabs.selected";
    private static final String FONT_TABS_ID = "font.widget.tabs";
    private static final Icon EMPTY16_ICON = Icons.EMPTY_ICON;
    private static final Icon CLOSE_ICON = new GIcon("icon.widget.tabs.close");
    private static final Icon HIGHLIGHT_CLOSE_ICON = new GIcon("icon.widget.tabs.close.highlight");
    private static final Color TAB_FG_COLOR = new GColor("color.fg.widget.tabs.unselected");
    private static final Color SELECTED_TAB_FG_COLOR = new GColor("color.fg.widget.tabs.selected");
    private static final Color HIGHLIGHTED_TAB_BG_COLOR = new GColor("color.bg.widget.tabs.highlighted");
    static final Color TAB_BG_COLOR = new GColor("color.bg.widget.tabs.unselected");
    static final Color SELECTED_TAB_BG_COLOR = new GColor("color.bg.widget.tabs.selected");
    private GTabPanel<T> tabPanel;
    private T value;
    private boolean selected;
    private JLabel closeLabel;
    private JLabel nameLabel;

    GTab(GTabPanel<T> gTabPanel, T value, boolean selected) {
        super((LayoutManager)new HorizontalLayout(10));
        this.tabPanel = gTabPanel;
        this.value = value;
        this.selected = selected;
        this.setBorder(selected ? SELECTED_TAB_BORDER : TAB_BORDER);
        this.nameLabel = new GDLabel();
        this.nameLabel.setName("Tab Label");
        this.nameLabel.setText(this.tabPanel.getDisplayName(value));
        this.nameLabel.setIcon(this.tabPanel.getValueIcon(value));
        this.nameLabel.setToolTipText(this.tabPanel.getValueToolTip(value));
        Gui.registerFont((Component)this.nameLabel, (String)(selected ? SELECTED_FONT_TABS_ID : FONT_TABS_ID));
        this.add((Component)this.nameLabel, "West");
        this.closeLabel = new GIconLabel(selected ? CLOSE_ICON : EMPTY16_ICON);
        this.closeLabel.setToolTipText("Close");
        this.closeLabel.setName("Close");
        this.closeLabel.setOpaque(true);
        this.add((Component)this.closeLabel, "East");
        GTabMouseListener listener = new GTabMouseListener();
        this.installMouseListener(this, listener);
        this.initializeTabColors(false);
    }

    T getValue() {
        return this.value;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.initializeTabColors(false);
    }

    void refresh() {
        this.nameLabel.setText(this.tabPanel.getDisplayName(this.value));
        this.nameLabel.setIcon(this.tabPanel.getValueIcon(this.value));
        this.nameLabel.setToolTipText(this.tabPanel.getValueToolTip(this.value));
        this.repaint();
    }

    void setHighlight(boolean b) {
        this.initializeTabColors(b);
    }

    private void installMouseListener(Container c, GTabMouseListener listener) {
        Component[] children;
        c.addMouseListener(listener);
        c.addMouseMotionListener(listener);
        for (Component element : children = c.getComponents()) {
            if (element instanceof Container) {
                this.installMouseListener((Container)element, listener);
                continue;
            }
            element.addMouseListener(listener);
            element.addMouseMotionListener(listener);
        }
    }

    private void initializeTabColors(boolean isHighlighted) {
        Color fg = this.getForegroundColor(isHighlighted);
        Color bg = this.getBackgroundColor(isHighlighted);
        this.setBackground(bg);
        this.nameLabel.setBackground(bg);
        this.nameLabel.setForeground(fg);
        this.closeLabel.setBackground(bg);
    }

    private Color getBackgroundColor(boolean isHighlighted) {
        if (isHighlighted) {
            return HIGHLIGHTED_TAB_BG_COLOR;
        }
        return this.selected ? SELECTED_TAB_BG_COLOR : TAB_BG_COLOR;
    }

    private Color getForegroundColor(boolean isHighlighted) {
        if (isHighlighted || this.selected) {
            return SELECTED_TAB_FG_COLOR;
        }
        return TAB_FG_COLOR;
    }

    private class GTabMouseListener
    extends MouseAdapter {
        private GTabMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            GTab.this.closeLabel.setIcon(e.getSource() == GTab.this.closeLabel ? HIGHLIGHT_CLOSE_ICON : CLOSE_ICON);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GTab.this.closeLabel.setIcon(GTab.this.selected ? CLOSE_ICON : EMPTY16_ICON);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!(e.getSource() instanceof JList)) {
                GTab.this.tabPanel.closeTabList();
            }
            if (e.isPopupTrigger()) {
                return;
            }
            if (e.getSource() == GTab.this.closeLabel) {
                GTab.this.tabPanel.closeTab(GTab.this.value);
                return;
            }
            if (!GTab.this.selected) {
                GTab.this.tabPanel.selectTab(GTab.this.value);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            GTab.this.tabPanel.mouseReleased(GTab.this, e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            GTab.this.tabPanel.mouseDragged(GTab.this, e);
        }
    }
}

