/*
 * Decompiled with CFR 0.152.
 */
package docking.util.image;

import docking.util.image.CalloutInfo;
import docking.util.image.DropShadow;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.util.image.ImageUtils;
import ghidra.util.Msg;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class Callout {
    private static final Color CALLOUT_SHAPE_COLOR = GThemeDefaults.Colors.Palette.getColor((String)"yellowgreen");
    private static final int CALLOUT_BORDER_PADDING = 20;

    public Image createCalloutOnImage(Image image, CalloutInfo calloutInfo) {
        try {
            return this.doCreateCalloutOnImage(image, calloutInfo);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Unexpected exception creating callout image", (Throwable)e);
            throw e;
        }
    }

    private Image doCreateCalloutOnImage(Image image, CalloutInfo calloutInfo) {
        int newHeight;
        int calloutHeight;
        Rectangle clientBounds = calloutInfo.getBounds();
        Dimension clientShapeSize = clientBounds.getSize();
        int calloutWidth = calloutHeight = (newHeight = clientShapeSize.height * 6);
        double offsetX = (double)calloutWidth * 1.5;
        double offsetY = calloutHeight * 2;
        int topPadding = 0;
        Point clientLocation = clientBounds.getLocation();
        double theta = Math.toRadians(45.0);
        int calloutX = (int)((double)clientLocation.x + Math.cos(theta) * offsetX);
        int calloutY = (int)((double)clientLocation.y - Math.sin(theta) * offsetY);
        Rectangle calloutShapeBounds = new Rectangle(calloutX, calloutY, calloutWidth, calloutHeight);
        Rectangle calloutBounds = clientBounds.union(calloutShapeBounds);
        BufferedImage calloutImage = this.createCalloutImage(calloutInfo, calloutShapeBounds, calloutBounds);
        calloutInfo.moveToDestination(calloutBounds);
        Point calloutLocation = calloutBounds.getLocation();
        int top = calloutLocation.y - 20;
        if (top < 0) {
            topPadding = -top;
        }
        DropShadow dropShadow = new DropShadow();
        Image shadow = dropShadow.createDropShadow(calloutImage, 40);
        ImageUtils.Padding padding = this.createImagePadding(image, shadow, calloutBounds, topPadding);
        GColor bg = GThemeDefaults.Colors.Palette.WHITE;
        Image paddedImage = ImageUtils.padImage((Image)image, (Color)bg, (ImageUtils.Padding)padding);
        Graphics g = paddedImage.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int paddedX = calloutLocation.x += padding.left();
        int paddedY = calloutLocation.y += padding.top();
        Point finalLocation = new Point(paddedX, paddedY);
        g2d.drawImage(shadow, finalLocation.x, finalLocation.y, null);
        g2d.drawImage((Image)calloutImage, finalLocation.x, finalLocation.y, null);
        return paddedImage;
    }

    private ImageUtils.Padding createImagePadding(Image fullImage, Image shadow, Rectangle calloutOnlyBounds, int topPad) {
        Point calloutLocation = calloutOnlyBounds.getLocation();
        int sw = shadow.getWidth(null);
        int sh = shadow.getHeight(null);
        Rectangle shadowBounds = new Rectangle(calloutLocation.x, calloutLocation.y, sw, sh);
        Rectangle combinedBounds = calloutOnlyBounds.union(shadowBounds);
        int endX = calloutLocation.x + combinedBounds.width;
        int overlap = endX - fullImage.getWidth(null);
        int rightPad = 0;
        if (overlap > 0) {
            rightPad = overlap + 20;
        }
        int endY = calloutLocation.y + combinedBounds.height;
        int bottomPad = 0;
        overlap = endY - fullImage.getHeight(null);
        if (overlap > 0) {
            bottomPad = overlap;
        }
        int leftPad = 0;
        return new ImageUtils.Padding(topPad, leftPad, rightPad, bottomPad);
    }

    private BufferedImage createCalloutImage(CalloutInfo calloutInfo, Rectangle calloutShapeBounds, Rectangle fullBounds) {
        BufferedImage calloutImage = new BufferedImage(fullBounds.width, fullBounds.height, 2);
        Graphics2D cg = (Graphics2D)calloutImage.getGraphics();
        cg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point calloutOrigin = fullBounds.getLocation();
        int sx = calloutShapeBounds.x - calloutOrigin.x;
        int sy = calloutShapeBounds.y - calloutOrigin.y;
        Ellipse2D.Double calloutShape = new Ellipse2D.Double(sx, sy, calloutShapeBounds.width, calloutShapeBounds.height);
        Rectangle clientBounds = calloutInfo.getBounds();
        Point clientLocation = clientBounds.getLocation();
        int cx = clientLocation.x - calloutOrigin.x;
        int cy = clientLocation.y - calloutOrigin.y;
        Dimension clientSize = clientBounds.getSize();
        Rectangle componentShape = new Rectangle(new Point(cx, cy), clientSize);
        this.paintCalloutArrow(cg, componentShape, calloutShape.getBounds());
        this.paintCalloutCircularImage(cg, calloutInfo, calloutShape);
        cg.dispose();
        return calloutImage;
    }

    private void paintCalloutCircularImage(Graphics2D g, CalloutInfo calloutInfo, RectangularShape shape) {
        g.setColor(CALLOUT_SHAPE_COLOR);
        g.fill(shape);
        int offset = 3;
        Rectangle sr = shape.getBounds();
        Rectangle ir = new Rectangle();
        ir.x = sr.x + offset;
        ir.y = sr.y + offset;
        ir.width = sr.width - 2 * offset;
        ir.height = sr.height - 2 * offset;
        shape.setFrame(ir);
        Dimension imageSize = ir.getSize();
        Image foregroundImage = this.createMagnifiedImage(g.getDeviceConfiguration(), imageSize, calloutInfo, shape);
        shape.setFrame(sr);
        g.drawImage(foregroundImage, ir.x, ir.y, null);
    }

    private void paintCalloutArrow(Graphics2D g2d, Rectangle componentShape, Rectangle calloutShape) {
        Rectangle cr = componentShape.getBounds();
        Rectangle sr = calloutShape.getBounds();
        Point p1 = new Point((int)cr.getCenterX(), (int)cr.getCenterY());
        Point p2 = new Point(sr.x + sr.width / 2, sr.y + sr.height / 2);
        int radius = sr.width / 2;
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        double distance = Math.sqrt(dx * dx + dy * dy);
        double alpha = Math.asin((double)radius / distance);
        double beta = Math.atan2(dy, dx);
        double theta = beta - alpha;
        double x = (double)radius * Math.sin(theta) + (double)p2.x;
        double y = (double)radius * -Math.cos(theta) + (double)p2.y;
        Point tangentA = new Point((int)Math.round(x), (int)Math.round(y));
        theta = beta + alpha;
        x = (double)radius * -Math.sin(theta) + (double)p2.x;
        y = (double)radius * Math.cos(theta) + (double)p2.y;
        Point tangentB = new Point((int)Math.round(x), (int)Math.round(y));
        g2d.setColor(CALLOUT_SHAPE_COLOR);
        Polygon p = new Polygon();
        p.addPoint(p1.x, p1.y);
        p.addPoint(tangentA.x, tangentA.y);
        p.addPoint(tangentB.x, tangentB.y);
        g2d.fillPolygon(p);
    }

    private Image createMagnifiedImage(GraphicsConfiguration gc, Dimension imageSize, CalloutInfo calloutInfo, RectangularShape imageShape) {
        Rectangle r = new Rectangle(calloutInfo.getBounds());
        calloutInfo.moveToScreen(r);
        int offset = 100;
        r.x -= offset;
        r.y -= offset;
        r.width += 2 * offset;
        r.height += 2 * offset;
        Image compImage = null;
        try {
            Robot robot = new Robot();
            compImage = robot.createScreenCapture(r);
        }
        catch (AWTException e) {
            throw new RuntimeException("Unable to create a Robot for capturing the screen", e);
        }
        double magnification = calloutInfo.getMagnification();
        int newWidth = (int)((double)compImage.getWidth(null) * magnification);
        int newHeight = (int)((double)compImage.getHeight(null) * magnification);
        compImage = ImageUtils.createScaledImage((Image)compImage, (int)newWidth, (int)newHeight, (int)0);
        Rectangle bounds = imageShape.getBounds();
        VolatileImage image = gc.createCompatibleVolatileImage(bounds.width, bounds.height, 3);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setComposite(AlphaComposite.Clear);
        Rectangle relativeFrame = new Rectangle(new Point(0, 0), bounds.getSize());
        imageShape.setFrame(relativeFrame);
        g.fill(relativeFrame);
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor((Color)GThemeDefaults.Colors.Palette.WHITE);
        g.fill(imageShape);
        imageShape.setFrame(bounds);
        g.setComposite(AlphaComposite.SrcAtop);
        int cw = compImage.getWidth(null);
        int ch = compImage.getHeight(null);
        int x = -(cw / 2 - bounds.width / 2);
        int y = -(ch / 2 - bounds.height / 2);
        g.drawImage(compImage, x, y, cw, ch, null);
        g.dispose();
        return image;
    }
}

