/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.SettableColorSwatchChooserPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.ColorChooserUI;

public class GhidraColorChooser
extends JColorChooser {
    private static final String DEFAULT_TITLE = "Please Choose a Color";
    private String title = "Please Choose a Color";
    private String activeTabName;
    private ColorHistoryCache historyColorCache = new ColorHistoryCache();
    private List<Color> recentColors = new ArrayList<Color>();

    public GhidraColorChooser() {
        this.init();
    }

    public GhidraColorChooser(Color initialColor) {
        super(initialColor);
        this.init();
    }

    @Override
    public void setUI(ColorChooserUI ui) {
        List<Color> history = this.getColorHistory();
        List<Color> recents = this.getRecentColors();
        super.setUI(ui);
        SettableColorSwatchChooserPanel swatchPanel = this.installSettableColorSwatchChooserPanel();
        swatchPanel.setRecentColors(recents);
        swatchPanel.setHistoryColors(history);
    }

    private void init() {
        JTabbedPane tabbedPane = this.findTabbedPane(this);
        tabbedPane.addChangeListener(e -> {
            if (!tabbedPane.isShowing()) {
                return;
            }
            int n = tabbedPane.getSelectedIndex();
            if (n != -1) {
                this.activeTabName = tabbedPane.getTitleAt(n);
            }
        });
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addColorToHistory(Color c) {
        this.historyColorCache.addColor(c);
        this.installHistoryColors();
    }

    public void setColorHistory(List<Color> colors) {
        for (Color color : colors) {
            this.historyColorCache.addColor(color);
        }
        this.installHistoryColors();
    }

    public List<Color> getColorHistory() {
        SettableColorSwatchChooserPanel swatchPanel = this.getCustomSwatchPanel();
        if (swatchPanel != null) {
            return swatchPanel.getHistoryColors();
        }
        if (this.historyColorCache != null) {
            return this.historyColorCache.getMRUColorList();
        }
        return Collections.emptyList();
    }

    public void setRecentColors(List<Color> colors) {
        this.recentColors.clear();
        if (colors != null) {
            this.recentColors.addAll(colors);
        }
        this.installRecentColors();
    }

    private void installHistoryColors() {
        SettableColorSwatchChooserPanel swatchPanel = this.installSettableColorSwatchChooserPanel();
        swatchPanel.setHistoryColors(this.historyColorCache.getMRUColorList());
    }

    private void installRecentColors() {
        SettableColorSwatchChooserPanel swatchPanel = this.installSettableColorSwatchChooserPanel();
        swatchPanel.setRecentColors(this.recentColors);
    }

    public List<Color> getRecentColors() {
        ArrayList<Color> results = new ArrayList<Color>();
        SettableColorSwatchChooserPanel swatchPanel = this.getCustomSwatchPanel();
        if (swatchPanel == null) {
            return results;
        }
        results.addAll(swatchPanel.getRecentColors());
        return results;
    }

    public void setActiveTab(String tabName) {
        this.activeTabName = tabName;
        this.doSetActiveTab();
    }

    public String getActiveTab() {
        return this.activeTabName;
    }

    public Color showDialog(Component centerOverComponent) {
        this.installHistoryColors();
        OKListener okListener = new OKListener();
        JDialog dialog = GhidraColorChooser.createDialog(centerOverComponent, this.title, true, this, okListener, null);
        dialog.show();
        Color color = okListener.getColor();
        if (color != null) {
            this.historyColorCache.addColor(color);
        }
        return color;
    }

    private void doSetActiveTab() {
        if (this.activeTabName == null) {
            return;
        }
        JTabbedPane pane = this.findTabbedPane(this);
        if (pane == null) {
            return;
        }
        int n = pane.getTabCount();
        for (int i = 0; i < n; ++i) {
            String tabTitle = pane.getTitleAt(i);
            if (!this.activeTabName.equals(tabTitle)) continue;
            pane.setSelectedIndex(i);
            return;
        }
    }

    private JTabbedPane findTabbedPane(Component component) {
        if (!(component instanceof Container)) {
            return null;
        }
        Container parent = (Container)component;
        if (parent instanceof JTabbedPane) {
            return (JTabbedPane)parent;
        }
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component child = parent.getComponent(i);
            JTabbedPane pane = this.findTabbedPane(child);
            if (pane == null) continue;
            return pane;
        }
        return null;
    }

    private SettableColorSwatchChooserPanel getCustomSwatchPanel() {
        AbstractColorChooserPanel panel;
        AbstractColorChooserPanel[] chooserPanels = this.getChooserPanels();
        if (chooserPanels != null & chooserPanels.length > 1 && (panel = chooserPanels[0]) instanceof SettableColorSwatchChooserPanel) {
            return (SettableColorSwatchChooserPanel)panel;
        }
        return null;
    }

    private SettableColorSwatchChooserPanel installSettableColorSwatchChooserPanel() {
        SettableColorSwatchChooserPanel swatchPanel = this.getCustomSwatchPanel();
        if (swatchPanel != null) {
            return swatchPanel;
        }
        AbstractColorChooserPanel[] chooserPanels = this.getChooserPanels();
        SettableColorSwatchChooserPanel newSwatchPanel = new SettableColorSwatchChooserPanel();
        AbstractColorChooserPanel[] newChooserPanels = new AbstractColorChooserPanel[chooserPanels.length];
        newChooserPanels[0] = newSwatchPanel;
        for (int i = 1; i < chooserPanels.length; ++i) {
            AbstractColorChooserPanel panel;
            newChooserPanels[i] = panel = chooserPanels[i];
        }
        this.setChooserPanels(newChooserPanels);
        return newSwatchPanel;
    }

    private class ColorHistoryCache
    extends LinkedHashMap<Color, Color>
    implements Iterable<Color> {
        private static final int MAX_SIZE = 35;

        public ColorHistoryCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Color, Color> eldest) {
            return this.size() > 35;
        }

        @Override
        public Iterator<Color> iterator() {
            return this.keySet().iterator();
        }

        public void addColor(Color color) {
            this.put(color, color);
        }

        public List<Color> getMRUColorList() {
            ArrayList<Color> list = new ArrayList<Color>(this.keySet());
            Collections.reverse(list);
            return list;
        }
    }

    private class OKListener
    implements ActionListener {
        private Color okColor;

        private OKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.okColor = GhidraColorChooser.this.getColor();
        }

        Color getColor() {
            return this.okColor;
        }
    }
}

