/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.tracermi;

import ghidra.debug.api.ValStr;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public record LaunchParameter<T>(Class<T> type, String name, String display, String description, boolean required, List<T> choices, ValStr<T> defaultValue, ValStr.Decoder<T> decoder) {
    public static <T> LaunchParameter<T> create(Class<T> type, String name, String display, String description, boolean required, ValStr<T> defaultValue, ValStr.Decoder<T> decoder) {
        return new LaunchParameter<T>(type, name, display, description, required, List.of(), defaultValue, decoder);
    }

    public static <T> LaunchParameter<T> choices(Class<T> type, String name, String display, String description, Collection<T> choices, ValStr<T> defaultValue) {
        return new LaunchParameter<Object>(type, name, display, description, false, List.copyOf(new LinkedHashSet<T>(choices)), defaultValue, str -> {
            for (Object t : choices) {
                if (!t.toString().equals(str)) continue;
                return t;
            }
            return null;
        });
    }

    public static Map<String, LaunchParameter<?>> mapOf(Collection<LaunchParameter<?>> parameters) {
        LinkedHashMap result = new LinkedHashMap();
        for (LaunchParameter<?> param : parameters) {
            LaunchParameter<?> exists = result.put(param.name(), param);
            if (exists == null) continue;
            throw new IllegalArgumentException("Duplicate names in parameter map: first=%s, second=%s".formatted(exists, param));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, ValStr<?>> validateArguments(Map<String, LaunchParameter<?>> parameters, Map<String, ValStr<?>> arguments) {
        if (!parameters.keySet().containsAll(arguments.keySet())) {
            TreeSet<String> extraneous = new TreeSet<String>(arguments.keySet());
            extraneous.removeAll(parameters.keySet());
            throw new IllegalArgumentException("Extraneous parameters: " + String.valueOf(extraneous));
        }
        LinkedHashMap<String, String> typeErrors = null;
        for (Map.Entry<String, ValStr<?>> ent : arguments.entrySet()) {
            String name = ent.getKey();
            ValStr<?> val = ent.getValue();
            LaunchParameter<?> param = parameters.get(name);
            if (val.val() == null || param.type.isAssignableFrom(val.val().getClass())) continue;
            if (typeErrors == null) {
                typeErrors = new LinkedHashMap<String, String>();
            }
            typeErrors.put(name, "val '%s' is not a %s".formatted(val.val(), param.type()));
        }
        if (typeErrors != null) {
            throw new IllegalArgumentException("Type errors: " + String.valueOf(typeErrors));
        }
        return arguments;
    }

    public static Map<String, LaunchParameter<?>> mapOf(LaunchParameter<?> ... parameters) {
        return LaunchParameter.mapOf(Arrays.asList(parameters));
    }

    public ValStr<T> decode(String string) {
        return this.decoder.decodeValStr(string);
    }

    public ValStr<T> get(Map<String, ValStr<?>> arguments) {
        if (arguments.containsKey(this.name)) {
            return ValStr.cast(this.type, arguments.get(this.name));
        }
        if (this.required) {
            throw new IllegalArgumentException("Missing required parameter '%s' (%s)".formatted(this.display, this.name));
        }
        return this.defaultValue;
    }

    public void set(Map<String, ValStr<?>> arguments, ValStr<T> value) {
        arguments.put(this.name, value);
    }
}

