/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.target;

import docking.ActionContext;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceExecutionState;
import ghidra.trace.model.breakpoint.TraceBreakpointCommon;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;

public interface Target {
    public static final long TIMEOUT_MILLIS = 10000L;

    public String describe();

    public boolean isValid();

    public Trace getTrace();

    public long getSnap();

    default public TraceSchedule getTime() {
        long snap = this.getSnap();
        if (snap >= 0L) {
            return TraceSchedule.snap((long)snap);
        }
        TraceSnapshot snapshot = this.getTrace().getTimeManager().getSnapshot(snap, false);
        if (snapshot == null) {
            return null;
        }
        return snapshot.getSchedule();
    }

    public TraceSchedule.ScheduleForm getSupportedTimeForm(TraceObject var1, long var2);

    public Map<String, ActionEntry> collectActions(ActionName var1, ActionContext var2, ObjectArgumentPolicy var3);

    public CompletableFuture<String> executeAsync(String var1, boolean var2);

    public String execute(String var1, boolean var2);

    public TraceThread getThreadForSuccessor(KeyPath var1);

    public TraceExecutionState getThreadExecutionState(TraceThread var1);

    public TraceStackFrame getStackFrameForSuccessor(KeyPath var1);

    public boolean isSupportsFocus();

    public KeyPath getFocus();

    public CompletableFuture<Void> activateAsync(DebuggerCoordinates var1, DebuggerCoordinates var2);

    public void activate(DebuggerCoordinates var1, DebuggerCoordinates var2);

    public CompletableFuture<Void> invalidateMemoryCachesAsync();

    public void invalidateMemoryCaches();

    public CompletableFuture<Void> readMemoryAsync(AddressSetView var1, TaskMonitor var2);

    public void readMemory(AddressSetView var1, TaskMonitor var2) throws CancelledException;

    public CompletableFuture<Void> writeMemoryAsync(Address var1, byte[] var2);

    public void writeMemory(Address var1, byte[] var2);

    public CompletableFuture<Void> readRegistersAsync(TracePlatform var1, TraceThread var2, int var3, Set<Register> var4);

    public void readRegisters(TracePlatform var1, TraceThread var2, int var3, Set<Register> var4);

    public CompletableFuture<Void> readRegistersAsync(TracePlatform var1, TraceThread var2, int var3, AddressSetView var4);

    public void readRegisters(TracePlatform var1, TraceThread var2, int var3, AddressSetView var4);

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform var1, TraceThread var2, int var3, RegisterValue var4);

    public void writeRegister(TracePlatform var1, TraceThread var2, int var3, RegisterValue var4);

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public void writeRegister(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public boolean isVariableExists(TracePlatform var1, TraceThread var2, int var3, Address var4, int var5);

    public CompletableFuture<Void> writeVariableAsync(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public void writeVariable(TracePlatform var1, TraceThread var2, int var3, Address var4, byte[] var5);

    public Set<TraceBreakpointKind> getSupportedBreakpointKinds();

    public CompletableFuture<Void> placeBreakpointAsync(AddressRange var1, Set<TraceBreakpointKind> var2, String var3, String var4);

    public void placeBreakpoint(AddressRange var1, Set<TraceBreakpointKind> var2, String var3, String var4);

    public boolean isBreakpointValid(TraceBreakpointLocation var1);

    public CompletableFuture<Void> deleteBreakpointAsync(TraceBreakpointCommon var1);

    public void deleteBreakpoint(TraceBreakpointCommon var1);

    public CompletableFuture<Void> toggleBreakpointAsync(TraceBreakpointCommon var1, boolean var2);

    public void toggleBreakpoint(TraceBreakpointCommon var1, boolean var2);

    public CompletableFuture<Void> forceTerminateAsync();

    public void forceTerminate();

    public CompletableFuture<Void> disconnectAsync();

    public void disconnect();

    public boolean isBusy();

    public void forciblyCloseTransactions();

    public static enum ObjectArgumentPolicy {
        CONTEXT_ONLY{

            @Override
            public boolean allowContextObject() {
                return true;
            }

            @Override
            public boolean allowCoordsObject() {
                return false;
            }

            @Override
            public boolean allowSuitableRelative() {
                return false;
            }
        }
        ,
        CURRENT_AND_RELATED{

            @Override
            public boolean allowContextObject() {
                return false;
            }

            @Override
            public boolean allowCoordsObject() {
                return true;
            }

            @Override
            public boolean allowSuitableRelative() {
                return true;
            }
        }
        ,
        EITHER_AND_RELATED{

            @Override
            public boolean allowContextObject() {
                return true;
            }

            @Override
            public boolean allowCoordsObject() {
                return true;
            }

            @Override
            public boolean allowSuitableRelative() {
                return true;
            }
        };


        public abstract boolean allowContextObject();

        public abstract boolean allowCoordsObject();

        public abstract boolean allowSuitableRelative();
    }

    public static interface ActionEntry {
        public String display();

        public ActionName name();

        public Icon icon();

        public String details();

        public boolean requiresPrompt();

        public long specificity();

        public CompletableFuture<?> invokeAsyncWithoutTimeout(boolean var1);

        public boolean isEnabled();

        default public CompletableFuture<?> invokeAsync(boolean prompt) {
            return this.invokeAsyncWithoutTimeout(prompt).orTimeout(10000L, TimeUnit.MILLISECONDS);
        }

        default public void run(boolean prompt) {
            this.get(prompt);
        }

        default public Object get(boolean prompt) {
            if (Swing.isSwingThread()) {
                throw new AssertionError((Object)"Refusing to block the Swing thread. Use a Task.");
            }
            try {
                return this.invokeAsync(prompt).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        default public ActionName.Show getShow() {
            return this.name() == null ? ActionName.Show.EXTENDED : this.name().show();
        }
    }
}

