/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import db.buffers.ManagedBufferFileAdapter;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RemoteAdapterListener;
import ghidra.framework.client.RepositoryChangeDispatcher;
import ghidra.framework.client.RepositoryNotFoundException;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.remote.RepositoryChangeEvent;
import ghidra.framework.remote.RepositoryHandle;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.remote.User;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.DataFileHandle;
import ghidra.framework.store.FileSystemListener;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

public class RepositoryAdapter
implements RemoteAdapterListener {
    private String name;
    private RepositoryServerAdapter serverAdapter;
    private WeakSet<RemoteAdapterListener> listenerList = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private RepositoryHandle repository;
    private User user;
    private boolean unexpectedDisconnect = false;
    private boolean noSuchRepository = false;
    private volatile int openFileHandleCount = 0;
    private boolean ignoreNextOpenFileCountEvent = false;
    private RepositoryChangeDispatcher changeDispatcher;

    public RepositoryAdapter(RepositoryServerAdapter serverAdapter, String name) {
        this.serverAdapter = serverAdapter;
        this.name = name;
        this.changeDispatcher = new RepositoryChangeDispatcher(this);
        serverAdapter.addListener(this);
    }

    RepositoryAdapter(RepositoryServerAdapter serverAdapter, String name, RepositoryHandle repository) {
        this(serverAdapter, name);
        this.repository = repository;
        if (repository != null) {
            this.changeDispatcher.start();
        }
    }

    public boolean hadUnexpectedDisconnect() {
        return this.unexpectedDisconnect;
    }

    public String toString() {
        return this.serverAdapter.toString() + "(" + this.name + ")";
    }

    RepositoryHandle getCurrentHandle() {
        return this.repository;
    }

    public void setFileSystemListener(FileSystemListener fsListener) {
        this.changeDispatcher.setFileChangeListener(fsListener);
    }

    public void addListener(RemoteAdapterListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(RemoteAdapterListener listener) {
        this.listenerList.remove((Object)listener);
    }

    private void fireStateChanged() {
        for (RemoteAdapterListener listener : this.listenerList) {
            listener.connectionStateChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionStateChanged(Object adapter) {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            if (!this.serverAdapter.isConnected()) {
                this.disconnect(this.serverAdapter.hadUnexpectedDisconnect(), true);
            } else {
                try {
                    this.connect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isConnected() {
        return this.repository != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws RepositoryNotFoundException, IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            if (this.repository != null) {
                try {
                    this.repository.getName();
                }
                catch (NotConnectedException | RemoteException e) {
                    if (this.recoverConnection(e)) {
                        return;
                    }
                    throw e;
                }
            }
            if (this.repository == null) {
                this.serverAdapter.connect();
            }
            if (this.repository == null && this.serverAdapter.isConnected()) {
                this.repository = this.serverAdapter.getRepositoryHandle(this.name);
                this.unexpectedDisconnect = false;
                if (this.repository == null) {
                    this.noSuchRepository = true;
                    throw new RepositoryNotFoundException("Repository '" + this.name + "': not found");
                }
                Msg.info((Object)this, (Object)("Connected to repository '" + this.name + "'"));
                this.changeDispatcher.start();
                this.fireStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RepositoryChangeEvent[] getEvents() throws InterruptedIOException {
        RepositoryHandle handle;
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            if (this.repository == null) {
                throw new InterruptedIOException();
            }
            handle = this.repository;
        }
        try {
            return handle.getEvents();
        }
        catch (NotConnectedException | RemoteException e) {
            this.recoverConnection(e);
            throw new InterruptedIOException();
        }
        catch (IOException e) {
            RepositoryServerAdapter repositoryServerAdapter2 = this.serverAdapter;
            synchronized (repositoryServerAdapter2) {
                if (!Thread.currentThread().isInterrupted()) {
                    this.serverAdapter.verifyConnection();
                    this.disconnect(true, true);
                }
            }
            throw new InterruptedIOException();
        }
    }

    public String getName() {
        return this.name;
    }

    public RepositoryServerAdapter getServer() {
        return this.serverAdapter;
    }

    public ServerInfo getServerInfo() {
        return this.serverAdapter.getServerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recoverConnection(IOException e) {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (!this.serverAdapter.verifyConnection()) {
                this.disconnect(this.serverAdapter.hadUnexpectedDisconnect(), true);
                return false;
            }
            if (this.noSuchRepository || !(e instanceof NoSuchObjectException)) {
                return false;
            }
            this.disconnect(true, false);
            try {
                this.connect();
            }
            catch (IOException e1) {
                this.fireStateChanged();
                return false;
            }
            return true;
        }
    }

    public User getUser() throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                if (this.user == null) {
                    this.user = this.repository.getUser();
                }
                return this.user;
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.getUser();
                }
                throw e;
            }
        }
    }

    public boolean anonymousAccessAllowed() throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.anonymousAccessAllowed();
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.anonymousAccessAllowed();
                }
                throw e;
            }
        }
    }

    public User[] getUserList() throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getUserList();
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getUserList();
                }
                throw e;
            }
        }
    }

    public String[] getServerUserList() throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getServerUserList();
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getServerUserList();
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserList(User[] users, boolean anonymousAccessAllowed) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                this.repository.setUserList(users, anonymousAccessAllowed);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    this.repository.setUserList(users, anonymousAccessAllowed);
                    return;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTextDataFile(String parentPath, String itemName, String fileID, String contentType, String textData, String comment) throws IOException, InvalidNameException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                this.repository.createTextDataFile(parentPath, itemName, fileID, contentType, textData, comment);
            }
            catch (NotConnectedException | RemoteException e) {
                this.checkUnmarshalException(e, "createTextDataFile");
                if (this.recoverConnection(e)) {
                    try {
                        this.repository.createTextDataFile(parentPath, itemName, fileID, contentType, textData, comment);
                    }
                    catch (RemoteException e1) {
                        this.checkUnmarshalException(e1, "createTextDataFile");
                        throw e1;
                    }
                }
                throw e;
            }
        }
    }

    public ManagedBufferFileAdapter createDatabase(String parentPath, String itemName, int bufferSize, String contentType, String fileID, String projectPath) throws IOException, InvalidNameException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                ManagedBufferFileAdapter bf = new ManagedBufferFileAdapter(this.repository.createDatabase(parentPath, itemName, fileID, bufferSize, contentType, projectPath));
                this.fileOpened();
                return bf;
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    ManagedBufferFileAdapter bf = new ManagedBufferFileAdapter(this.repository.createDatabase(parentPath, itemName, fileID, bufferSize, contentType, projectPath));
                    this.fileOpened();
                    return bf;
                }
                throw e;
            }
        }
    }

    public ManagedBufferFileAdapter openDatabase(String parentPath, String itemName, int version, int minChangeDataVer) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                ManagedBufferFileAdapter bf = new ManagedBufferFileAdapter(this.repository.openDatabase(parentPath, itemName, version, minChangeDataVer));
                this.fileOpened();
                return bf;
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    ManagedBufferFileAdapter bf = new ManagedBufferFileAdapter(this.repository.openDatabase(parentPath, itemName, version, minChangeDataVer));
                    this.fileOpened();
                    return bf;
                }
                throw e;
            }
        }
    }

    public ManagedBufferFileAdapter openDatabase(String parentPath, String itemName, long checkoutId) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                ManagedBufferFileAdapter bf = new ManagedBufferFileAdapter(this.repository.openDatabase(parentPath, itemName, checkoutId));
                this.fileOpened();
                return bf;
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    ManagedBufferFileAdapter bf = new ManagedBufferFileAdapter(this.repository.openDatabase(parentPath, itemName, checkoutId));
                    this.fileOpened();
                    return bf;
                }
                throw e;
            }
        }
    }

    public void createDataFile(String parentPath, String itemName) throws IOException {
        throw new IOException("Data file not yet supported by repository");
    }

    public DataFileHandle openDataFile(String parentPath, String itemName, int version) throws IOException {
        throw new IOException("Data file not yet supported by repository");
    }

    public String[] getSubfolderList(String folderPath) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getSubfolderList(folderPath);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getSubfolderList(folderPath);
                }
                throw e;
            }
        }
    }

    public int getItemCount() throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getItemCount();
            }
            catch (NotConnectedException | RemoteException e) {
                this.checkUnmarshalException(e, "getItemCount");
                if (this.recoverConnection(e)) {
                    try {
                        return this.repository.getItemCount();
                    }
                    catch (RemoteException e1) {
                        this.checkUnmarshalException(e1, "getItemCount");
                        throw e1;
                    }
                }
                throw e;
            }
        }
    }

    private void checkUnmarshalException(IOException e, String operation) throws UnsupportedOperationException {
        Throwable t = e.getCause();
        if (t instanceof UnmarshalException) {
            throw new UnsupportedOperationException(operation);
        }
    }

    public RepositoryItem[] getItemList(String folderPath) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getItemList(folderPath);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getItemList(folderPath);
                }
                throw e;
            }
        }
    }

    public RepositoryItem getItem(String folderPath, String itemName) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getItem(folderPath, itemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getItem(folderPath, itemName);
                }
                throw e;
            }
        }
    }

    public RepositoryItem getItem(String fileID) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getItem(fileID);
            }
            catch (NotConnectedException | RemoteException e) {
                this.checkUnmarshalException(e, "getItem by File-ID");
                if (this.recoverConnection(e)) {
                    try {
                        return this.repository.getItem(fileID);
                    }
                    catch (RemoteException e1) {
                        this.checkUnmarshalException(e1, "getItem by File-ID");
                        throw e1;
                    }
                }
                throw e;
            }
        }
    }

    public Version[] getVersions(String parentPath, String itemName) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getVersions(parentPath, itemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getVersions(parentPath, itemName);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItem(String parentPath, String itemName, int version) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                this.repository.deleteItem(parentPath, itemName, version);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    this.repository.deleteItem(parentPath, itemName, version);
                    return;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFolder(String oldParentPath, String newParentPath, String oldFolderName, String newFolderName) throws InvalidNameException, IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                this.repository.moveFolder(oldParentPath, newParentPath, oldFolderName, newFolderName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    this.repository.moveFolder(oldParentPath, newParentPath, oldFolderName, newFolderName);
                    return;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveItem(String oldParentPath, String newParentPath, String oldItemName, String newItemName) throws InvalidNameException, IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                this.repository.moveItem(oldParentPath, newParentPath, oldItemName, newItemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    this.repository.moveItem(oldParentPath, newParentPath, oldItemName, newItemName);
                    return;
                }
                throw e;
            }
        }
    }

    public ItemCheckoutStatus checkout(String folderPath, String itemName, CheckoutType checkoutType, String projectPath) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.checkout(folderPath, itemName, checkoutType, projectPath);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.checkout(folderPath, itemName, checkoutType, projectPath);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateCheckout(String folderPath, String itemName, long checkoutId, boolean notify) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                this.repository.terminateCheckout(folderPath, itemName, checkoutId, notify);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    this.repository.terminateCheckout(folderPath, itemName, checkoutId, notify);
                    return;
                }
                throw e;
            }
        }
    }

    public ItemCheckoutStatus getCheckout(String parentPath, String itemName, long checkoutId) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getCheckout(parentPath, itemName, checkoutId);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getCheckout(parentPath, itemName, checkoutId);
                }
                throw e;
            }
        }
    }

    public ItemCheckoutStatus[] getCheckouts(String parentPath, String itemName) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getCheckouts(parentPath, itemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getCheckouts(parentPath, itemName);
                }
                throw e;
            }
        }
    }

    public boolean folderExists(String folderPath) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.folderExists(folderPath);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.folderExists(folderPath);
                }
                throw e;
            }
        }
    }

    public boolean fileExists(String folderPath, String itemName) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.fileExists(folderPath, itemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.fileExists(folderPath, itemName);
                }
                throw e;
            }
        }
    }

    public long getLength(String parentPath, String itemName) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.getLength(parentPath, itemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.getLength(parentPath, itemName);
                }
                throw e;
            }
        }
    }

    public boolean hasCheckouts(String parentPath, String itemName) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.hasCheckouts(parentPath, itemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.hasCheckouts(parentPath, itemName);
                }
                throw e;
            }
        }
    }

    public boolean isCheckinActive(String parentPath, String itemName) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                return this.repository.isCheckinActive(parentPath, itemName);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    return this.repository.isCheckinActive(parentPath, itemName);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCheckoutVersion(String parentPath, String itemName, long checkoutId, int checkoutVersion) throws IOException {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            this.checkRepository();
            try {
                this.repository.updateCheckoutVersion(parentPath, itemName, checkoutId, checkoutVersion);
            }
            catch (NotConnectedException | RemoteException e) {
                if (this.recoverConnection(e)) {
                    this.repository.updateCheckoutVersion(parentPath, itemName, checkoutId, checkoutVersion);
                    return;
                }
                throw e;
            }
        }
    }

    public boolean verifyConnection() {
        return this.serverAdapter.verifyConnection();
    }

    public void disconnect() {
        this.disconnect(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(boolean unexpected, boolean notify) {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            if (this.repository != null) {
                this.unexpectedDisconnect = unexpected;
                Msg.info((Object)this, (Object)("Disconnected from repository '" + this.name + "'"));
                this.changeDispatcher.stop();
                try {
                    this.repository.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.repository = null;
                this.user = null;
                if (notify) {
                    this.fireStateChanged();
                }
            }
        }
    }

    private void checkRepository() throws NotConnectedException {
        if (this.repository == null) {
            throw new NotConnectedException("Not connected to the server");
        }
    }

    private void fileOpened() {
        ++this.openFileHandleCount;
        this.ignoreNextOpenFileCountEvent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processOpenHandleCountUpdateEvent(RepositoryChangeEvent event) {
        RepositoryServerAdapter repositoryServerAdapter = this.serverAdapter;
        synchronized (repositoryServerAdapter) {
            if (this.ignoreNextOpenFileCountEvent) {
                this.ignoreNextOpenFileCountEvent = false;
                return;
            }
            if (event.type != 9) {
                throw new IllegalArgumentException("Expected REP_OPEN_HANDLE_COUNT event");
            }
            this.openFileHandleCount = Integer.parseInt(event.newName);
        }
    }

    public int getOpenFileHandleCount() {
        return this.openFileHandleCount;
    }
}

