/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.jython.JythonScript;
import ghidra.jython.JythonUtils;
import ghidra.jython.PyDevUtils;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyMethod;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.TraceFunction;
import org.python.core.imp;
import org.python.util.InteractiveInterpreter;
import util.CollectionUtils;

public class GhidraJythonInterpreter
extends InteractiveInterpreter {
    private static boolean pythonInitialized;
    private static List<PyString> defaultPythonPath;
    private TraceFunction interruptTraceFunction;
    private PyModule introspectModule;
    private PyModule builtinModule;
    private PyObject interrupt;
    private boolean cleanedUp;
    private Stack<PyObject> localStack = new Stack();

    public static GhidraJythonInterpreter get() {
        if (!pythonInitialized) {
            try {
                JythonUtils.setupJythonHomeDir();
                JythonUtils.setupJythonCacheDir(TaskMonitor.DUMMY);
                pythonInitialized = true;
            }
            catch (Exception e) {
                Msg.showError(GhidraJythonInterpreter.class, null, (String)"Python error", (Object)"Problem getting Ghirda Python interpreter", (Throwable)e);
                return null;
            }
        }
        PySystemState state = new PySystemState();
        state.ps1 = new PyString(">>> ");
        state.ps2 = new PyString("... ");
        return new GhidraJythonInterpreter(state);
    }

    private GhidraJythonInterpreter(PySystemState state) {
        super(null, state);
        defaultPythonPath = new ArrayList<PyString>();
        for (Object object : this.systemState.path) {
            defaultPythonPath.add(Py.newStringOrUnicode((String)object.toString()));
        }
        this.interruptTraceFunction = new InterruptTraceFunction();
        PyModule mod = imp.addModule((String)"__main__");
        this.setLocals(mod.__dict__);
        imp.load((String)"site");
        this.introspectModule = (PyModule)imp.load((String)"jintrospect");
        this.builtinModule = (PyModule)imp.load((String)"__builtin__");
    }

    private void initializePythonPath() {
        File pyDevSrcDir;
        this.systemState.path.retainAll(defaultPythonPath);
        for (ResourceFile resourceFile : GhidraScriptUtil.getEnabledScriptSourceDirectories()) {
            this.systemState.path.append((PyObject)Py.newStringOrUnicode((String)resourceFile.getFile(false).getAbsolutePath()));
        }
        for (ResourceFile resourceFile : GhidraScriptUtil.getExplodedCompiledSourceBundlePaths()) {
            this.systemState.path.append((PyObject)Py.newStringOrUnicode((String)resourceFile.getFile(false).getAbsolutePath()));
        }
        if (!SystemUtilities.isInDevelopmentMode() && (pyDevSrcDir = PyDevUtils.getPyDevSrcDir()) != null) {
            this.systemState.path.append((PyObject)Py.newStringOrUnicode((String)pyDevSrcDir.getAbsolutePath()));
        }
    }

    public synchronized boolean push(String line, JythonScript script) throws PyException, IllegalStateException {
        boolean more;
        if (this.cleanedUp) {
            throw new IllegalStateException("Ghidra python interpreter has already been cleaned up.");
        }
        this.initializePythonPath();
        this.injectScriptHierarchy(script);
        if (this.buffer.length() > 0) {
            this.buffer.append("\n");
        }
        this.buffer.append(line);
        Py.getThreadState().tracefunc = this.interruptTraceFunction;
        Py.getSystemState().stderr = this.getSystemState().stderr;
        try {
            more = this.runsource(this.buffer.toString(), "python");
            this.getSystemState().stderr.invoke("flush");
            if (!more) {
                this.resetbuffer();
            }
        }
        catch (PyException pye) {
            this.resetbuffer();
            throw pye;
        }
        return more;
    }

    public synchronized void execFile(ResourceFile file, JythonScript script) throws IllegalStateException {
        if (this.cleanedUp) {
            throw new IllegalStateException("Ghidra python interpreter has already been cleaned up.");
        }
        this.initializePythonPath();
        this.injectScriptHierarchy(script);
        Py.getThreadState().tracefunc = this.interruptTraceFunction;
        this.setVariable("__file__", new PyString(file.getAbsolutePath()));
        if (!SystemUtilities.isInDevelopmentMode() && !SystemUtilities.isInHeadlessMode() && PyDevUtils.getPyDevSrcDir() != null) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                new Socket(localhost, 5678).close();
                Msg.info((Object)((Object)this), (Object)"Python debugger found");
                StringBuilder dbgCmds = new StringBuilder();
                dbgCmds.append("import pydevd;");
                dbgCmds.append("pydevd.threadingCurrentThread().__pydevd_main_thread = True;");
                dbgCmds.append("pydevd.settrace(host=\"" + localhost.getHostName() + "\", port=5678, suspend=False);");
                this.exec(dbgCmds.toString());
                Msg.info((Object)((Object)this), (Object)"Connected to a python debugger.");
            }
            catch (IOException e) {
                Msg.info((Object)((Object)this), (Object)"Not connected to a python debugger.");
            }
        }
        this.execfile(file.getAbsolutePath());
    }

    public synchronized void cleanup() {
        super.cleanup();
        this.cleanedUp = true;
    }

    void printErr(String str) {
        try {
            this.getSystemState().stderr.invoke("write", (PyObject)new PyString(str + "\n"));
            this.getSystemState().stderr.invoke("flush");
        }
        catch (PyException e) {
            Msg.error((Object)((Object)this), (Object)"Failed to write to stderr", (Throwable)e);
        }
    }

    synchronized String getPrimaryPrompt() {
        return this.getSystemState().ps1.toString();
    }

    synchronized String getSecondaryPrompt() {
        return this.getSystemState().ps2.toString();
    }

    void interrupt(Thread pythonThread) {
        long INTERRUPT_TIMEOUT = 5000L;
        if (pythonThread != null && pythonThread.isAlive()) {
            this.interrupt = Py.KeyboardInterrupt;
            pythonThread.interrupt();
            try {
                pythonThread.join(5000L);
                if (pythonThread.isAlive()) {
                    this.printErr("Cannot interrupt running command");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.interrupt = null;
        } else {
            this.printErr("KeyboardInterrupt");
        }
        this.resetbuffer();
    }

    void injectScriptHierarchy(JythonScript script) {
        if (script == null) {
            return;
        }
        this.setVariable("this", (Object)script);
        for (Class<?> scriptClass = ((Object)((Object)script)).getClass(); scriptClass != Object.class; scriptClass = scriptClass.getSuperclass()) {
            for (Field field : scriptClass.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers()) && !Modifier.isProtected(field.getModifiers())) continue;
                try {
                    field.setAccessible(true);
                    this.setVariable(field.getName(), field.get((Object)script));
                }
                catch (IllegalAccessException iae) {
                    throw new AssertException("Unexpected security manager being used!");
                }
            }
            for (AccessibleObject accessibleObject : scriptClass.getDeclaredMethods()) {
                if (((Method)accessibleObject).getName().contains("$") || !Modifier.isPublic(((Method)accessibleObject).getModifiers())) continue;
                ((Method)accessibleObject).setAccessible(true);
                this.setMethod((Object)script, (Method)accessibleObject);
            }
        }
    }

    private boolean setVariable(String varName, Object obj) {
        if (this.builtinModule.__findattr__(varName) == null) {
            this.set(varName, obj);
            return true;
        }
        return false;
    }

    public void saveLocals() {
        this.localStack.push(this.getLocals());
    }

    public void clearLocals() {
        this.setLocals((PyObject)new PyStringMap());
    }

    public void restoreLocals() {
        this.setLocals(this.localStack.pop());
    }

    private boolean setMethod(Object obj, Method method) {
        String methodName = method.getName();
        if (this.builtinModule.__findattr__(methodName) != null) {
            return false;
        }
        PyObject pyObj = this.get(methodName);
        if (null == pyObj || pyObj instanceof PyNone) {
            this.set(methodName, (PyObject)new PyMethod((PyObject)new PyReflectedFunction(new Method[]{method}), Py.java2py((Object)obj), Py.java2py(obj.getClass())));
        } else if (pyObj instanceof PyMethod) {
            PyMethod pyMethod = (PyMethod)pyObj;
            if (pyMethod.__self__._is(Py.java2py((Object)obj)) != Py.True) {
                Msg.error((Object)((Object)this), (Object)("Method " + methodName + " of " + String.valueOf(obj) + " attempting to shadow method " + String.valueOf(pyMethod.__func__) + " of " + String.valueOf(pyMethod.__self__)));
                this.set(methodName, (PyObject)new PyMethod((PyObject)new PyReflectedFunction(new Method[]{method}), Py.java2py((Object)obj), Py.java2py(obj.getClass())));
                return false;
            }
            if (!(pyMethod.__func__ instanceof PyReflectedFunction)) {
                Msg.error((Object)((Object)this), (Object)("For addition of method " + methodName + " of " + String.valueOf(obj) + ", cannot mix with non Java function " + String.valueOf(pyMethod.__func__)));
                return false;
            }
            ((PyReflectedFunction)pyMethod.__func__).addMethod(method);
        }
        return true;
    }

    List<CodeCompletion> getCommandCompletions(String cmd, boolean includeBuiltins, int caretPos) {
        if ((cmd = cmd.substring(0, caretPos)).length() > 0 && cmd.charAt(cmd.length() - 1) == '(') {
            return this.getMethodCommandCompletions(cmd);
        }
        return this.getPropertyCommandCompletions(cmd, includeBuiltins);
    }

    private List<CodeCompletion> getMethodCommandCompletions(String cmd) {
        ArrayList<CodeCompletion> completion_list = new ArrayList<CodeCompletion>();
        try {
            PyObject getCallTipJava = this.introspectModule.__findattr__("getCallTipJava");
            PyString command = new PyString(cmd);
            PyObject locals = this.getLocals();
            ListIterator iter = ((List)getCallTipJava.__call__((PyObject)command, locals)).listIterator();
            while (iter.hasNext()) {
                String[] substrings;
                String completion_portion = iter.next().toString();
                if (completion_portion.equals("")) continue;
                for (String substring : substrings = completion_portion.split("\n")) {
                    completion_list.add(new CodeCompletion(substring, null, null));
                }
            }
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return completion_list;
    }

    private List<CodeCompletion> getPropertyCommandCompletions(String cmd, boolean includeBuiltins) {
        try {
            PyObject getAutoCompleteList = this.introspectModule.__findattr__("getAutoCompleteList");
            PyString command = new PyString(cmd);
            PyStringMap locals = ((PyStringMap)this.getLocals()).copy();
            if (includeBuiltins) {
                locals.update(this.builtinModule.__dict__);
            }
            List list = (List)getAutoCompleteList.__call__((PyObject)command, (PyObject)locals);
            return CollectionUtils.asList((List)list, CodeCompletion.class);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    class InterruptTraceFunction
    extends TraceFunction {
        InterruptTraceFunction() {
        }

        private void checkInterrupt() {
            if (GhidraJythonInterpreter.this.interrupt != null) {
                throw Py.makeException((PyObject)GhidraJythonInterpreter.this.interrupt);
            }
        }

        public TraceFunction traceCall(PyFrame frame) {
            this.checkInterrupt();
            return this;
        }

        public TraceFunction traceReturn(PyFrame frame, PyObject ret) {
            this.checkInterrupt();
            return this;
        }

        public TraceFunction traceLine(PyFrame frame, int line) {
            this.checkInterrupt();
            return this;
        }

        public TraceFunction traceException(PyFrame frame, PyException exc) {
            this.checkInterrupt();
            return this;
        }
    }
}

