/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarEntryNode {
    private final JarEntryNode parent;
    private final String name;
    private Map<String, JarEntryNode> childMap;

    JarEntryNode(JarEntryNode parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    public JarEntryNode getNode(String childName) {
        if (this.childMap == null) {
            return null;
        }
        if (childName.equals(".")) {
            return this;
        }
        if (childName.equals("..")) {
            return this.parent;
        }
        return this.childMap.get(childName);
    }

    JarEntryNode createNode(String childName) {
        JarEntryNode file = this.getNode(childName);
        if (file == null) {
            file = new JarEntryNode(this, childName);
            if (this.childMap == null) {
                this.childMap = new HashMap<String, JarEntryNode>();
            }
            this.childMap.put(childName, file);
        }
        return file;
    }

    String getPath() {
        if (this.parent == null) {
            return "";
        }
        String parentPath = this.parent.getPath();
        return parentPath.length() == 0 ? this.name : parentPath + "/" + this.name;
    }

    public List<JarEntryNode> getChildren() {
        if (this.childMap == null) {
            return null;
        }
        return new ArrayList<JarEntryNode>(this.childMap.values());
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.childMap != null;
    }

    public boolean isFile() {
        return this.childMap == null;
    }

    public InputStream getInputStream() throws IOException {
        JarFile jarFile = this.getJarFile();
        JarEntry jarEntry = jarFile.getJarEntry(this.getPath());
        return jarFile.getInputStream(jarEntry);
    }

    protected JarFile getJarFile() {
        return this.parent.getJarFile();
    }

    public JarEntryNode getParent() {
        return this.parent;
    }

    public long lastModified() {
        JarFile jarFile = this.getJarFile();
        JarEntry jarEntry = jarFile.getJarEntry(this.getPath());
        return jarEntry.getTime();
    }

    public JarEntryNode getNode(String[] path) {
        JarEntryNode temp = this;
        for (String childName : path) {
            if ((temp = temp.getNode(childName)) != null) continue;
            return null;
        }
        return temp;
    }

    public long length() {
        JarFile jarFile = this.getJarFile();
        JarEntry jarEntry = jarFile.getJarEntry(this.getPath());
        return jarEntry.getSize();
    }
}

