/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerPlatformMapper;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.ExternalLanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class GdbDebuggerPlatformOpinion
extends AbstractDebuggerPlatformOpinion {
    public static final String EXTERNAL_TOOL = "gnu";
    public static final CompilerSpecID GCC_CSPEC_ID = new CompilerSpecID("gcc");
    public static final CompilerSpecID WINDOWS_CSPEC_ID = new CompilerSpecID("windows");
    private static final Map<Pair<String, Endian>, List<LanguageCompilerSpecPair>> CACHE = new HashMap<Pair<String, Endian>, List<LanguageCompilerSpecPair>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanguageCompilerSpecPair> getCompilerSpecsForGnu(String arch, String os, Endian endian) {
        CompilerSpecID prefferedCspecId = GdbDebuggerPlatformOpinion.computePreferredSpecId(os);
        Map<Pair<String, Endian>, List<LanguageCompilerSpecPair>> map = CACHE;
        synchronized (map) {
            return CACHE.computeIfAbsent((Pair<String, Endian>)Pair.of((Object)arch, (Object)endian), p -> {
                LanguageService langServ = DefaultLanguageService.getLanguageService();
                return langServ.getLanguageCompilerSpecPairs(new ExternalLanguageCompilerSpecQuery(arch, EXTERNAL_TOOL, endian, null, prefferedCspecId));
            });
        }
    }

    protected static CompilerSpecID computePreferredSpecId(String os) {
        String lower = os.toLowerCase();
        if (lower.contains("windows")) {
            return WINDOWS_CSPEC_ID;
        }
        return GCC_CSPEC_ID;
    }

    protected Set<GdbDebuggerPlatformOffer> offersForLanguageAndCSpec(String arch, Endian endian, LanguageCompilerSpecPair lcsp) throws CompilerSpecNotFoundException, LanguageNotFoundException {
        return Set.of(GdbDebuggerPlatformOffer.fromArchLCSP(arch, lcsp));
    }

    @Override
    protected Set<DebuggerPlatformOffer> getOffers(TraceObject object, long snap, TraceObject env, String debugger, String arch, String os, Endian endian, boolean includeOverrides) {
        if (debugger == null || !"gdb".equals(debugger.toLowerCase())) {
            return Set.of();
        }
        return GdbDebuggerPlatformOpinion.getCompilerSpecsForGnu(arch, os, endian).stream().flatMap(lcsp -> {
            try {
                return this.offersForLanguageAndCSpec(arch, endian, (LanguageCompilerSpecPair)lcsp).stream();
            }
            catch (CompilerSpecNotFoundException | LanguageNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }).collect(Collectors.toSet());
    }

    protected static class GdbDebuggerPlatformOffer
    extends AbstractDebuggerPlatformOffer {
        public static GdbDebuggerPlatformOffer fromArchLCSP(String arch, LanguageCompilerSpecPair lcsp) throws CompilerSpecNotFoundException, LanguageNotFoundException {
            return new GdbDebuggerPlatformOffer("Default GDB for " + arch, lcsp.getCompilerSpec());
        }

        public GdbDebuggerPlatformOffer(String description, CompilerSpec cSpec) {
            super(description, cSpec);
        }

        @Override
        public int getConfidence() {
            return 100;
        }

        @Override
        public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
            return new GdbDebuggerPlatformMapper(tool, trace, this.cSpec);
        }

        @Override
        public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
            return mapper.getClass() == GdbDebuggerPlatformMapper.class;
        }
    }

    protected static class GdbDebuggerPlatformMapper
    extends DefaultDebuggerPlatformMapper {
        public GdbDebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }
    }
}

