/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack.vars;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.debug.stack.EvaluationException;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarningSet;
import ghidra.app.plugin.core.debug.stack.UnwindException;
import ghidra.app.plugin.core.debug.stack.UnwoundFrame;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.ValueLocation;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Varnode;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;

public interface VariableValueRow {
    public static final GColor COLOR_ERROR = GThemeDefaults.Colors.ERROR;
    public static final GColor COLOR_STALE = new GColor("color.fg.debugger.value.stale");

    public static String styleSimple(Object obj) {
        return obj == null ? VariableValueRow.htmlFg(COLOR_ERROR, "None") : HTMLUtilities.escapeHTML((String)obj.toString()).replace("\n", "<br>");
    }

    public static String styleState(TraceMemoryState state, String str) {
        if (state == TraceMemoryState.KNOWN) {
            return str;
        }
        return "<font color='" + COLOR_STALE.toHexString() + "'>" + str + "</font>";
    }

    public static String htmlFg(GColor color, String text) {
        return "<font color='" + color.toHexString() + "'>" + HTMLUtilities.escapeHTML((String)text) + "</font>";
    }

    public RowKey key();

    default public String keyToSimpleString() {
        return this.key().toString();
    }

    default public String keyToHtml() {
        return HTMLUtilities.escapeHTML((String)(String.valueOf((Object)this.key()) + ":"));
    }

    public String valueToSimpleString();

    public String valueToHtml();

    default public String toSimpleString() {
        return String.format("%s: %s", this.keyToSimpleString(), this.valueToSimpleString());
    }

    default public String toHtml() {
        return String.format("<tr><td valign='top'><b>%s</b></td><td><tt>%s</tt></td></tr>", this.keyToHtml(), this.valueToHtml());
    }

    public static TraceMemoryState computeState(Trace trace, AddressSpace space, AddressRange range, long snap) {
        return trace.getMemoryManager().isKnown(snap, range) ? TraceMemoryState.KNOWN : TraceMemoryState.UNKNOWN;
    }

    public static TraceMemoryState computeState(TraceCodeUnit unit, long snap) {
        return VariableValueRow.computeState(unit.getTrace(), unit.getAddress().getAddressSpace(), unit.getRange(), snap);
    }

    default public void reportDetails() {
    }

    public static enum RowKey {
        NAME("Name"),
        FRAME("Frame"),
        STORAGE("Storage"),
        TYPE("Type"),
        INSTRUCTION("Instruction"),
        LOCATION("Location"),
        BYTES("Bytes"),
        INTEGER("Integer"),
        VALUE("Value"),
        STATUS("Status"),
        WARNINGS("Warnings"),
        ERROR("Error");

        private final String display;

        private RowKey(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }
    }

    public record ErrorRow(Throwable error) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.ERROR;
        }

        @Override
        public String keyToHtml() {
            return VariableValueRow.htmlFg(COLOR_ERROR, String.valueOf((Object)this.key()) + ":");
        }

        @Override
        public String valueToHtml() {
            if (this.error instanceof EvaluationException || this.error instanceof UnwindException) {
                return VariableValueRow.styleSimple(this.error.getMessage());
            }
            return VariableValueRow.styleSimple(this.error);
        }

        @Override
        public String valueToSimpleString() {
            if (this.error instanceof EvaluationException || this.error instanceof UnwindException) {
                return this.error.getMessage();
            }
            return this.error.toString();
        }

        @Override
        public String toHtml() {
            return String.format("<tr><td valign='top'><b>%s</b></td><td>%s</td></tr>", this.keyToHtml(), this.valueToHtml());
        }

        @Override
        public void reportDetails() {
            Msg.showError((Object)this, null, (String)"Details", (Object)this.error.getMessage(), (Throwable)this.error);
        }
    }

    public record WarningsRow(StackUnwindWarningSet warnings) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.WARNINGS;
        }

        @Override
        public String keyToHtml() {
            return VariableValueRow.htmlFg(COLOR_ERROR, String.valueOf((Object)this.key()) + ":");
        }

        @Override
        public String valueToHtml() {
            String formatted = this.warnings.summarize().stream().map(w -> String.format("<li>%s</li>", HTMLUtilities.escapeHTML((String)w))).collect(Collectors.joining("\n  "));
            return String.format("<ul>\n  %s\n</ul>\n", formatted);
        }

        @Override
        public String valueToSimpleString() {
            return this.warnings.summarize().stream().collect(Collectors.joining("\n"));
        }

        @Override
        public String toHtml() {
            if (this.warnings.isEmpty()) {
                return "";
            }
            return String.format("<tr><td valign='top'><b>%s</b></td><td>%s</td></tr>", this.keyToHtml(), this.valueToHtml());
        }

        @Override
        public void reportDetails() {
            this.warnings.reportDetails();
        }
    }

    public record StatusRow(String status) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.STATUS;
        }

        @Override
        public String valueToHtml() {
            return String.format("<em>%s</em>", HTMLUtilities.escapeHTML((String)this.status.toString()));
        }

        @Override
        public String valueToSimpleString() {
            return this.status.toString();
        }
    }

    public record ValueRow(String value, TraceMemoryState state) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.VALUE;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleState(this.state, HTMLUtilities.escapeHTML((String)this.value));
        }

        @Override
        public String valueToSimpleString() {
            return String.format("(%s) %s", this.state, this.value);
        }
    }

    public record IntegerRow(DebuggerPcodeUtils.PrettyBytes bytes, TraceMemoryState state) implements VariableValueRow
    {
        public IntegerRow(BytesRow bytes) {
            this(bytes.bytes, bytes.state);
        }

        public IntegerRow(DebuggerPcodeUtils.WatchValue value) {
            this(value.bytes(), value.state());
        }

        public static IntegerRow fromCodeUnit(TraceCodeUnit unit, long snap) {
            try {
                return new IntegerRow(new DebuggerPcodeUtils.PrettyBytes(unit.isBigEndian(), unit.getBytes()), VariableValueRow.computeState(unit, snap));
            }
            catch (MemoryAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RowKey key() {
            return RowKey.INTEGER;
        }

        @Override
        public String toHtml() {
            if (this.bytes.length() > 16) {
                return "";
            }
            return VariableValueRow.super.toHtml();
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleState(this.state, this.bytes.collectDisplays().replace("\n", "<br>"));
        }

        @Override
        public String valueToSimpleString() {
            return String.format("(%s) %s", this.state, this.bytes.collectDisplays());
        }
    }

    public record BytesRow(DebuggerPcodeUtils.PrettyBytes bytes, TraceMemoryState state) implements VariableValueRow
    {
        public BytesRow(DebuggerPcodeUtils.WatchValue value) {
            this(value.bytes(), value.state());
        }

        public static BytesRow fromRange(TracePlatform platform, AddressRange range, long snap) {
            long size = range.getLength();
            ByteBuffer buf = ByteBuffer.allocate((int)size);
            Trace trace = platform.getTrace();
            if (size != (long)trace.getMemoryManager().getViewBytes(snap, range.getMinAddress(), buf)) {
                throw new AssertionError((Object)new MemoryAccessException("Could not read bytes"));
            }
            return new BytesRow(new DebuggerPcodeUtils.PrettyBytes(platform.getLanguage().isBigEndian(), buf.array()), VariableValueRow.computeState(trace, null, range, snap));
        }

        public static BytesRow fromCodeUnit(TraceCodeUnit unit, long snap) {
            try {
                return new BytesRow(new DebuggerPcodeUtils.PrettyBytes(unit.isBigEndian(), unit.getBytes()), VariableValueRow.computeState(unit, snap));
            }
            catch (MemoryAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RowKey key() {
            return RowKey.BYTES;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleState(this.state, this.bytes.toBytesString().replace("\n", "<br>"));
        }

        @Override
        public String valueToSimpleString() {
            return String.format("(%s) %s", this.state, this.bytes.toBytesString());
        }
    }

    public record LocationRow(String locString) implements VariableValueRow
    {
        public static LocationRow fromRange(AddressRange range) {
            return new LocationRow(String.format("%s:%d", range.getMinAddress(), range.getLength()));
        }

        public static LocationRow fromCodeUnit(CodeUnit unit) {
            return new LocationRow(String.format("%s:%d", unit.getMinAddress(), unit.getLength()));
        }

        public static LocationRow fromWatchValue(DebuggerPcodeUtils.WatchValue value, Language language) {
            ValueLocation loc = value.location();
            if (loc == null || loc.isEmpty()) {
                return new LocationRow(null);
            }
            return new LocationRow(loc.toString(language));
        }

        @Override
        public RowKey key() {
            return RowKey.LOCATION;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleSimple(this.locString);
        }

        @Override
        public String valueToSimpleString() {
            return this.locString == null ? "None" : this.locString;
        }
    }

    public record InstructionRow(Instruction instruction) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.INSTRUCTION;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleSimple(this.instruction);
        }

        @Override
        public String valueToSimpleString() {
            return this.instruction.toString();
        }
    }

    public record TypeRow(DataType type) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.TYPE;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleSimple(this.type.getDisplayName());
        }

        @Override
        public String valueToSimpleString() {
            return this.type.getDisplayName();
        }
    }

    public record StorageRow(VariableStorage storage) implements VariableValueRow
    {
        public static StorageRow fromCodeUnit(CodeUnit unit) {
            try {
                return new StorageRow(new VariableStorage((ProgramArchitecture)unit.getProgram(), new Varnode[]{new Varnode(unit.getMinAddress(), unit.getLength())}));
            }
            catch (InvalidInputException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RowKey key() {
            return RowKey.STORAGE;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleSimple(this.storage);
        }

        @Override
        public String valueToSimpleString() {
            return this.storage.toString();
        }
    }

    public record FrameRow(UnwoundFrame<?> frame) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.FRAME;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleSimple(this.frame.getDescription());
        }

        @Override
        public String valueToSimpleString() {
            return this.frame.getDescription();
        }
    }

    public record NameRow(String name) implements VariableValueRow
    {
        @Override
        public RowKey key() {
            return RowKey.NAME;
        }

        @Override
        public String valueToHtml() {
            return VariableValueRow.styleSimple(this.name);
        }

        @Override
        public String valueToSimpleString() {
            return this.name;
        }
    }
}

