/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.client.tables.CachedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OptionalTable {
    private String TABLE_EXISTS_STMT = "SELECT schemaname FROM pg_tables where tablename='#'";
    private String GRANT_STMT = "GRANT SELECT ON # TO PUBLIC";
    private String DELETE_ALL_STMT = "DELETE FROM #";
    private String INSERT_STMT = "INSERT INTO # (key,value) VALUES(?,?)";
    private String UPDATE_STMT = "UPDATE # SET value = ? WHERE key = ?";
    private String SELECT_STMT = "SELECT value FROM # WHERE key = ?";
    private String DELETE_STMT = "DELETE FROM # WHERE key = ?";
    private String LOCK_STMT = "LOCK TABLE # IN SHARE ROW EXCLUSIVE MODE";
    private Connection db = null;
    private final CachedStatement<PreparedStatement> insertStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> updateStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> deleteStatement = new CachedStatement();
    private final CachedStatement<Statement> reusableStatement = new CachedStatement();
    private String name = null;
    private int keyType = -1;
    private int valueType = -1;

    public OptionalTable(String nm, int kType, int vType, Connection d) {
        this.name = nm;
        this.keyType = kType;
        this.valueType = vType;
        this.db = d;
        this.TABLE_EXISTS_STMT = OptionalTable.generateSQLCommand(this.TABLE_EXISTS_STMT, nm);
        this.GRANT_STMT = OptionalTable.generateSQLCommand(this.GRANT_STMT, nm);
        this.DELETE_ALL_STMT = OptionalTable.generateSQLCommand(this.DELETE_ALL_STMT, nm);
        this.INSERT_STMT = OptionalTable.generateSQLCommand(this.INSERT_STMT, nm);
        this.UPDATE_STMT = OptionalTable.generateSQLCommand(this.UPDATE_STMT, nm);
        this.SELECT_STMT = OptionalTable.generateSQLCommand(this.SELECT_STMT, nm);
        this.DELETE_STMT = OptionalTable.generateSQLCommand(this.DELETE_STMT, nm);
        this.LOCK_STMT = OptionalTable.generateSQLCommand(this.LOCK_STMT, nm);
    }

    private Statement getReusableStatement() throws SQLException {
        return this.reusableStatement.prepareIfNeeded(() -> this.db.createStatement());
    }

    public void lockForWrite() throws SQLException {
        this.getReusableStatement().execute(this.LOCK_STMT);
    }

    private static String getSQLType(int type) {
        switch (type) {
            case 4: {
                return "INTEGER";
            }
            case 12: {
                return "TEXT";
            }
            case 7: {
                return "REAL";
            }
        }
        return null;
    }

    private static String generateSQLCommand(String ptr, String name) {
        int first = ptr.indexOf(35);
        int second = ptr.indexOf(35, first + 1);
        Object res = ptr.substring(0, first);
        res = (String)res + name;
        if (second >= 0) {
            res = (String)res + ptr.substring(first + 1, second);
            res = (String)res + name;
            res = (String)res + ptr.substring(second + 1);
        } else {
            res = (String)res + ptr.substring(first + 1);
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void close() {
        this.insertStatement.close();
        this.selectStatement.close();
        this.updateStatement.close();
        this.deleteStatement.close();
        this.reusableStatement.close();
        this.db = null;
    }

    public void createTable() throws SQLException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE TABLE ").append(this.name);
        buffer.append(" (key ").append(OptionalTable.getSQLType(this.keyType)).append(" UNIQUE,value ");
        buffer.append(OptionalTable.getSQLType(this.valueType)).append(')');
        String sqlstring = buffer.toString();
        Statement st = this.getReusableStatement();
        st.executeUpdate(sqlstring);
        st.executeUpdate(this.GRANT_STMT);
    }

    public void clearTable() throws SQLException {
        this.getReusableStatement().executeUpdate(this.DELETE_ALL_STMT);
    }

    public boolean exists() throws SQLException {
        boolean result = false;
        try (ResultSet rs = this.getReusableStatement().executeQuery(this.TABLE_EXISTS_STMT);){
            if (rs.next()) {
                result = rs.getString(1).equals("public");
            }
        }
        return result;
    }

    public Object readValue(Object key) throws SQLException {
        PreparedStatement s = this.selectStatement.prepareIfNeeded(() -> this.db.prepareStatement(this.SELECT_STMT));
        Object value = null;
        s.setObject(1, key, this.keyType);
        try (ResultSet rs = s.executeQuery();){
            if (rs.next()) {
                value = rs.getObject(1);
            }
        }
        return value;
    }

    public void writeValue(Object key, Object value) throws SQLException {
        PreparedStatement s = this.updateStatement.prepareIfNeeded(() -> this.db.prepareStatement(this.UPDATE_STMT));
        s.setObject(1, value, this.valueType);
        s.setObject(2, key, this.keyType);
        if (s.executeUpdate() == 1) {
            return;
        }
        s = this.insertStatement.prepareIfNeeded(() -> this.db.prepareStatement(this.INSERT_STMT));
        s.setObject(1, key, this.keyType);
        s.setObject(2, value, this.valueType);
        s.executeUpdate();
    }

    public void deleteValue(Object key) throws SQLException {
        PreparedStatement s = this.deleteStatement.prepareIfNeeded(() -> this.db.prepareStatement(this.DELETE_STMT));
        s.setObject(1, key, this.keyType);
        s.executeUpdate();
    }
}

