/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.graphanalysis;

import generic.hash.SimpleCRC32;
import generic.stl.Pair;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.features.codecompare.graphanalysis.CtrlGraph;
import ghidra.features.codecompare.graphanalysis.CtrlNGram;
import ghidra.features.codecompare.graphanalysis.CtrlVertex;
import ghidra.features.codecompare.graphanalysis.DataGraph;
import ghidra.features.codecompare.graphanalysis.DataNGram;
import ghidra.features.codecompare.graphanalysis.DataVertex;
import ghidra.features.codecompare.graphanalysis.TokenBin;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Pinning {
    private static final int NGRAM_DEPTH = 24;
    private DataGraph graphLeft;
    private DataGraph graphRight;
    private CtrlGraph cgraphLeft;
    private CtrlGraph cgraphRight;
    private Map<DataVertex, DataVertex> pinMap;
    private ArrayList<DataNGram> fragments;
    private int pass;
    private Comparator<DataCtrl> compareHashes = new DataCtrl.CompareHashes();
    private Comparator<DataCtrl> compareWithinBlock = new DataCtrl.CompareWithinBlock();

    public Pinning(HighFunction hfuncLeft, HighFunction hfuncRight, int ngramDepth, boolean constCaring, boolean ramCaring, boolean castCollapse, boolean sizeCollapse, boolean breakSym, TaskMonitor monitor) throws CancelledException {
        this.pinMap = new HashMap<DataVertex, DataVertex>();
        this.graphLeft = new DataGraph(Side.LEFT, hfuncLeft, constCaring, ramCaring, castCollapse, sizeCollapse);
        this.graphRight = new DataGraph(Side.RIGHT, hfuncRight, constCaring, ramCaring, castCollapse, sizeCollapse);
        this.cgraphLeft = new CtrlGraph(Side.LEFT, hfuncLeft);
        this.cgraphRight = new CtrlGraph(Side.RIGHT, hfuncRight);
        this.graphLeft.makeNGrams(ngramDepth);
        this.graphRight.makeNGrams(ngramDepth);
        this.cgraphLeft.makeNGrams(ngramDepth);
        this.cgraphRight.makeNGrams(ngramDepth);
        this.makeFragments();
        this.doPinning(ngramDepth, breakSym, monitor);
    }

    private void updateCtrlHashes(int ngramDepth) {
        this.cgraphLeft.clearNGrams();
        this.cgraphRight.clearNGrams();
        HashSet<CtrlVertex> seen = new HashSet<CtrlVertex>();
        for (DataVertex node : this.pinMap.keySet()) {
            CtrlVertex cnode;
            if (!node.isOp() || seen.contains(cnode = this.dataToCtrl(node))) continue;
            CtrlVertex csidekick = this.dataToCtrl(this.pinMap.get(node));
            seen.add(cnode);
            int flavor = cnode.uid;
            cnode.setZeroGram(flavor);
            csidekick.setZeroGram(flavor);
        }
        this.cgraphLeft.makeNGrams(ngramDepth);
        this.cgraphRight.makeNGrams(ngramDepth);
    }

    private void pinAssociates() {
        DataGraph.Associate associate1 = new DataGraph.Associate(null, 0);
        for (Map.Entry<DataGraph.Associate, ArrayList<DataVertex>> entry : this.graphLeft.associates.entrySet()) {
            int i;
            ArrayList<DataVertex> side0 = entry.getValue();
            associate1.node = this.pinMap.get(entry.getKey().node);
            if (associate1.node == null) continue;
            associate1.slot = entry.getKey().slot;
            ArrayList<DataVertex> side1 = this.graphRight.associates.get(associate1);
            if (side1 == null || side0.size() != side1.size() || side0.size() > 4) continue;
            boolean matching = true;
            for (i = 0; i < side0.size(); i += 2) {
                DataVertex op0 = side0.get(i);
                DataVertex op1 = side1.get(i);
                if (op0.op.getOpcode() == op1.op.getOpcode()) continue;
                matching = false;
                break;
            }
            if (!matching) continue;
            for (i = 0; i < side0.size(); ++i) {
                DataVertex v0 = side0.get(i);
                DataVertex v1 = side1.get(i);
                if (v0.paired || v1.paired) continue;
                this.establishMatch(v0, v1);
            }
        }
    }

    private void makeFragments() {
        this.fragments = new ArrayList();
        for (int side = 0; side < 2; ++side) {
            DataGraph graph = side == 0 ? this.graphLeft : this.graphRight;
            for (DataVertex node : graph.nodeList) {
                for (int d = 0; d < node.ngrams.size(); ++d) {
                    this.fragments.add(node.ngrams.get(d));
                }
            }
        }
        Collections.sort(this.fragments);
    }

    private void breakTieWithCtrlFlow(ArrayList<DataNGram> matchList, boolean useOrder, TaskMonitor monitor) throws CancelledException {
        int j;
        DataNGram current = matchList.get(0);
        if (current.weight <= 1) {
            return;
        }
        ArrayList<DataCtrl> cfragsList = new ArrayList<DataCtrl>();
        for (j = 0; j < matchList.size(); ++j) {
            monitor.checkCancelled();
            DataVertex tiedVertex = matchList.get((int)j).root;
            tiedVertex.passComplete = this.pass;
            DataVertex opVertex = current.root.isOp() ? tiedVertex : tiedVertex.sources.get(0);
            CtrlVertex ctiedVertex = this.dataToCtrl(opVertex);
            for (int d = 0; d < ctiedVertex.ngrams.size(); ++d) {
                CtrlNGram nGram = ctiedVertex.ngrams.get(d);
                DataCtrl temp = new DataCtrl(tiedVertex, nGram);
                cfragsList.add(temp);
            }
        }
        cfragsList.sort(this.compareHashes);
        j = 0;
        while (j < cfragsList.size()) {
            int jbar;
            if (monitor.isCancelled()) {
                return;
            }
            DataCtrl ccurrent = (DataCtrl)cfragsList.get(j);
            if (ccurrent.dataVertex.paired) {
                ++j;
                continue;
            }
            for (jbar = j + 1; jbar < cfragsList.size(); ++jbar) {
                DataCtrl cfuture = (DataCtrl)cfragsList.get(jbar);
                if (!ccurrent.ctrlNGram.equalHash(cfuture.ctrlNGram)) break;
            }
            if (jbar - j == 2) {
                DataCtrl cnext = (DataCtrl)cfragsList.get(j + 1);
                if (ccurrent.ctrlNGram.graphsDiffer(cnext.ctrlNGram)) {
                    DataVertex temp0 = ccurrent.dataVertex;
                    DataVertex temp1 = cnext.dataVertex;
                    this.ngramPinner(temp0, temp1, current.depth);
                }
            } else if (useOrder && jbar - j > 2) {
                this.breakTieUsingOrder(cfragsList, j, jbar, current);
            }
            j = jbar;
        }
    }

    private static boolean isBlockPair(ArrayList<DataCtrl> frags, int start, int stop) {
        int leftCount = 0;
        int rightCount = 0;
        int leftUid = -1;
        int rightUid = -1;
        for (int i = start; i < stop; ++i) {
            DataCtrl frag = frags.get(i);
            DataVertex vert = frag.dataVertex;
            if (!(vert.sinks.isEmpty() || vert.isOp() && vert.op.getOpcode() == 60)) {
                return false;
            }
            CtrlVertex cvert = frag.ctrlNGram.root;
            if (cvert.graph.side == Side.LEFT) {
                if (++leftCount == 1) {
                    leftUid = cvert.uid;
                    continue;
                }
                if (leftUid == cvert.uid) continue;
                return false;
            }
            if (++rightCount == 1) {
                rightUid = cvert.uid;
                continue;
            }
            if (rightUid == cvert.uid) continue;
            return false;
        }
        return leftCount == rightCount;
    }

    private void breakTieUsingOrder(ArrayList<DataCtrl> frags, int start, int stop, DataNGram firstNGram) {
        if (Pinning.isBlockPair(frags, start, stop)) {
            List<DataCtrl> subList = frags.subList(start, stop);
            subList.sort(this.compareWithinBlock);
            int size = (stop - start) / 2;
            for (int i = 0; i < size; ++i) {
                this.ngramPinner(subList.get((int)i).dataVertex, subList.get((int)(i + size)).dataVertex, firstNGram.depth);
            }
        }
    }

    private int collectEqualHash(int i, ArrayList<DataNGram> matchList, int minWeight) {
        DataNGram first = null;
        matchList.clear();
        do {
            if (i >= this.fragments.size()) {
                return i;
            }
            first = this.fragments.get(i);
            ++i;
        } while (first.weight < minWeight && (!first.root.isOp() || first.root.op.getOpcode() != 7) || first.root.paired || first.root.passComplete >= this.pass);
        matchList.add(first);
        while (true) {
            if (i >= this.fragments.size()) {
                return i;
            }
            DataNGram gram = this.fragments.get(i);
            if (!first.equalHash(gram)) break;
            ++i;
            if (gram.root.paired || gram.root.passComplete >= this.pass) continue;
            matchList.add(gram);
        }
        return i;
    }

    private void establishMatch(DataVertex left, DataVertex right) {
        this.pinMap.put(left, right);
        left.paired = true;
        right.paired = true;
    }

    private void pinMain(int minWeight, boolean useOrder, TaskMonitor monitor) throws CancelledException {
        int i = 0;
        monitor.setMessage("Pinning all...");
        monitor.setIndeterminate(false);
        monitor.initialize((long)this.fragments.size());
        ArrayList<DataNGram> matchList = new ArrayList<DataNGram>();
        while (i < this.fragments.size()) {
            if (i % 1000 == 0) {
                monitor.setProgress((long)i);
            }
            i = this.collectEqualHash(i, matchList, minWeight);
            if (matchList.size() == 2) {
                DataNGram gram1;
                DataNGram gram0 = matchList.get(0);
                if (!gram0.graphsDiffer(gram1 = matchList.get(1))) continue;
                DataVertex left = gram0.root.graph.side == Side.LEFT ? gram0.root : gram1.root;
                DataVertex right = gram0.root.graph.side == Side.RIGHT ? gram0.root : gram1.root;
                this.ngramPinner(left, right, gram0.depth);
                continue;
            }
            if (matchList.size() <= 2) continue;
            this.breakTieWithCtrlFlow(matchList, useOrder, monitor);
            if (!useOrder) continue;
            this.matchViaOperator(matchList);
        }
    }

    private void doPinning(int nGramDepth, boolean breakSym, TaskMonitor monitor) throws CancelledException {
        int lastPinSize;
        this.pass = 0;
        this.pinMain(2, false, monitor);
        this.cgraphLeft.addEdgeColor();
        this.cgraphRight.addEdgeColor();
        boolean checkForTies = true;
        while (checkForTies) {
            ++this.pass;
            lastPinSize = this.pinMap.size();
            this.updateCtrlHashes(nGramDepth);
            this.pinMain(0, false, monitor);
            checkForTies = lastPinSize != this.pinMap.size();
        }
        if (breakSym) {
            checkForTies = true;
            while (checkForTies) {
                ++this.pass;
                lastPinSize = this.pinMap.size();
                this.pinMain(0, true, monitor);
                checkForTies = lastPinSize != this.pinMap.size();
            }
        }
        this.pinAssociates();
    }

    private void ngramPinner(DataVertex left, DataVertex right, int depth) {
        block11: {
            block10: {
                if (depth < 0 || left == null || left.paired || right.paired) {
                    return;
                }
                this.establishMatch(left, right);
                if (!left.isCommutative()) break block10;
                if (left.op.getOpcode() != 60) {
                    DataVertex left0 = left.sources.get(0);
                    DataVertex left1 = left.sources.get(1);
                    DataVertex right0 = right.sources.get(0);
                    DataVertex right1 = right.sources.get(1);
                    int lasty = left.ngrams.size() - 1;
                    if (left0.ngrams.get((int)lasty).hash == left1.ngrams.get((int)lasty).hash || right0.ngrams.get((int)lasty).hash == right1.ngrams.get((int)lasty).hash) {
                        return;
                    }
                }
                block0: for (DataVertex srcLeft : left.sources) {
                    if (srcLeft.paired) continue;
                    for (DataVertex srcRight : right.sources) {
                        int newDepth;
                        if (srcRight.paired) continue;
                        boolean goForIt = true;
                        for (int i = 0; i < Math.max(1, depth); ++i) {
                            if (srcLeft.ngrams.get((int)i).hash == srcRight.ngrams.get((int)i).hash) continue;
                            goForIt = false;
                            break;
                        }
                        if (!goForIt) continue;
                        for (newDepth = Math.max(depth - 1, 0); -1 < newDepth && newDepth < srcLeft.ngrams.size() && srcLeft.ngrams.get((int)newDepth).hash == srcRight.ngrams.get((int)newDepth).hash; ++newDepth) {
                        }
                        this.ngramPinner(srcLeft, srcRight, newDepth - 1);
                        continue block0;
                    }
                }
                break block11;
            }
            if (left.sources.size() != right.sources.size()) break block11;
            for (int n = 0; n < left.sources.size(); ++n) {
                int i;
                DataVertex srcLeft = left.sources.get(n);
                DataVertex srcRight = right.sources.get(n);
                boolean goForIt = true;
                for (i = 0; i < Math.max(1, depth); ++i) {
                    if (srcLeft.ngrams.get((int)i).hash == srcRight.ngrams.get((int)i).hash) continue;
                    goForIt = false;
                    break;
                }
                if (!goForIt) continue;
                for (i = Math.max(depth - 1, 0); -1 < i && i < srcLeft.ngrams.size() && srcLeft.ngrams.get((int)i).hash == srcRight.ngrams.get((int)i).hash; ++i) {
                }
                this.ngramPinner(srcLeft, srcRight, i - 1);
            }
        }
    }

    private CtrlVertex dataToCtrl(DataVertex node) {
        PcodeBlockBasic parent = node.op.getParent();
        CtrlGraph whichGraph = node.graph == this.graphLeft ? this.cgraphLeft : this.cgraphRight;
        return whichGraph.blockToVertex.get(parent);
    }

    public VarnodeAST findMatch(Varnode vnLeft) {
        DataVertex vertLeft = this.graphLeft.vnToVert.get(vnLeft);
        if (vertLeft == null) {
            return null;
        }
        DataVertex vertRight = this.pinMap.get(vertLeft);
        if (vertRight != null) {
            return vertRight.vn;
        }
        return null;
    }

    public PcodeOpAST findMatch(PcodeOp opLeft) {
        DataVertex vertLeft = this.graphLeft.opToVert.get(opLeft);
        if (vertLeft == null) {
            return null;
        }
        DataVertex vertRight = this.pinMap.get(vertLeft);
        if (vertRight != null) {
            return vertRight.op;
        }
        return null;
    }

    private boolean filterToken(ClangToken token) {
        char c;
        String text = token.getText();
        if (text.length() == 0) {
            return true;
        }
        if (text.length() == 1 && ((c = text.charAt(0)) == ' ' || c == ',')) {
            return true;
        }
        return token instanceof ClangTypeToken;
    }

    public ArrayList<TokenBin> buildTokenMap(ClangTokenGroup leftTokenGp, ClangTokenGroup rightTokenGp) {
        HashMap<Pair, TokenBin> lvertToBin = new HashMap<Pair, TokenBin>();
        HashMap rvertToBin = new HashMap();
        for (int side = 0; side < 2; ++side) {
            ClangTokenGroup tokGp = side == 0 ? leftTokenGp : rightTokenGp;
            DataGraph graph = side == 0 ? this.graphLeft : this.graphRight;
            HashMap<Pair, TokenBin> vertToBin = side == 0 ? lvertToBin : rvertToBin;
            ArrayList nodes = new ArrayList();
            tokGp.flatten(nodes);
            for (ClangNode node : nodes) {
                DataVertex vnNode;
                ClangToken tok;
                if (!(node instanceof ClangToken) || this.filterToken(tok = (ClangToken)node)) continue;
                VarnodeAST vn = (VarnodeAST)DecompilerUtils.getVarnodeRef((ClangToken)tok);
                PcodeOpAST op = (PcodeOpAST)tok.getPcodeOp();
                DataVertex opNode = graph.opToVert.get(op);
                Pair nodePair = new Pair((Object)opNode, (Object)(vnNode = graph.vnToVert.get(vn)));
                if (!vertToBin.containsKey(nodePair)) {
                    vertToBin.put(nodePair, new TokenBin(graph.getHighFunction()));
                }
                ((TokenBin)vertToBin.get(nodePair)).add(tok);
            }
        }
        ArrayList<TokenBin> highBins = new ArrayList<TokenBin>();
        for (Pair lNodePair : lvertToBin.keySet()) {
            TokenBin rbin;
            Pair rNodePair;
            TokenBin lbin = (TokenBin)lvertToBin.get(lNodePair);
            DataVertex lkey = (DataVertex)lNodePair.first;
            DataVertex lval = (DataVertex)lNodePair.second;
            DataVertex rkey = null;
            DataVertex rval = null;
            if (lkey != null && lkey.paired) {
                rkey = this.pinMap.get(lkey);
            }
            if (lval != null && lval.paired) {
                rval = this.pinMap.get(lval);
            }
            if (lkey == null != (rkey == null) || lval == null != (rval == null) || rkey == null && rval == null || lkey == null && lval == null || !rvertToBin.containsKey(rNodePair = new Pair((Object)rkey, (Object)rval))) continue;
            lbin.sidekick = rbin = (TokenBin)rvertToBin.get(rNodePair);
            rbin.sidekick = lbin;
        }
        lvertToBin.remove(new Pair(null, null));
        rvertToBin.remove(new Pair(null, null));
        highBins.addAll(lvertToBin.values());
        highBins.addAll(rvertToBin.values());
        return highBins;
    }

    public void dump(Writer writer) throws IOException {
        this.graphLeft.dump(writer);
        this.graphRight.dump(writer);
        for (DataVertex vertex : this.graphLeft.nodeList) {
            DataVertex match = this.pinMap.get(vertex);
            if (match == null) continue;
            writer.append("match ");
            writer.append(Integer.toString(vertex.uid));
            writer.append(" to ");
            writer.append(Integer.toString(match.uid));
            writer.append("\n");
        }
    }

    public static Pinning makePinning(HighFunction hfuncLeft, HighFunction hfuncRight, boolean matchConstantsExactly, boolean sizeCollapse, boolean breakSym, TaskMonitor monitor) throws CancelledException {
        boolean matchRamSpace = true;
        boolean castCollapse = true;
        Pinning pin = new Pinning(hfuncLeft, hfuncRight, 24, matchConstantsExactly, matchRamSpace, castCollapse, sizeCollapse, breakSym, monitor);
        return pin;
    }

    private void matchViaOperator(ArrayList<DataNGram> ngrams) {
        DataNGram firstNGram = ngrams.get(0);
        for (DataNGram ngram : ngrams) {
            DataVertex vertLeft = ngram.root;
            if (vertLeft.graph.side != Side.LEFT) continue;
            for (int j = 0; j < vertLeft.sinks.size(); ++j) {
                DataVertex opVertLeft = vertLeft.sinks.get(j);
                if (!opVertLeft.isOp() || !opVertLeft.isCommutative() || !opVertLeft.paired) continue;
                DataVertex opVertRight = this.pinMap.get(opVertLeft);
                if (opVertLeft.sources.size() != opVertRight.sources.size()) continue;
                for (int i = 0; i < opVertLeft.sources.size(); ++i) {
                    int index;
                    DataVertex tVertLeft = opVertLeft.sources.get(i);
                    DataVertex tVertRight = opVertRight.sources.get(i);
                    if (tVertLeft.paired || tVertRight.paired || !tVertLeft.ngrams.get(index = tVertLeft.ngrams.size() - 1).equalHash(firstNGram) || !tVertRight.ngrams.get(index).equalHash(firstNGram)) continue;
                    this.ngramPinner(tVertLeft, tVertRight, firstNGram.depth);
                }
            }
        }
    }

    static int hashTwo(int first, int second) {
        int i;
        int result = 0;
        for (i = 0; i < 4; ++i) {
            result = SimpleCRC32.hashOneByte((int)result, (int)(first >> i * 8));
        }
        for (i = 0; i < 4; ++i) {
            result = SimpleCRC32.hashOneByte((int)result, (int)(second >> i * 8));
        }
        return result;
    }

    public static class DataCtrl {
        DataVertex dataVertex;
        CtrlNGram ctrlNGram;

        public DataCtrl(DataVertex data, CtrlNGram ctrl) {
            this.dataVertex = data;
            this.ctrlNGram = ctrl;
        }

        public static class CompareHashes
        implements Comparator<DataCtrl> {
            @Override
            public int compare(DataCtrl o1, DataCtrl o2) {
                CtrlNGram o1gram = o1.ctrlNGram;
                CtrlNGram o2gram = o2.ctrlNGram;
                if (o1gram.weight != o2gram.weight) {
                    return o1gram.weight < o2gram.weight ? 1 : -1;
                }
                if (o1gram.depth != o2gram.depth) {
                    return o1gram.depth < o2gram.depth ? 1 : -1;
                }
                if (o1gram.hash != o2gram.hash) {
                    return o1gram.hash < o2gram.hash ? -1 : 1;
                }
                int res = o1gram.root.graph.side.compareTo(o2gram.root.graph.side);
                if (res != 0) {
                    return res;
                }
                if (o1gram.root.uid != o2gram.root.uid) {
                    return o1gram.root.uid < o2gram.root.uid ? -1 : 1;
                }
                return 0;
            }
        }

        public static class CompareWithinBlock
        implements Comparator<DataCtrl> {
            @Override
            public int compare(DataCtrl o0, DataCtrl o1) {
                int order1;
                int hash0 = o0.ctrlNGram.hash;
                int hash1 = o1.ctrlNGram.hash;
                if (hash0 < hash1) {
                    return -1;
                }
                if (hash0 > hash1) {
                    return 1;
                }
                CtrlVertex o0Block = o0.ctrlNGram.root;
                CtrlVertex o1Block = o1.ctrlNGram.root;
                int res = o0Block.graph.side.compareTo(o1Block.graph.side);
                if (res != 0) {
                    return res;
                }
                if (o0Block.uid < o1Block.uid) {
                    return -1;
                }
                if (o0Block.uid > o1Block.uid) {
                    return 1;
                }
                PcodeOpAST op0 = o0.dataVertex.isOp() ? o0.dataVertex.op : o0.dataVertex.vn.getDef();
                PcodeOpAST op1 = o1.dataVertex.isOp() ? o1.dataVertex.op : o1.dataVertex.vn.getDef();
                int order0 = op0.getSeqnum().getOrder();
                if (order0 < (order1 = op1.getSeqnum().getOrder())) {
                    return -1;
                }
                if (order0 > order1) {
                    return 1;
                }
                return 0;
            }
        }
    }

    public static enum Side {
        LEFT(0),
        RIGHT(1);

        private int value;

        private Side(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }
}

