/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.local;

import ghidra.pty.PtySession;
import ghidra.util.Msg;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LocalProcessPtySession
implements PtySession {
    private final Process process;
    private final String ptyName;

    public LocalProcessPtySession(Process process, String ptyName) {
        this.process = process;
        this.ptyName = ptyName;
        Msg.info((Object)this, (Object)("local Pty session. PID = " + process.pid()));
    }

    @Override
    public int waitExited() throws InterruptedException {
        return this.process.waitFor();
    }

    @Override
    public int waitExited(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.process.waitFor(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.process.exitValue();
    }

    @Override
    public void destroyForcibly() {
        this.process.destroyForcibly();
    }

    @Override
    public String description() {
        return "process " + this.process.pid() + " on " + this.ptyName;
    }
}

