/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.DefaultGEdge;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphFactory;
import ghidra.graph.MutableGDirectedGraphWrapper;
import ghidra.graph.algo.AbstractDominanceAlgorithm;
import ghidra.graph.algo.GraphNavigator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.map.LazyMap;

public class ChkDominanceAlgorithm<V, E extends GEdge<V>>
extends AbstractDominanceAlgorithm<V, E> {
    private GDirectedGraph<V, E> sourceGraph;
    private MutableGDirectedGraphWrapper<V, E> mutableGraph;
    private V root;
    private Map<V, V> dominatorMap = new HashMap<V, V>();
    private Map<V, List<V>> dominatedMap = LazyMap.lazyMap(new HashMap(), () -> new ArrayList());
    private GraphNavigator<V, E> navigator;

    public ChkDominanceAlgorithm(GDirectedGraph<V, E> g, TaskMonitor monitor) throws CancelledException {
        this(g, GraphNavigator.topDownNavigator(), monitor);
    }

    ChkDominanceAlgorithm(GDirectedGraph<V, E> g, GraphNavigator<V, E> navigator, TaskMonitor monitor) throws CancelledException {
        this.navigator = navigator;
        this.sourceGraph = g;
        this.mutableGraph = new MutableGDirectedGraphWrapper<V, E>(g);
        this.root = this.findRoot();
        this.dominatorMap.put(this.root, this.root);
        monitor.setMessage("Computing dominance");
        this.computeDominance(monitor);
    }

    private V findRoot() {
        V theRoot = ChkDominanceAlgorithm.unifySources(this.mutableGraph, this.navigator);
        ChkDominanceAlgorithm.unifySinks(this.mutableGraph, this.navigator);
        return theRoot;
    }

    private void computeDominance(TaskMonitor monitor) throws CancelledException {
        List<V> list = this.navigator.getVerticesInPostOrder(this.mutableGraph);
        HashMap<V, Integer> map = new HashMap<V, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(list.get(i), i);
        }
        boolean changed = true;
        while (changed) {
            monitor.checkCancelled();
            changed = false;
            for (int i = list.size() - 2; i >= 0; --i) {
                V b = list.get(i);
                Collection<V> vertices = this.navigator.getPredecessors(this.mutableGraph, b);
                Iterator<V> iterator = vertices.iterator();
                Object newIdom = null;
                while (iterator.hasNext()) {
                    V p = iterator.next();
                    if (!this.dominatorMap.containsKey(p)) continue;
                    newIdom = p;
                    break;
                }
                if (newIdom == null) {
                    throw new AssertException("No processed predecessors found for " + String.valueOf(b));
                }
                for (V p : vertices) {
                    if (newIdom.equals(p) || !this.dominatorMap.containsKey(p)) continue;
                    newIdom = this.intersect(p, newIdom, map);
                }
                V idom = this.dominatorMap.get(b);
                if (newIdom.equals(idom)) continue;
                Object last = this.dominatorMap.put(b, newIdom);
                this.dominatedMap.get(newIdom).add(b);
                if (last != null) {
                    this.dominatedMap.get(last).remove(b);
                }
                changed = true;
            }
        }
    }

    private V intersect(V v1, V v2, Map<V, Integer> map) {
        V finger1 = v1;
        V finger2 = v2;
        int finger1Index = map.get(finger1);
        int finger2Index = map.get(finger2);
        while (!finger1.equals(finger2)) {
            while (finger1Index < finger2Index) {
                finger1 = this.dominatorMap.get(finger1);
                finger1Index = map.get(finger1);
            }
            while (finger2Index < finger1Index) {
                if (this.dominatorMap.get(finger2) == null) {
                    return finger1;
                }
                finger2 = this.dominatorMap.get(finger2);
                finger2Index = map.get(finger2);
            }
        }
        return finger1;
    }

    public Set<V> getDominated(V a) {
        HashSet results = new HashSet();
        this.doGetDominated(a, results);
        return results;
    }

    private void doGetDominated(V a, Set<V> results) {
        this.add(a, results);
        List<V> dominated = this.dominatedMap.get(a);
        dominated.forEach(b -> this.doGetDominated(b, results));
    }

    public Set<V> getDominators(V a) {
        HashSet<V> dominators = new HashSet<V>();
        dominators.add(a);
        while (!this.root.equals(a)) {
            a = this.dominatorMap.get(a);
            this.add(a, dominators);
        }
        return dominators;
    }

    private void add(V v, Collection<V> set) {
        if (!this.isDummy(v)) {
            set.add(v);
        }
    }

    private boolean isDummy(V v) {
        return v != null && this.mutableGraph.isDummy(v);
    }

    public GDirectedGraph<V, GEdge<V>> getDominanceTree() {
        GDirectedGraph dg = GraphFactory.createDirectedGraph();
        Collection<V> vertices = this.sourceGraph.getVertices();
        Set<V> sources = this.navigator.getSources(this.sourceGraph);
        for (V v : vertices) {
            V dominator;
            if (sources.contains(v) || (dominator = this.getImmediateDominator(v)) == null || Objects.equals(dominator, v)) continue;
            dg.addEdge(new DefaultGEdge<V>(dominator, v));
        }
        return dg;
    }

    private V getImmediateDominator(V v) {
        V dom = this.dominatorMap.get(v);
        if (this.isDummy(dom)) {
            return null;
        }
        return dom;
    }

    public void clear() {
        this.dominatedMap.clear();
        this.dominatorMap.clear();
    }
}

