/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.dtb.DtConstants;
import ghidra.file.formats.dtb.DtTableEntry;
import ghidra.file.formats.dtb.DtTableHeader;
import ghidra.file.formats.dtb.DtbUtil;
import ghidra.file.formats.dtb.FdtHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;

public class DtbAnalyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "Device Tree (DTB/DTBO) Analyzer";
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Analyzes Device Tree (DTB/DTBO) files.";
    }

    public boolean canAnalyze(Program program) {
        try {
            if (DtbUtil.isCorrectLoader(program)) {
                Address address = this.toAddr(program, 0L);
                byte[] magicBytes = new byte[4];
                program.getMemory().getBytes(address, magicBytes);
                return Arrays.equals(magicBytes, DtConstants.DT_TABLE_MAGIC_BYTES);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        if (!DtbUtil.isCorrectProcessor(program, log)) {
            return false;
        }
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        DtTableHeader header = new DtTableHeader(reader);
        DataType headerDataType = header.toDataType();
        this.createData(program, program.getMinAddress(), headerDataType);
        this.createFragment(program, "DtTableHeader", program.getMinAddress(), program.getMinAddress().add((long)headerDataType.getLength()));
        Address entryStartAddress = this.toAddr(program, header.getDtEntriesOffset());
        monitor.initialize((long)header.getEntries().size());
        for (int i = 0; i < header.getEntries().size(); ++i) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            DtTableEntry entry = header.getEntries().get(i);
            Data entryData = this.createData(program, entryStartAddress, entry.toDataType());
            Address entryEndAddress = entryStartAddress.add((long)header.getDtEntrySize());
            this.createFragment(program, "DtTableEntry_" + i, entryStartAddress, entryEndAddress);
            entryStartAddress = entryEndAddress;
            Data offsetData = entryData.getComponent(1);
            program.getReferenceManager().addMemoryReference(offsetData.getMinAddress(), this.toAddr(program, entry.getDtOffset()), RefType.DATA, SourceType.ANALYSIS, 0);
            Address entryDataStartAddress = this.toAddr(program, entry.getDtOffset());
            Address entryDataEndAddress = entryDataStartAddress.add((long)entry.getDtSize());
            this.createFragment(program, "DtTableEntry_" + i, entryDataStartAddress, entryDataEndAddress);
            FdtHeader fdtHeader = entry.getFdtHeader();
            if (fdtHeader == null) continue;
            fdtHeader.markup(this.toAddr(program, entry.getDtOffset()), program, monitor, log);
        }
        return true;
    }
}

