/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DexLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.app.util.recognizer.PkzipRecognizer;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.multidex.MultiDexLinker;
import ghidra.file.formats.android.versions.AndroidVersion;
import ghidra.file.formats.android.versions.AndroidVersionManager;
import ghidra.file.formats.android.xml.AndroidXmlFileSystem;
import ghidra.file.formats.zip.ZipFileSystem;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.framework.model.Project;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ApkLoader
extends DexLoader {
    @Override
    public String getName() {
        return "Android APK";
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        if (this.isZip(provider)) {
            Collection<LoadSpec> collection;
            block9: {
                ZipFileSystem zipFS = this.openAPK(provider, TaskMonitor.DUMMY);
                try {
                    collection = this.findLoadSpecs(zipFS, TaskMonitor.DUMMY);
                    if (zipFS == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (zipFS != null) {
                            try {
                                zipFS.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                zipFS.close();
            }
            return collection;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Loaded<Program>> loadProgram(ByteProvider provider, String programName, Project project, String programFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws IOException, LoadException, CancelledException {
        boolean success = false;
        ArrayList<Loaded<Program>> allLoadedPrograms = new ArrayList<Loaded<Program>>();
        int dexIndex = 1;
        try (ZipFileSystem zipFS = this.openAPK(provider, monitor);){
            GFile classesDexFile;
            while (!monitor.isCancelled() && (classesDexFile = zipFS.lookup("/classes" + String.valueOf(dexIndex == 1 ? "" : Integer.valueOf(dexIndex)) + ".dex")) != null) {
                monitor.setMessage("Loading " + classesDexFile.getName() + " from " + programName + "...");
                try (ByteProvider dexProvider = zipFS.getByteProvider(classesDexFile, monitor);){
                    List loadedPrograms = super.loadProgram(dexProvider, classesDexFile.getName(), project, this.joinPaths(new String[]{programFolderPath, programName}), loadSpec, options, log, consumer, monitor);
                    allLoadedPrograms.addAll(loadedPrograms);
                }
                ++dexIndex;
            }
            success = true;
        }
        catch (IOException e) {
            log.appendException((Throwable)e);
        }
        finally {
            if (!success) {
                allLoadedPrograms.forEach(Loaded::close);
            }
        }
        if (allLoadedPrograms.isEmpty()) {
            throw new LoadException("Operation finished with no programs to load");
        }
        this.link(allLoadedPrograms, log, monitor);
        return allLoadedPrograms;
    }

    public boolean loadsIntoNewFolder() {
        return true;
    }

    private boolean isZip(ByteProvider provider) {
        try {
            PkzipRecognizer recog = new PkzipRecognizer();
            byte[] bytes = provider.readBytes(0L, (long)recog.numberOfBytesRequired());
            return recog.recognize(bytes) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Collection<LoadSpec> findLoadSpecs(ZipFileSystem zipFS, TaskMonitor monitor) throws IOException {
        List<LoadSpec> xmlSpecs;
        GFile manifestXmlFile = zipFS.lookup("/AndroidManifest.xml");
        GFile classesDexFile = zipFS.lookup("/classes.dex");
        if (manifestXmlFile != null && !(xmlSpecs = this.processManifest(zipFS, manifestXmlFile, monitor)).isEmpty() && classesDexFile != null) {
            return xmlSpecs;
        }
        if (classesDexFile != null) {
            return this.processDEX(zipFS, classesDexFile, monitor);
        }
        return Collections.emptyList();
    }

    private List<LoadSpec> processManifest(ZipFileSystem zipFS, GFile manifestFile, TaskMonitor monitor) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        monitor.setMessage("Reading Android Manifest ...");
        try {
            ByteProvider byteProvider = zipFS.getByteProvider(manifestFile, monitor);
            try (AndroidXmlFileSystem xmlFS = this.openManifest(manifestFile.getName(), byteProvider, monitor);){
                GFile xmlFile = xmlFS.getPayloadFile();
                ByteProvider xmlFileByteProvider = xmlFS.getByteProvider(xmlFile, monitor);
                SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
                Document document = sax.build(xmlFileByteProvider.getInputStream(0L));
                Element rootElement = document.getRootElement();
                AndroidVersion version = this.getAndroidVersion(rootElement);
                List queries = QueryOpinionService.query((String)this.getName(), (String)"1", (String)String.valueOf(version.getVersionLetter()));
                for (QueryResult result : queries) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loadSpecs;
    }

    private AndroidVersion getAndroidVersion(Element rootElement) {
        Attribute codeAttribute = rootElement.getAttribute("platformBuildVersionCode");
        String platformBuildVersionCode = codeAttribute == null ? null : codeAttribute.getValue();
        Attribute nameAttribute = rootElement.getAttribute("platformBuildVersionName");
        String platformBuildVersionName = nameAttribute == null ? null : nameAttribute.getValue();
        return AndroidVersionManager.getByPlatformBuildVersion(platformBuildVersionCode, platformBuildVersionName);
    }

    private List<LoadSpec> processDEX(ZipFileSystem zipFS, GFile file, TaskMonitor monitor) throws IOException {
        monitor.setMessage("Reading classes.dex ...");
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        try {
            ByteProvider byteProvider = zipFS.getByteProvider(file, monitor);
            BinaryReader reader = new BinaryReader(byteProvider, true);
            DexHeader header = DexHeaderFactory.getDexHeader(reader);
            if ("dex\n".equals(new String(header.getMagic()))) {
                List queries = QueryOpinionService.query((String)this.getName(), (String)"1", null);
                for (QueryResult result : queries) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
                }
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return loadSpecs;
    }

    private ZipFileSystem openAPK(ByteProvider provider, TaskMonitor monitor) throws IOException, CancelledException {
        FileSystemService fsService = FileSystemService.getInstance();
        return (ZipFileSystem)fsService.mountSpecificFileSystem(provider.getFSRL(), ZipFileSystem.class, monitor);
    }

    private AndroidXmlFileSystem openManifest(String name, ByteProvider provider, TaskMonitor monitor) {
        AndroidXmlFileSystem xmlFS = new AndroidXmlFileSystem(name, provider);
        xmlFS.setFilesystemService(FileSystemService.getInstance());
        xmlFS.setFSRL(provider.getFSRL().getFS());
        try {
            xmlFS.open(monitor);
        }
        catch (CancelledException | IOException throwable) {
            // empty catch block
        }
        return xmlFS;
    }

    private void link(List<Loaded<Program>> programList, MessageLog log, TaskMonitor monitor) {
        try (MultiDexLinker linker = new MultiDexLinker(programList);){
            linker.link(monitor);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }
}

