/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import docking.framework.DockingApplicationConfiguration;
import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.app.plugin.core.go.GhidraGoSender;
import ghidra.app.plugin.core.go.exception.FailedToStartGhidraException;
import ghidra.app.plugin.core.go.exception.StartedGhidraProcessExitedException;
import ghidra.app.plugin.core.go.exception.StopWaitingException;
import ghidra.app.plugin.core.go.exception.UnableToGetLockException;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.Handler;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import utility.application.ApplicationLayout;

public class GhidraGo
implements GhidraLaunchable {
    private GhidraGoSender sender;

    public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
        DockingApplicationConfiguration configuration;
        block9: {
            configuration = null;
            try {
                if (!Application.isInitialized()) {
                    System.setProperty("application.name", "GhidraGo");
                    configuration = new DockingApplicationConfiguration();
                    Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
                }
                if (args != null && args.length > 0) {
                    Handler.registerHandler();
                    this.sender = new GhidraGoSender();
                    GhidraURL.getProjectURL((URL)new URL(args[0]));
                    this.startGhidraIfNeeded(layout);
                    this.sender.send(args[0]);
                    if (configuration != null) {
                        System.exit(0);
                    }
                    break block9;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException e) {
                System.err.println("\nUSAGE: ghidraGo <ghidraURL>\n\nGhidra URL Forms (ghidraURL):\n    ghidra://<hostname>[:<port>]/<repo-name>[/<folder-path>[/<program-name>]]\n    ghidra:/[<local-dirpath>/]<project-name>[?/<folder-path>[/<program-name>]]\n");
            }
            catch (FailedToStartGhidraException e) {
                this.logOrShowError("GhidraGo Start Ghidra Exception", "Failed to start Ghidra from GhidraGo", e);
            }
            catch (StopWaitingException e) {
            }
            catch (Exception e) {
                this.logOrShowError("GhidraGo Exception", "An unexpected exception occurred in GhidraGo", e);
            }
        }
        if (configuration != null) {
            System.exit(-1);
        }
    }

    private void logOrShowError(String errorTitle, String errorMessage, Exception e) {
        if (SystemUtilities.isInHeadlessMode()) {
            Msg.error((Object)this, (Object)errorMessage, (Throwable)e);
        } else {
            Swing.runNow(() -> Msg.showError((Object)this, null, (String)errorTitle, (Object)errorMessage, (Throwable)e));
        }
    }

    private void startGhidraIfNeeded(GhidraApplicationLayout layout) throws StopWaitingException, FailedToStartGhidraException {
        if (!this.sender.isGhidraListening()) {
            try {
                boolean success = this.sender.doLockedAction(false, () -> {
                    try {
                        Process ghidraProcess = this.startGhidra(layout);
                        this.sender.waitForListener(ghidraProcess);
                        return true;
                    }
                    catch (StopWaitingException e) {
                        return true;
                    }
                    catch (StartedGhidraProcessExitedException | IOException e) {
                        return false;
                    }
                });
                if (!success) {
                    throw new FailedToStartGhidraException();
                }
            }
            catch (UnableToGetLockException e) {
                this.sender.waitForListener();
            }
        }
    }

    private Process startGhidra(GhidraApplicationLayout layout) throws IOException {
        ResourceFile file = (ResourceFile)layout.getApplicationRootDirs().stream().findFirst().get();
        Path ghidraRunPath = SystemUtilities.isInDevelopmentMode() ? (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS ? Path.of(file.getAbsolutePath(), "/RuntimeScripts/Windows/ghidraRun.bat") : Path.of(file.getAbsolutePath(), "/RuntimeScripts/Linux/ghidraRun")) : (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS ? Path.of(file.getAbsolutePath(), "/../ghidraRun.bat") : Path.of(file.getAbsolutePath(), "/../ghidraRun"));
        Msg.info((Object)this, (Object)("Starting new Ghidra using ghidraRun script at " + String.valueOf(ghidraRunPath)));
        return Runtime.getRuntime().exec(ghidraRunPath.toString());
    }
}

