/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.ContextSpecificAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.framework.main.datatable.ProjectTreeContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import javax.swing.Icon;

public class ProjectDataNewFolderAction<T extends ProjectTreeContext>
extends ContextSpecificAction<T> {
    private static final Icon ICON = new GIcon("icon.projectdata.new.folder");

    public ProjectDataNewFolderAction(String owner, String group, Class<T> contextClass) {
        super("New Folder", owner, contextClass);
        this.setPopupMenuData(new MenuData(new String[]{"New Folder"}, ICON, group));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(T context) {
        this.createNewFolder(context);
    }

    protected boolean isEnabledForContext(T context) {
        return this.getFolder(context).isInWritableProject();
    }

    private void createNewFolder(T context) {
        DomainFolder parentFolder = this.getFolder(context);
        DomainFolder newFolder = this.createNewFolderWithDefaultName(parentFolder);
        GTreeNode parent = this.getParentNode(context);
        DataTree tree = context.getTree();
        tree.setEditable(true);
        tree.startEditing(parent, newFolder.getName());
    }

    private DomainFolder createNewFolderWithDefaultName(DomainFolder parentFolder) {
        String name = this.getNewFolderName(parentFolder);
        try {
            return parentFolder.createFolder(name);
        }
        catch (InvalidNameException | IOException e) {
            throw new AssertException("Unexpected Error creating new folder: " + name, e);
        }
    }

    private String getNewFolderName(DomainFolder parent) {
        String baseName = "NewFolder";
        Object name = baseName;
        int suffix = 1;
        while (parent.getFolder((String)name) != null) {
            name = baseName + ++suffix;
        }
        return name;
    }

    private DomainFolder getFolder(T context) {
        if (context.getFolderCount() == 1 && context.getFileCount() == 0) {
            return context.getSelectedFolders().get(0);
        }
        if (context.getFileCount() == 1 && context.getFolderCount() == 0) {
            DomainFile file = context.getSelectedFiles().get(0);
            return file.getParent();
        }
        DomainFolderNode rootNode = (DomainFolderNode)context.getTree().getModelRoot();
        return rootNode.getDomainFolder();
    }

    private GTreeNode getParentNode(T context) {
        GTreeNode node = context.getContextNode();
        if (node == null) {
            return context.getTree().getModelRoot();
        }
        if (node instanceof DomainFileNode) {
            return node.getParent();
        }
        return node;
    }
}

