/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.widgets.OptionDialogBuilder;
import ghidra.framework.main.projectdata.actions.FileCountStatistics;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

public class DeleteProjectFilesTask
extends Task {
    private Component parent;
    private Set<DomainFile> selectedFiles;
    private Set<DomainFolder> selectedFolders;
    private OptionDialogBuilder readOnlyDialogBuilder;
    private OptionDialogBuilder checkedOutDialogBuilder;
    private OptionDialogBuilder versionedDialogBuilder;
    private OptionDialogBuilder fileInUseDialogBuilder;
    private FileCountStatistics statistics;

    public DeleteProjectFilesTask(Set<DomainFolder> folders, Set<DomainFile> files, int fileCount, Component parent) {
        super("Delete Files", true, true, true);
        this.parent = parent;
        this.selectedFiles = Objects.requireNonNull(files);
        this.selectedFolders = Objects.requireNonNull(folders);
        this.statistics = new FileCountStatistics(fileCount);
    }

    public void run(TaskMonitor monitor) {
        this.initializeMonitor(monitor);
        this.deleteFiles(this.selectedFiles, monitor);
        this.deleteFolders(this.selectedFolders, monitor);
        this.statistics.showReport(this.parent);
    }

    private void initializeMonitor(TaskMonitor monitor) {
        monitor.setMessage("Deleting Files...");
        monitor.initialize((long)this.statistics.getFileCount());
    }

    private void deleteFiles(Set<DomainFile> files, TaskMonitor monitor) {
        try {
            for (DomainFile file : files) {
                monitor.checkCancelled();
                this.deleteFile(file);
                monitor.incrementProgress(1L);
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void deleteFolders(Set<DomainFolder> folders, TaskMonitor monitor) {
        try {
            for (DomainFolder folder : folders) {
                this.deleteFolder(folder, monitor);
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void deleteFolder(DomainFolder folder, TaskMonitor monitor) throws CancelledException {
        while (folder instanceof LinkedDomainFolder) {
            LinkedDomainFolder linkedFolder = (LinkedDomainFolder)folder;
            if (linkedFolder.isLinked()) {
                throw new IllegalArgumentException("Linked-folder's originating file-link should have been removed instead: " + linkedFolder.getPathname());
            }
            try {
                folder = linkedFolder.getRealFolder();
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)("Error following linked-folder: " + e.getMessage() + "\n" + folder.getPathname()));
                return;
            }
        }
        for (DomainFolder domainFolder : folder.getFolders()) {
            monitor.checkCancelled();
            if (this.selectedFolders.contains(domainFolder)) continue;
            this.deleteFolder(domainFolder, monitor);
        }
        for (Comparable<DomainFolder> comparable : folder.getFiles()) {
            monitor.checkCancelled();
            if (this.selectedFiles.contains(comparable)) continue;
            this.deleteFile((DomainFile)comparable);
            monitor.incrementProgress(1L);
        }
        this.deleteEmptyFolder(folder);
    }

    private void deleteEmptyFolder(DomainFolder folder) {
        if (folder.isEmpty()) {
            try {
                folder.delete();
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)("Unexpected error deleting empty folder: " + folder.getName()), (Throwable)e);
            }
        }
    }

    private void deleteFile(DomainFile file) throws CancelledException {
        block10: {
            int result;
            if (file.isOpen()) {
                this.statistics.incrementFileInUse();
                this.showFileInUseDialog(file);
                return;
            }
            if (file.isVersioned() && file.isCheckedOut()) {
                this.showCheckedOutVersionedDialog(file);
                this.statistics.incrementCheckedOutVersioned();
                return;
            }
            if (file.isReadOnly()) {
                result = this.showConfirmReadOnlyDialog(file);
                if (result == 0) {
                    throw new CancelledException();
                }
                if (result != 1) {
                    this.statistics.incrementReadOnly();
                    return;
                }
            }
            if (file.isVersioned()) {
                result = this.showConfirmDeleteVersionedDialog(file);
                if (result == 0) {
                    throw new CancelledException();
                }
                if (result != 1) {
                    this.statistics.incrementVersioned();
                    return;
                }
            }
            try {
                file.delete();
                this.statistics.incrementDeleted();
            }
            catch (IOException e) {
                this.statistics.incrementGeneralFailure();
                OptionDialogBuilder builder = new OptionDialogBuilder("Delete File Failed", file.getName() + ": " + e.getMessage());
                int result2 = builder.addCancel().setMessageType(0).show(this.parent);
                if (result2 != 0) break block10;
                throw new CancelledException();
            }
        }
    }

    private int showConfirmDeleteVersionedDialog(DomainFile file) {
        if (this.versionedDialogBuilder == null) {
            this.versionedDialogBuilder = new OptionDialogBuilder("Confirm Delete Versioned File").addOption("Yes").addOption("No").addCancel().setMessageType(2);
            if (this.getFileCount() > 1) {
                this.versionedDialogBuilder.addApplyToAllOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is a versioned file and if you continue\nit (and all its versions) will be PERMANENTLY deleted!\nIf this is a shared project, it will be deleted on the server\nfor ALL users (if permitted)!\n\nAre you sure you want to delete it?";
        this.versionedDialogBuilder.setMessage(msg);
        return this.versionedDialogBuilder.show(this.parent);
    }

    private void showCheckedOutVersionedDialog(DomainFile file) throws CancelledException {
        if (this.checkedOutDialogBuilder == null) {
            this.checkedOutDialogBuilder = new OptionDialogBuilder("Delete Not Allowed").addOption("OK").addCancel().setMessageType(0);
            if (this.getFileCount() > 1) {
                this.checkedOutDialogBuilder.addDontShowAgainOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is a versioned file that you have\n checked out. It can't be deleted!";
        this.checkedOutDialogBuilder.setMessage(msg);
        if (this.checkedOutDialogBuilder.show(this.parent) == 0) {
            throw new CancelledException();
        }
    }

    private void showFileInUseDialog(DomainFile file) throws CancelledException {
        if (this.fileInUseDialogBuilder == null) {
            this.fileInUseDialogBuilder = new OptionDialogBuilder("Delete Not Allowed").addOption("OK").setMessageType(0).addCancel();
            if (this.getFileCount() > 1) {
                this.fileInUseDialogBuilder.addDontShowAgainOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is currently in use. It can't \nbe deleted!";
        this.fileInUseDialogBuilder.setMessage(msg);
        if (this.fileInUseDialogBuilder.show(this.parent) == 0) {
            throw new CancelledException();
        }
    }

    private int showConfirmReadOnlyDialog(DomainFile file) {
        if (this.readOnlyDialogBuilder == null) {
            this.readOnlyDialogBuilder = new OptionDialogBuilder("Confirm Delete Read-only File").addOption("Yes").addOption("No").addCancel().setMessageType(2).setDefaultButton("No");
            if (this.getFileCount() > 1) {
                this.readOnlyDialogBuilder.addApplyToAllOption();
            }
        }
        String msg = "The file \"" + file.getName() + "\" is marked as \"Read-Only\". \nAre you sure you want to delete it?";
        this.readOnlyDialogBuilder.setMessage(msg);
        return this.readOnlyDialogBuilder.show(this.parent);
    }

    public synchronized int getFileCount() {
        return this.statistics.getFileCount();
    }

    public synchronized int getTotalDeleted() {
        return this.statistics.getTotalDeleted();
    }
}

