/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.BrokenLinkIcon;
import ghidra.framework.main.datatree.DataTreeNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.SwingWorker;

public class DomainFileNode
extends DataTreeNode {
    private static final Icon UNKNOWN_FILE_ICON = new GIcon("icon.datatree.node.domain.file");
    private static final String RIGHT_ARROW = "\u2192";
    private final DomainFile domainFile;
    private volatile String displayName;
    private volatile Icon icon = UNKNOWN_FILE_ICON;
    private volatile Icon cutIcon;
    private volatile String toolTipText;
    private AtomicInteger refreshCount = new AtomicInteger();
    private boolean isLeaf = true;
    private LinkFileInfo linkInfo;
    private DomainFileFilter filter;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy MMM dd hh:mm aaa");

    DomainFileNode(DomainFile domainFile, DomainFileFilter filter) {
        this.domainFile = domainFile;
        this.linkInfo = domainFile.getLinkInfo();
        this.filter = filter != null ? filter : DomainFileFilter.ALL_FILES_FILTER;
        this.displayName = domainFile.getName();
        this.refresh();
    }

    public boolean isAutoExpandPermitted() {
        return false;
    }

    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public int getChildCount() {
        if (this.isLeaf) {
            return 0;
        }
        return super.getChildCount();
    }

    public boolean isFolderLink() {
        if (this.linkInfo != null) {
            return this.linkInfo.isFolderLink();
        }
        return false;
    }

    LinkedDomainFolder getLinkedFolder() {
        if (!this.isLeaf() && this.linkInfo != null) {
            return this.linkInfo.getLinkedFolder();
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainFileNode node = (DomainFileNode)obj;
        return this.domainFile.equals(node.domainFile);
    }

    @Override
    public int hashCode() {
        return this.domainFile.hashCode();
    }

    public boolean isEditable() {
        return this.domainFile.isInWritableProject();
    }

    public Icon getIcon(boolean expanded) {
        if (this.isCut()) {
            return this.cutIcon;
        }
        return this.icon;
    }

    public String getName() {
        return this.domainFile.getName();
    }

    void setName(String newName) {
        try {
            this.domainFile.setName(newName);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Set Name Failed", (Object)e.getMessage());
        }
    }

    public String getDisplayText() {
        return this.displayName;
    }

    public boolean hasPendingRefresh() {
        return this.refreshCount.get() != 0;
    }

    void refresh() {
        this.refreshCount.incrementAndGet();
        DomainFileNodeSwingWorker worker = new DomainFileNodeSwingWorker();
        worker.execute();
    }

    private void doRefresh() {
        this.isLeaf = true;
        this.linkInfo = null;
        boolean brokenLink = false;
        ArrayList linkErrors = null;
        if (this.domainFile.isLink()) {
            this.linkInfo = this.domainFile.getLinkInfo();
            ArrayList errors = new ArrayList();
            LinkHandler.LinkStatus linkStatus = LinkHandler.getLinkFileStatus(this.domainFile, msg -> errors.add(msg));
            boolean bl = brokenLink = linkStatus == LinkHandler.LinkStatus.BROKEN;
            if (brokenLink) {
                linkErrors = errors;
            } else if (this.isFolderLink()) {
                if (linkStatus == LinkHandler.LinkStatus.INTERNAL) {
                    this.isLeaf = false;
                } else if (linkStatus == LinkHandler.LinkStatus.EXTERNAL && this.filter.followExternallyLinkedFolders()) {
                    this.isLeaf = false;
                }
            }
        }
        if (this.isLeaf) {
            this.unloadChildren();
        }
        this.displayName = this.getFormattedDisplayName();
        this.toolTipText = HTMLUtilities.toLiteralHTMLForTooltip((String)DomainFileNode.getToolTipText(this.domainFile, linkErrors));
        this.refreshIcons(brokenLink);
        this.fireNodeChanged();
    }

    private String getFormattedDisplayName() {
        Object newDisplayName = this.domainFile.getName();
        if (this.domainFile.isHijacked()) {
            newDisplayName = (String)newDisplayName + " (hijacked)";
        } else if (this.domainFile.isVersioned() && !this.domainFile.isLink()) {
            int versionNumber = this.domainFile.getVersion();
            Object versionStr = "" + versionNumber;
            if (versionNumber < 0) {
                versionStr = "?";
            }
            if (this.domainFile.isCheckedOut()) {
                int latestVersionNumber = this.domainFile.getLatestVersion();
                Object latestVersionStr = "" + latestVersionNumber;
                if (latestVersionNumber < 0) {
                    latestVersionStr = "?";
                }
                newDisplayName = (String)newDisplayName + " (" + (String)versionStr + " of " + (String)latestVersionStr + ")";
                if (this.domainFile.modifiedSinceCheckout()) {
                    newDisplayName = (String)newDisplayName + "*";
                }
            } else {
                newDisplayName = (String)newDisplayName + " (" + (String)versionStr + ")";
            }
        }
        if (this.domainFile.isLink()) {
            newDisplayName = (String)newDisplayName + " \u2192 " + this.getFormattedLinkPath();
        }
        return newDisplayName;
    }

    private String getFormattedLinkPath() {
        Object linkPath;
        Object object = linkPath = this.linkInfo != null ? this.linkInfo.getLinkPath() : null;
        if (GhidraURL.isGhidraURL((String)linkPath)) {
            try {
                URL url = new URL((String)linkPath);
                if (GhidraURL.isLocalGhidraURL((String)linkPath)) {
                    ProjectLocator loc = GhidraURL.getProjectStorageLocator(url);
                    if (loc != null) {
                        String projectPath = GhidraURL.getProjectPathname(url);
                        linkPath = loc.getName() + ":" + projectPath;
                    }
                } else if (GhidraURL.isServerURL((String)linkPath)) {
                    String host = url.getHost();
                    String repo = GhidraURL.getRepositoryName(url);
                    if (repo != null) {
                        String projectPath = GhidraURL.getProjectPathname(url);
                        linkPath = host + "[" + repo + "]:" + projectPath;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return linkPath;
    }

    private void refreshIcons(boolean isBrokenLink) {
        this.icon = this.domainFile.getIcon(false);
        this.cutIcon = this.domainFile.getIcon(true);
        if (isBrokenLink) {
            this.icon = new BrokenLinkIcon(this.icon);
            this.cutIcon = new BrokenLinkIcon(this.cutIcon);
        }
    }

    public static String getToolTipText(DomainFile domainFile, List<String> linkErrors) {
        StringBuilder buf = new StringBuilder();
        if (domainFile.isInWritableProject() && domainFile.isHijacked()) {
            buf.append("Hijacked file should be deleted or renamed");
        }
        if (linkErrors != null) {
            linkErrors.forEach(linkError -> DomainFileNode.appendLine(buf, linkError));
        }
        if (domainFile.isCheckedOut()) {
            try {
                ItemCheckoutStatus status = domainFile.getCheckoutStatus();
                if (status != null) {
                    DomainFileNode.appendLine(buf, "Checked out " + formatter.format(new Date(status.getCheckoutTime())));
                }
            }
            catch (IOException status) {
                // empty catch block
            }
        }
        long lastModified = domainFile.getLastModifiedTime();
        DomainFileNode.appendLine(buf, "Last Modified " + formatter.format(new Date(lastModified)));
        if (domainFile.isReadOnly()) {
            DomainFileNode.appendLine(buf, "(read only)");
        }
        return buf.toString();
    }

    private static void appendLine(StringBuilder buf, String line) {
        if (!buf.isEmpty()) {
            buf.append('\n');
        }
        buf.append(line);
    }

    public String getToolTip() {
        return this.toolTipText;
    }

    @Override
    public int compareTo(GTreeNode node) {
        return DATA_NODE_SORT_COMPARATOR.compare(this, node);
    }

    public void valueChanged(Object newValue) {
        if (newValue.equals(this.getName())) {
            return;
        }
        if (newValue instanceof String) {
            try {
                this.domainFile.setName((String)newValue);
            }
            catch (InvalidNameException | DuplicateFileException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)("Invalid name: " + e.getMessage()));
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this.getTree(), (String)"Rename Failed", (Object)("There was a problem renaming the file:\n" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (this.isLeaf || this.linkInfo == null) {
            return List.of();
        }
        return DomainFileNode.generateChildren(this.linkInfo.getLinkedFolder(), this.filter, monitor);
    }

    @Override
    public GTreeNode getChild(String name, DataTreeNode.NodeType type) {
        return DomainFileNode.getChild(this.children(), name, type);
    }

    @Override
    public ProjectData getProjectData() {
        return this.domainFile.getParent().getProjectData();
    }

    private class DomainFileNodeSwingWorker
    extends SwingWorker<DomainFileNode, Object> {
        private DomainFileNodeSwingWorker() {
        }

        @Override
        protected DomainFileNode doInBackground() throws Exception {
            try {
                DomainFileNode.this.doRefresh();
            }
            finally {
                DomainFileNode.this.refreshCount.decrementAndGet();
            }
            return DomainFileNode.this;
        }
    }
}

