/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class DataTreeNode
extends GTreeSlowLoadingNode
implements Cuttable {
    static final Comparator<GTreeNode> DATA_NODE_SORT_COMPARATOR = new DataNodeSortComparator();
    private static final DataNodeSearchComparator DATA_NODE_SEARCH_COMPARATOR = new DataNodeSearchComparator();
    private volatile boolean isCut;

    @Override
    public final void setIsCut(boolean isCut) {
        if (isCut != this.isCut) {
            this.isCut = isCut;
            this.fireNodeChanged();
        }
    }

    @Override
    public final boolean isCut() {
        return this.isCut;
    }

    public abstract ProjectData getProjectData();

    public abstract int compareTo(GTreeNode var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public void addNode(GTreeNode newNode) {
        DomainFileNode folderLink;
        if (!this.isLoaded()) {
            return;
        }
        List allChildren = this.getChildren();
        int index = Collections.binarySearch(allChildren, newNode, DATA_NODE_SORT_COMPARATOR);
        if (index < 0) {
            index = -index - 1;
        }
        this.addNode(index, newNode);
        if (newNode instanceof DomainFolderNode && (folderLink = (DomainFileNode)this.getChild(newNode.getName(), NodeType.FOLDER_LINK)) != null) {
            folderLink.refresh();
        }
    }

    public void removeNode(GTreeNode node) {
        DomainFileNode folderLink;
        if (!this.isLoaded()) {
            return;
        }
        super.removeNode(node);
        if (node instanceof DomainFolderNode && (folderLink = (DomainFileNode)this.getChild(node.getName(), NodeType.FOLDER_LINK)) != null) {
            folderLink.refresh();
        }
    }

    public abstract GTreeNode getChild(String var1, NodeType var2);

    static GTreeNode getChild(List<GTreeNode> children, String name, NodeType type) {
        ChildSearchRecord childSearchRecord = new ChildSearchRecord(name, type);
        int index = Collections.binarySearch(children, childSearchRecord, DATA_NODE_SEARCH_COMPARATOR);
        return index >= 0 ? children.get(index) : null;
    }

    static int compareNodeNames(String n1, String n2) {
        int c = n1.compareToIgnoreCase(n2);
        if (c == 0) {
            c = n1.compareTo(n2);
        }
        return c;
    }

    static List<GTreeNode> generateChildren(DomainFolder domainFolder, DomainFileFilter filter, TaskMonitor monitor) throws CancelledException {
        boolean hideFolderLinks = false;
        boolean hideBroken = false;
        boolean hideExternal = false;
        if (filter != null) {
            hideFolderLinks = filter.ignoreFolderLinks();
            hideBroken = filter.ignoreBrokenLinks();
            hideExternal = filter.ignoreExternalLinks();
        }
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        if (domainFolder != null) {
            DomainFile[] files;
            DomainFolder[] folders;
            for (DomainFolder folder : folders = domainFolder.getFolders()) {
                monitor.checkCancelled();
                children.add((GTreeNode)new DomainFolderNode(folder, filter));
            }
            for (DomainFile df : files = domainFolder.getFiles()) {
                monitor.checkCancelled();
                if (filter != null) {
                    boolean isFolderLink;
                    boolean bl = isFolderLink = df.isLink() && df.getLinkInfo().isFolderLink();
                    if (hideFolderLinks && isFolderLink) continue;
                    if ((hideBroken || hideExternal) && df.isLink()) {
                        LinkHandler.LinkStatus linkStatus = LinkHandler.getLinkFileStatus(df, null);
                        if (hideBroken && linkStatus == LinkHandler.LinkStatus.BROKEN || hideExternal && linkStatus == LinkHandler.LinkStatus.EXTERNAL) continue;
                    }
                    if (!isFolderLink && !filter.accept(df)) continue;
                }
                children.add((GTreeNode)new DomainFileNode(df, filter));
            }
        }
        Collections.sort(children, DATA_NODE_SORT_COMPARATOR);
        return children;
    }

    static enum NodeType {
        FOLDER(1),
        FOLDER_LINK(1),
        FILE(2),
        OTHER(3);

        int weight;

        private NodeType(int weight) {
            this.weight = weight;
        }

        static NodeType getNodeType(GTreeNode node) {
            if (node instanceof DomainFolderNode) {
                return FOLDER;
            }
            if (node instanceof DomainFileNode) {
                DomainFileNode fileNode = (DomainFileNode)node;
                return fileNode.isFolderLink() ? FOLDER_LINK : FILE;
            }
            return OTHER;
        }
    }

    private record ChildSearchRecord(String name, NodeType type) {
    }

    private static class DataNodeSearchComparator
    implements Comparator {
        private DataNodeSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            GTreeNode node = (GTreeNode)o1;
            ChildSearchRecord childSearchRecord = (ChildSearchRecord)o2;
            NodeType type1 = NodeType.getNodeType(node);
            NodeType type2 = childSearchRecord.type;
            int comp = type1.weight - type2.weight;
            if (comp != 0) {
                return comp;
            }
            comp = DataTreeNode.compareNodeNames(node.getName(), childSearchRecord.name);
            if (comp == 0) {
                return type1.ordinal() - type2.ordinal();
            }
            return comp;
        }
    }

    private static class DataNodeSortComparator
    implements Comparator<GTreeNode> {
        private DataNodeSortComparator() {
        }

        @Override
        public int compare(GTreeNode o1, GTreeNode o2) {
            NodeType type1 = NodeType.getNodeType(o1);
            NodeType type2 = NodeType.getNodeType(o2);
            int comp = type1.weight - type2.weight;
            if (comp != 0) {
                return comp;
            }
            comp = DataTreeNode.compareNodeNames(o1.getName(), o2.getName());
            if (comp == 0) {
                return type1.ordinal() - type2.ordinal();
            }
            return comp;
        }
    }
}

