/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.dnd.GenericDataFlavor;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeFlavorHandler;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataTreeDragNDropHandler
implements GTreeDragNDropHandler {
    private static Map<DataFlavor, DataTreeFlavorHandler> activeProjectDropFlavorHandlerMap = new HashMap<DataFlavor, DataTreeFlavorHandler>();
    public static DataFlavor localDomainFileTreeFlavor = DataTreeDragNDropHandler.createLocalTreeNodeFlavor();
    public static DataFlavor localDomainFileFlavor = DataTreeDragNDropHandler.createLocalTreeFlavor();
    public static DataFlavor[] allSupportedFlavors = new DataFlavor[]{localDomainFileTreeFlavor, localDomainFileFlavor, DataFlavor.stringFlavor};
    private boolean isActiveProject;
    private final FrontEndTool tool;
    private final DataTree tree;

    private static DataFlavor createLocalTreeNodeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.util.List", "Local list of Drag/Drop Project Domain Tree objects");
        }
        catch (Exception e) {
            Msg.showError(DataTreeDragNDropHandler.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    private static DataFlavor createLocalTreeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.util.List", "Local list of Drag/Drop Project Domain objects");
        }
        catch (Exception e) {
            Msg.showError(DataTreeDragNDropHandler.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    DataTreeDragNDropHandler(FrontEndTool tool, DataTree tree, boolean isActiveProject) {
        this.tool = tool;
        this.tree = tree;
        this.isActiveProject = isActiveProject;
    }

    public void drop(GTreeNode destination, Transferable transferable, int dropAction) {
        DataFlavor[] transferDataFlavors;
        for (DataFlavor dataFlavor : transferDataFlavors = transferable.getTransferDataFlavors()) {
            DataTreeFlavorHandler flavorHandler = this.getFlavorHandler(dataFlavor);
            if (flavorHandler == null || !this.handleDrop(destination, transferable, dropAction, dataFlavor, flavorHandler)) continue;
            return;
        }
    }

    private boolean handleDrop(GTreeNode destination, Transferable transferable, int dropAction, DataFlavor dataFlavor, DataTreeFlavorHandler flavorHandler) {
        try {
            Object transferData = transferable.getTransferData(dataFlavor);
            return flavorHandler.handle(this.tool, this.tree, destination, transferData, dropAction);
        }
        catch (UnsupportedFlavorException e) {
            throw new AssertException("Got unsupported flavor from using a supported flavor");
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"IO Error", (Object)"Error during drop", (Throwable)e);
            return false;
        }
    }

    private DataTreeFlavorHandler getFlavorHandler(DataFlavor flavor) {
        return activeProjectDropFlavorHandlerMap.get(flavor);
    }

    public int getSupportedDragActions() {
        return 3;
    }

    public boolean isDropSiteOk(GTreeNode destUserData, DataFlavor[] flavors, int dropAction) {
        if (!this.isActiveProject) {
            return false;
        }
        if ("NO ACTIVE PROJECT".equals(destUserData.getName())) {
            return false;
        }
        return DataTree.getRealInternalFolderForNode(destUserData) != null;
    }

    public boolean isStartDragOk(List<GTreeNode> dragUserData, int dragAction) {
        for (GTreeNode gTreeNode : dragUserData) {
            if (gTreeNode.getParent() == null) continue;
            return true;
        }
        return false;
    }

    public DataFlavor[] getSupportedDataFlavors(List<GTreeNode> transferNodes) {
        return allSupportedFlavors;
    }

    public Object getTransferData(List<GTreeNode> transferNodes, DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor == localDomainFileTreeFlavor) {
            return this.removeDuplicates(transferNodes);
        }
        if (flavor == localDomainFileFlavor) {
            return transferNodes.stream().filter(DomainFileNode.class::isInstance).map(node -> ((DomainFileNode)node).getDomainFile()).collect(Collectors.toList());
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return transferNodes.stream().map(node -> node.getName()).collect(Collectors.joining("\n"));
        }
        throw new AssertException("Called with a flavor that we didn't say we supported");
    }

    private List<GTreeNode> removeDuplicates(List<GTreeNode> allNodes) {
        List<GTreeNode> parentNodes = this.getDomainParentNodes(allNodes);
        return allNodes.stream().filter(node -> !this.isChildOfParents(parentNodes, (GTreeNode)node)).collect(Collectors.toList());
    }

    private List<GTreeNode> getDomainParentNodes(List<GTreeNode> nodeList) {
        ArrayList<GTreeNode> parentList = new ArrayList<GTreeNode>();
        for (GTreeNode node : nodeList) {
            if (node.isLeaf()) continue;
            parentList.add(node);
        }
        return parentList;
    }

    private boolean isChildOfParents(List<GTreeNode> parentNodes, GTreeNode fileNode) {
        for (GTreeNode node = fileNode.getParent(); node != null; node = node.getParent()) {
            if (!parentNodes.contains(node)) continue;
            return true;
        }
        return false;
    }

    public static void addActiveDataFlavorHandler(DataFlavor flavor, DataTreeFlavorHandler handler) {
        activeProjectDropFlavorHandlerMap.put(flavor, handler);
    }

    public static DataTreeFlavorHandler removeActiveDataFlavorHandler(DataFlavor flavor) {
        return activeProjectDropFlavorHandlerMap.remove(flavor);
    }

    public void setProjectActive(boolean b) {
        this.isActiveProject = b;
    }
}

