/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.LinkedGhidraFile;
import ghidra.framework.data.LinkedGhidraFolder;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;

class LinkedGhidraSubFolder
implements LinkedDomainFolder {
    private final LinkedGhidraFolder linkedRootFolder;
    private final LinkedGhidraSubFolder parent;
    private final String folderName;

    LinkedGhidraSubFolder(String linkFileName) {
        this.linkedRootFolder = this.getLinkedRootFolder();
        this.parent = null;
        this.folderName = linkFileName;
    }

    LinkedGhidraSubFolder(LinkedGhidraSubFolder parent, String folderName) {
        this.linkedRootFolder = parent.getLinkedRootFolder();
        this.parent = parent;
        this.folderName = folderName;
    }

    LinkedGhidraFolder getLinkedRootFolder() {
        return this.linkedRootFolder;
    }

    @Override
    public boolean isExternal() {
        return this.linkedRootFolder.isExternal();
    }

    @Override
    public boolean isInWritableProject() {
        return this.linkedRootFolder.isInWritableProject();
    }

    @Override
    public DomainFolder getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.folderName;
    }

    @Override
    public DomainFolder getRealFolder() throws IOException {
        return this.linkedRootFolder.getRealFolder(this.getLinkedPathname());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkedGhidraSubFolder)) {
            return false;
        }
        LinkedGhidraSubFolder other = (LinkedGhidraSubFolder)obj;
        return this.folderName.equals(other.folderName) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        return this.getPathname().hashCode();
    }

    @Override
    public int compareTo(DomainFolder df) {
        return this.getName().compareToIgnoreCase(df.getName());
    }

    @Override
    public boolean isSame(DomainFolder folder) {
        if (!this.getProjectLocator().equals(folder.getProjectLocator()) && !SystemUtilities.isEqual((Object)this.getProjectData().getSharedProjectURL(), (Object)folder.getProjectData().getSharedProjectURL())) {
            return false;
        }
        return this.getPathname().equals(folder.getPathname());
    }

    @Override
    public boolean isSameOrAncestor(DomainFolder folder) {
        if (!this.getProjectLocator().equals(folder.getProjectLocator()) && !SystemUtilities.isEqual((Object)this.getProjectData().getSharedProjectURL(), (Object)folder.getProjectData().getSharedProjectURL())) {
            return false;
        }
        String pathname = this.getPathname();
        for (DomainFolder f = folder; f != null; f = f.getParent()) {
            if (f != this && !pathname.equals(f.getPathname())) continue;
            return true;
        }
        return false;
    }

    @Override
    public DomainFolder setName(String newName) throws InvalidNameException, IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        String name = linkedFolder.setName(newName).getName();
        return this.parent.getFolder(name);
    }

    @Override
    public URL getSharedProjectURL() {
        URL projectURL = this.getLinkedRootFolder().getProjectURL();
        if (GhidraURL.isServerRepositoryURL(projectURL)) {
            Object path;
            String urlStr = projectURL.toExternalForm();
            if (urlStr.endsWith(FileSystem.SEPARATOR)) {
                urlStr = urlStr.substring(0, urlStr.length() - 1);
            }
            if (!((String)(path = this.getLinkedPathname())).endsWith(FileSystem.SEPARATOR)) {
                path = (String)path + FileSystem.SEPARATOR;
            }
            try {
                return new URL(urlStr + (String)path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getLocalProjectURL() {
        ProjectLocator projectLocator = this.parent.getProjectLocator();
        if (!projectLocator.isTransient()) {
            return GhidraURL.makeURL(projectLocator, this.getPathname(), null);
        }
        return null;
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.parent.getProjectLocator();
    }

    @Override
    public ProjectData getLinkedProjectData() throws IOException {
        return this.linkedRootFolder.getLinkedProjectData();
    }

    @Override
    public ProjectData getProjectData() {
        return this.parent.getProjectData();
    }

    @Override
    public String getPathname() {
        Object path = this.getParent().getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.folderName;
        return path;
    }

    @Override
    public String getLinkedPathname() {
        return this.parent.getLinkedPathname(this.folderName);
    }

    final String getLinkedPathname(String childName) {
        Object path = this.getLinkedPathname();
        if (!((String)path).endsWith(FileSystem.SEPARATOR)) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + childName;
        return path;
    }

    public LinkedGhidraSubFolder[] getFolders() {
        try {
            DomainFolder linkedFolder = this.getRealFolder();
            DomainFolder[] folders = linkedFolder.getFolders();
            LinkedGhidraSubFolder[] linkedSubFolders = new LinkedGhidraSubFolder[folders.length];
            for (int i = 0; i < folders.length; ++i) {
                linkedSubFolders[i] = new LinkedGhidraSubFolder(this, folders[i].getName());
            }
            return linkedSubFolders;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure '" + String.valueOf(this) + "': " + e.getMessage()));
            return new LinkedGhidraSubFolder[0];
        }
    }

    @Override
    public LinkedGhidraSubFolder getFolder(String name) {
        try {
            DomainFolder linkedFolder = this.getRealFolder();
            DomainFolder f = linkedFolder.getFolder(name);
            if (f != null) {
                return new LinkedGhidraSubFolder(this, name);
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure '" + String.valueOf(this) + "': " + e.getMessage()));
        }
        return null;
    }

    @Override
    public DomainFile[] getFiles() {
        try {
            DomainFolder linkedFolder = this.getRealFolder();
            DomainFile[] files = linkedFolder.getFiles();
            DomainFile[] linkedSubFolders = new LinkedGhidraFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                linkedSubFolders[i] = new LinkedGhidraFile(this, files[i].getName());
            }
            return linkedSubFolders;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure '" + String.valueOf(this) + "': " + e.getMessage()));
            return new LinkedGhidraFile[0];
        }
    }

    public DomainFile getLinkedFileNoError(String name) {
        try {
            DomainFolder linkedFolder = this.getRealFolder();
            return linkedFolder.getFile(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    DomainFile getLinkedFile(String name) throws IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        DomainFile df = linkedFolder.getFile(name);
        if (df == null) {
            throw new FileNotFoundException("linked-file '" + name + "' not found");
        }
        return df;
    }

    @Override
    public DomainFile getFile(String name) {
        DomainFile f = this.getLinkedFileNoError(name);
        return f != null ? new LinkedGhidraFile(this, name) : null;
    }

    @Override
    public boolean isEmpty() {
        try {
            DomainFolder linkedFolder = this.getRealFolder();
            return linkedFolder.isEmpty();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure '" + String.valueOf(this) + "': " + e.getMessage()));
            return true;
        }
    }

    @Override
    public DomainFile createFile(String name, DomainObject obj, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        DomainFolder linkedFolder = this.getRealFolder();
        return linkedFolder.createFile(name, obj, monitor);
    }

    @Override
    public DomainFile createFile(String name, File packFile, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        DomainFolder linkedFolder = this.getRealFolder();
        return linkedFolder.createFile(name, packFile, monitor);
    }

    @Override
    public DomainFile createLinkFile(ProjectData sourceProjectData, String pathname, boolean makeRelative, String linkFilename, LinkHandler<?> lh) throws IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        return linkedFolder.createLinkFile(sourceProjectData, pathname, makeRelative, linkFilename, lh);
    }

    @Override
    public DomainFile createLinkFile(String ghidraUrl, String linkFilename, LinkHandler<?> lh) throws IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        return linkedFolder.createLinkFile(ghidraUrl, linkFilename, lh);
    }

    @Override
    public DomainFolder createFolder(String name) throws InvalidNameException, IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        DomainFolder child = linkedFolder.createFolder(name);
        return new LinkedGhidraSubFolder(this.parent, child.getName());
    }

    @Override
    public void delete() throws IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        linkedFolder.delete();
    }

    @Override
    public DomainFolder moveTo(DomainFolder newParent) throws IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        return linkedFolder.moveTo(newParent);
    }

    @Override
    public DomainFolder copyTo(DomainFolder newParent, TaskMonitor monitor) throws IOException, CancelledException {
        DomainFolder linkedFolder = this.getRealFolder();
        return linkedFolder.copyTo(newParent, monitor);
    }

    @Override
    public DomainFile copyToAsLink(DomainFolder newParent, boolean relative) throws IOException {
        DomainFolder linkedFolder = this.getRealFolder();
        return linkedFolder.copyToAsLink(newParent, relative);
    }

    @Override
    public void setActive() {
        try {
            DomainFolder linkedFolder = this.getRealFolder();
            linkedFolder.setActive();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        Object str = this.parent.toString();
        if (!((String)str).endsWith("/")) {
            str = (String)str + "/";
        }
        str = (String)str + this.getName();
        return str;
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return isOpen ? OPEN_FOLDER_ICON : CLOSED_FOLDER_ICON;
    }
}

