/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.theme.GIcon;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.LinkedGhidraSubFolder;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import ghidra.util.InvalidNameException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;

public class LinkedGhidraFolder
extends LinkedGhidraSubFolder {
    public static Icon FOLDER_LINK_CLOSED_ICON = new GIcon("icon.content.handler.linked.folder.closed");
    public static Icon FOLDER_LINK_OPEN_ICON = new GIcon("icon.content.handler.linked.folder.open");
    private final DomainFile folderLinkFile;
    private final URL linkedFolderUrl;
    private final DomainFolder linkedFolder;
    private final String linkedPathname;
    private final URL projectUrl;
    private boolean offline = false;

    LinkedGhidraFolder(DomainFile folderLinkFile, URL linkedFolderUrl) {
        super(folderLinkFile.getName());
        if (!GhidraURL.isServerRepositoryURL(linkedFolderUrl) && !GhidraURL.isLocalProjectURL(linkedFolderUrl)) {
            throw new IllegalArgumentException("Invalid Ghidra URL: " + String.valueOf(linkedFolderUrl));
        }
        this.folderLinkFile = folderLinkFile;
        this.linkedFolderUrl = linkedFolderUrl;
        this.linkedFolder = null;
        String pathname = GhidraURL.getProjectPathname(linkedFolderUrl);
        if (!FileSystem.SEPARATOR.equals(pathname) && pathname.endsWith(FileSystem.SEPARATOR)) {
            pathname = pathname.substring(0, pathname.length() - 1);
        }
        this.linkedPathname = pathname;
        this.projectUrl = GhidraURL.getProjectURL(linkedFolderUrl);
    }

    LinkedGhidraFolder(DomainFile folderLinkFile, DomainFolder linkedFolder) {
        super(folderLinkFile.getName());
        this.folderLinkFile = folderLinkFile;
        this.linkedFolder = linkedFolder;
        this.linkedFolderUrl = null;
        this.linkedPathname = linkedFolder.getPathname();
        this.projectUrl = linkedFolder.getProjectLocator().getURL();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkedGhidraFolder)) {
            return false;
        }
        LinkedGhidraFolder other = (LinkedGhidraFolder)obj;
        return this.linkedPathname.equals(other.linkedPathname) && this.folderLinkFile.equals(other.folderLinkFile);
    }

    @Override
    public boolean isExternal() {
        return this.linkedFolderUrl != null;
    }

    public URL getProjectURL() {
        return this.projectUrl;
    }

    @Override
    LinkedGhidraFolder getLinkedRootFolder() {
        return this;
    }

    @Override
    public boolean isInWritableProject() {
        return this.linkedFolder != null && this.linkedFolder.isInWritableProject();
    }

    @Override
    public ProjectData getLinkedProjectData() throws IOException {
        ProjectData projectData;
        if (this.linkedFolder != null) {
            projectData = this.linkedFolder.getProjectData();
        } else {
            Project activeProject = AppInfo.getActiveProject();
            if (activeProject == null) {
                this.offline = true;
                throw new IOException("active project not found");
            }
            URL url = this.getProjectURL();
            projectData = activeProject.getProjectData(url);
            if (projectData == null && !this.offline) {
                this.offline = true;
                projectData = activeProject.addProjectView(url, false);
                if (projectData != null) {
                    this.offline = false;
                    RepositoryAdapter repository = projectData.getRepository();
                    if (repository != null && !repository.isConnected()) {
                        this.offline = true;
                    }
                }
            }
            if (projectData == null) {
                throw new FileNotFoundException("failed to add project view: " + String.valueOf(url));
            }
        }
        return projectData;
    }

    synchronized DomainFolder getRealFolder(String linkedPath) throws IOException {
        ProjectData projectData = this.getLinkedProjectData();
        DomainFolder folder = projectData.getFolder(linkedPath);
        if (folder == null) {
            RepositoryAdapter repository = projectData.getRepository();
            if (repository != null && !this.offline && !repository.isConnected()) {
                repository.connect();
                if (!repository.isConnected()) {
                    this.offline = true;
                    throw new FileNotFoundException("linked project/repository not connected");
                }
                folder = projectData.getFolder(linkedPath);
            }
            if (folder == null) {
                String notConnectedMsg = this.offline ? " (not connected)" : "";
                throw new FileNotFoundException("folder not found" + notConnectedMsg);
            }
        }
        return folder;
    }

    @Override
    public String getLinkedPathname() {
        return this.linkedPathname;
    }

    @Override
    public DomainFolder getRealFolder() throws IOException {
        return this.getRealFolder(this.linkedPathname);
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.folderLinkFile.getProjectLocator();
    }

    @Override
    public ProjectData getProjectData() {
        return this.folderLinkFile.getParent().getProjectData();
    }

    @Override
    public DomainFolder getParent() {
        return this.folderLinkFile.getParent();
    }

    @Override
    public DomainFolder setName(String newName) throws InvalidNameException, IOException {
        DomainFile linkFile = this.folderLinkFile.setName(newName);
        if (this.linkedFolder != null) {
            return new LinkedGhidraFolder(linkFile, this.linkedFolder);
        }
        return new LinkedGhidraFolder(linkFile, this.linkedFolderUrl);
    }

    @Override
    public String toString() {
        if (this.linkedFolder != null) {
            return "->" + this.getLinkedPathname();
        }
        return "->" + this.linkedFolderUrl.toString();
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return isOpen ? FOLDER_LINK_OPEN_ICON : FOLDER_LINK_CLOSED_ICON;
    }

    @Override
    public boolean isLinked() {
        return true;
    }

    public boolean isUrlLinked() {
        if (this.linkedFolderUrl != null) {
            return true;
        }
        DomainFolder domainFolder = this.linkedFolder;
        if (domainFolder instanceof LinkedGhidraFolder) {
            LinkedGhidraFolder lf = (LinkedGhidraFolder)domainFolder;
            return lf.isUrlLinked();
        }
        return false;
    }
}

