/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.CheckinHandler;
import ghidra.framework.data.LinkedGhidraSubFolder;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.LinkedDomainFile;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.help.UnsupportedOperationException;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

class LinkedGhidraFile
implements LinkedDomainFile {
    private final LinkedGhidraSubFolder parent;
    private final String fileName;

    LinkedGhidraFile(LinkedGhidraSubFolder parent, String fileName) {
        this.parent = parent;
        this.fileName = fileName;
    }

    @Override
    public DomainFile getLinkedFile() throws IOException {
        return this.parent.getLinkedFile(this.fileName);
    }

    private DomainFile getLinkedFileNoError() {
        return this.parent.getLinkedFileNoError(this.fileName);
    }

    @Override
    public DomainFolder getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkedGhidraFile)) {
            return false;
        }
        LinkedGhidraFile other = (LinkedGhidraFile)obj;
        return this.fileName.equals(other.fileName) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        return this.getPathname().hashCode();
    }

    @Override
    public int compareTo(DomainFile df) {
        return this.fileName.compareToIgnoreCase(df.getName());
    }

    @Override
    public boolean exists() {
        return this.getLinkedFileNoError() != null;
    }

    @Override
    public String getFileID() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getFileID() : null;
    }

    @Override
    public DomainFile setName(String newName) throws InvalidNameException, IOException {
        String name = this.getLinkedFile().setName(newName).getName();
        return this.parent.getFile(name);
    }

    @Override
    public String getPathname() {
        Object path = this.getParent().getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.fileName;
        return path;
    }

    @Override
    public URL getSharedProjectURL(String ref) {
        URL folderURL = this.parent.getSharedProjectURL();
        if (GhidraURL.isServerRepositoryURL(folderURL)) {
            try {
                Object spec = this.fileName;
                if (!StringUtils.isEmpty((CharSequence)ref)) {
                    spec = (String)spec + "#" + ref;
                }
                return new URL(folderURL, (String)spec);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getLocalProjectURL(String ref) {
        ProjectLocator projectLocator = this.parent.getProjectLocator();
        if (!projectLocator.isTransient()) {
            return GhidraURL.makeURL(projectLocator, this.getPathname(), ref);
        }
        return null;
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.parent.getProjectLocator();
    }

    @Override
    public String getContentType() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getContentType() : "Unknown-File";
    }

    @Override
    public Class<? extends DomainObject> getDomainObjectClass() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getDomainObjectClass() : DomainObject.class;
    }

    @Override
    public ChangeSet getChangesByOthersSinceCheckout() throws VersionException, IOException {
        return this.getLinkedFile().getChangesByOthersSinceCheckout();
    }

    @Override
    public DomainObject getDomainObject(Object consumer, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getLinkedFile().getDomainObject(consumer, okToUpgrade, okToRecover, monitor);
    }

    @Override
    public DomainObject getOpenedDomainObject(Object consumer) {
        DomainFile df = this.getLinkedFileNoError();
        if (df != null) {
            return df.getOpenedDomainObject(consumer);
        }
        return null;
    }

    @Override
    public DomainObject getReadOnlyDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getLinkedFile().getReadOnlyDomainObject(consumer, version, monitor);
    }

    @Override
    public DomainObject getImmutableDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getLinkedFile().getImmutableDomainObject(consumer, version, monitor);
    }

    @Override
    public void save(TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public boolean canRecover() {
        return false;
    }

    @Override
    public boolean takeRecoverySnapshot() throws IOException {
        return true;
    }

    @Override
    public boolean isInWritableProject() {
        return this.parent.isInWritableProject();
    }

    @Override
    public long getLastModifiedTime() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getLastModifiedTime() : 0L;
    }

    @Override
    public Icon getIcon(boolean disabled) {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getIcon(disabled) : UNSUPPORTED_FILE_ICON;
    }

    @Override
    public boolean isCheckedOut() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isCheckedOut() : false;
    }

    @Override
    public boolean isCheckedOutExclusive() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isCheckedOutExclusive() : false;
    }

    @Override
    public boolean modifiedSinceCheckout() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.modifiedSinceCheckout() : false;
    }

    @Override
    public boolean canCheckout() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.canCheckout() : false;
    }

    @Override
    public boolean canCheckin() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.canCheckin() : false;
    }

    @Override
    public boolean canMerge() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.canMerge() : false;
    }

    @Override
    public boolean canAddToRepository() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.canAddToRepository() : false;
    }

    @Override
    public void setReadOnly(boolean state) throws IOException {
        this.getLinkedFile().setReadOnly(state);
    }

    @Override
    public boolean isReadOnly() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isReadOnly() : true;
    }

    @Override
    public boolean isVersioned() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isVersioned() : false;
    }

    @Override
    public boolean isHijacked() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isHijacked() : false;
    }

    @Override
    public int getLatestVersion() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getLatestVersion() : -1;
    }

    @Override
    public boolean isLatestVersion() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isLatestVersion() : true;
    }

    @Override
    public int getVersion() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getVersion() : -1;
    }

    @Override
    public Version[] getVersionHistory() throws IOException {
        DomainFile df = this.getLinkedFile();
        return df != null ? df.getVersionHistory() : new Version[]{};
    }

    @Override
    public void addToVersionControl(String comment, boolean keepCheckedOut, TaskMonitor monitor) throws IOException, CancelledException {
        this.getLinkedFile().addToVersionControl(comment, keepCheckedOut, monitor);
    }

    @Override
    public boolean checkout(boolean exclusive, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getLinkedFile().checkout(exclusive, monitor);
    }

    @Override
    public void checkin(CheckinHandler checkinHandler, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.getLinkedFile().checkin(checkinHandler, monitor);
    }

    @Override
    public void merge(boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.getLinkedFile().merge(okToUpgrade, monitor);
    }

    @Override
    public void undoCheckout(boolean keep) throws IOException {
        this.getLinkedFile().undoCheckout(keep);
    }

    @Override
    public void undoCheckout(boolean keep, boolean force) throws IOException {
        this.getLinkedFile().undoCheckout(keep, force);
    }

    @Override
    public void terminateCheckout(long checkoutId) throws IOException {
        this.getLinkedFile().terminateCheckout(checkoutId);
    }

    @Override
    public ItemCheckoutStatus[] getCheckouts() throws IOException {
        return this.getLinkedFile().getCheckouts();
    }

    @Override
    public ItemCheckoutStatus getCheckoutStatus() throws IOException {
        return this.getLinkedFile().getCheckoutStatus();
    }

    @Override
    public void delete() throws IOException {
        this.getLinkedFile().delete();
    }

    @Override
    public void delete(int version) throws IOException {
        this.getLinkedFile().delete(version);
    }

    @Override
    public DomainFile moveTo(DomainFolder newParent) throws IOException {
        return this.getLinkedFile().moveTo(newParent);
    }

    @Override
    public DomainFile copyTo(DomainFolder newParent, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getLinkedFile().copyTo(newParent, monitor);
    }

    @Override
    public DomainFile copyVersionTo(int version, DomainFolder destFolder, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getLinkedFile().copyVersionTo(version, destFolder, monitor);
    }

    @Override
    public DomainFile copyToAsLink(DomainFolder newParent, boolean relative) throws IOException {
        return this.getLinkedFile().copyToAsLink(newParent, relative);
    }

    @Override
    public boolean isLinkingSupported() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isLinkingSupported() : false;
    }

    @Override
    public List<?> getConsumers() {
        return List.of();
    }

    @Override
    public boolean isChanged() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isChanged() : false;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void packFile(File file, TaskMonitor monitor) throws IOException, CancelledException {
        this.getLinkedFile().packFile(file, monitor);
    }

    @Override
    public Map<String, String> getMetadata() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getMetadata() : Map.of();
    }

    @Override
    public long length() throws IOException {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.length() : 0L;
    }

    @Override
    public boolean isLink() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.isLink() : false;
    }

    @Override
    public LinkFileInfo getLinkInfo() {
        DomainFile df = this.getLinkedFileNoError();
        return df != null ? df.getLinkInfo() : null;
    }

    @Override
    public String getLinkedPathname() {
        return this.parent.getLinkedPathname(this.fileName);
    }

    public String toString() {
        Object str = this.parent.toString();
        if (!((String)str).endsWith("/")) {
            str = (String)str + "/";
        }
        str = (String)str + this.getName();
        return str;
    }
}

