/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.GhidraFileData;
import ghidra.framework.data.GhidraFolderData;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class GhidraFolder
implements DomainFolder {
    private DefaultProjectData projectData;
    private LocalFileSystem fileSystem;
    private FileSystem versionedFileSystem;
    private DomainFolderChangeListener listener;
    private GhidraFolder parent;
    private String name;

    GhidraFolder(DefaultProjectData projectData, DomainFolderChangeListener listener) {
        this.projectData = projectData;
        this.fileSystem = projectData.getLocalFileSystem();
        this.versionedFileSystem = projectData.getVersionedFileSystem();
        this.listener = listener;
        this.name = FileSystem.SEPARATOR;
    }

    GhidraFolder(GhidraFolder parent, String name) {
        this.parent = parent;
        this.name = name;
        this.projectData = parent.getProjectData();
        this.fileSystem = parent.getLocalFileSystem();
        this.versionedFileSystem = parent.getVersionedFileSystem();
        this.listener = parent.getChangeListener();
    }

    LocalFileSystem getLocalFileSystem() {
        return this.fileSystem;
    }

    FileSystem getVersionedFileSystem() {
        return this.versionedFileSystem;
    }

    LocalFileSystem getUserFileSystem() {
        return this.projectData.getUserFileSystem();
    }

    DomainFolderChangeListener getChangeListener() {
        return this.listener;
    }

    GhidraFileData getFileData(String fileName) throws FileNotFoundException, IOException {
        GhidraFileData fileData = this.getFolderData().getFileData(fileName, false);
        if (fileData == null) {
            throw new FileNotFoundException("file " + this.getPathname(fileName) + " not found");
        }
        return fileData;
    }

    GhidraFolderData getFolderData() throws FileNotFoundException {
        if (this.parent == null) {
            return this.projectData.getRootFolderData();
        }
        GhidraFolderData folderData = this.parent.getFolderData().getFolderData(this.name, false);
        if (folderData == null) {
            throw new FileNotFoundException("folder " + this.getPathname() + " not found");
        }
        return folderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GhidraFolderData createFolderData(String folderName) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            GhidraFolderData parentData = this.parent == null ? this.projectData.getRootFolderData() : this.createFolderData();
            GhidraFolderData folderData = parentData.getFolderData(folderName, false);
            if (folderData == null) {
                try {
                    folderData = parentData.createFolder(folderName);
                }
                catch (InvalidNameException e) {
                    throw new IOException(e);
                }
            }
            return folderData;
        }
    }

    private GhidraFolderData createFolderData() throws IOException {
        GhidraFolderData rootFolderData = this.projectData.getRootFolderData();
        if (this.parent == null) {
            return rootFolderData;
        }
        return this.parent.createFolderData(this.name);
    }

    void refreshFolderData() throws IOException {
        this.getFolderData().refresh(false, true, TaskMonitor.DUMMY);
    }

    @Override
    public int compareTo(DomainFolder df) {
        return this.name.compareToIgnoreCase(df.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GhidraFolder setName(String newName) throws InvalidNameException, IOException {
        return this.getFolderData().setName(newName);
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.projectData.getProjectLocator();
    }

    @Override
    public DefaultProjectData getProjectData() {
        return this.projectData;
    }

    String getPathname(String childName) {
        Object path = this.getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + childName;
        return path;
    }

    @Override
    public String getPathname() {
        if (this.parent == null) {
            return FileSystem.SEPARATOR;
        }
        Object path = this.parent.getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.name;
        return path;
    }

    @Override
    public URL getSharedProjectURL() {
        URL projectURL = this.projectData.getSharedProjectURL();
        if (projectURL == null) {
            return null;
        }
        try {
            Object path;
            Object urlStr = projectURL.toExternalForm();
            if (((String)urlStr).endsWith(FileSystem.SEPARATOR)) {
                urlStr = ((String)urlStr).substring(0, ((String)urlStr).length() - 1);
            }
            if (!((String)(path = this.getPathname())).endsWith(FileSystem.SEPARATOR)) {
                path = (String)path + FileSystem.SEPARATOR;
            }
            urlStr = (String)urlStr + (String)path;
            return new URL((String)urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL getLocalProjectURL() {
        ProjectLocator projectLocator = this.projectData.getProjectLocator();
        if (!projectLocator.isTransient()) {
            return GhidraURL.makeURL(projectLocator, this.getPathname(), null);
        }
        return null;
    }

    @Override
    public boolean isInWritableProject() {
        return !this.fileSystem.isReadOnly();
    }

    @Override
    public DomainFolder getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GhidraFolder[] getFolders() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                GhidraFolderData folderData = this.getFolderData();
                List<String> folderNames = folderData.getFolderNames();
                int count = folderNames.size();
                GhidraFolder[] folders = new GhidraFolder[count];
                for (int i = 0; i < count; ++i) {
                    folders[i] = new GhidraFolder(this, folderNames.get(i));
                }
                return folders;
            }
            catch (FileNotFoundException e) {
                return new GhidraFolder[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GhidraFolder getFolder(String folderName) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                GhidraFolderData folderData = this.getFolderData();
                return folderData.getDomainFolder(folderName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                GhidraFolderData folderData = this.getFolderData();
                return folderData.isEmpty();
            }
            catch (FileNotFoundException e) {
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GhidraFile[] getFiles() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                GhidraFolderData folderData = this.getFolderData();
                List<String> fileNames = folderData.getFileNames();
                int count = fileNames.size();
                GhidraFile[] files = new GhidraFile[count];
                for (int i = 0; i < count; ++i) {
                    files[i] = new GhidraFile(this, fileNames.get(i));
                }
                return files;
            }
            catch (FileNotFoundException e) {
                return new GhidraFile[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GhidraFile getFile(String fileName) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            GhidraFolderData folderData;
            try {
                folderData = this.getFolderData();
            }
            catch (FileNotFoundException e) {
                return null;
            }
            try {
                if (folderData.containsFile(fileName)) {
                    return new GhidraFile(this, fileName);
                }
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("file error for " + this.getPathname(fileName)), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public DomainFile createFile(String fileName, DomainObject obj, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        return this.createFolderData().createFile(fileName, obj, monitor != null ? monitor : TaskMonitor.DUMMY);
    }

    @Override
    public DomainFile createFile(String fileName, File packFile, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        return this.createFolderData().createFile(fileName, packFile, monitor != null ? monitor : TaskMonitor.DUMMY);
    }

    @Override
    public DomainFile createLinkFile(ProjectData sourceProjectData, String pathname, boolean makeRelative, String linkFilename, LinkHandler<?> lh) throws IOException {
        return this.createFolderData().createLinkFile(sourceProjectData, pathname, makeRelative, linkFilename, lh);
    }

    @Override
    public DomainFile createLinkFile(String ghidraUrl, String linkFilename, LinkHandler<?> lh) throws IOException {
        return this.createFolderData().createLinkFile(ghidraUrl, linkFilename, lh);
    }

    @Override
    public GhidraFolder createFolder(String folderName) throws InvalidNameException, IOException {
        return this.createFolderData().createFolder(folderName).getDomainFolder();
    }

    @Override
    public void delete() throws IOException {
        try {
            this.getFolderData().delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    static GhidraFolder getDestinationFolder(DomainFolder newParent) throws IOException {
        while (newParent instanceof LinkedDomainFolder) {
            LinkedDomainFolder linkedFolder = (LinkedDomainFolder)newParent;
            if (!linkedFolder.isInWritableProject()) {
                throw new IOException("Destination folder is not within writable project");
            }
            newParent = linkedFolder.getRealFolder();
        }
        if (!newParent.isInWritableProject() || !(newParent instanceof GhidraFolder)) {
            throw new IOException("Destination folder is not within writable project");
        }
        GhidraFolder ghidraFolder = (GhidraFolder)newParent;
        return ghidraFolder;
    }

    @Override
    public GhidraFolder moveTo(DomainFolder newParent) throws IOException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("root folder may not be moved");
        }
        if (this.getProjectData() != newParent.getProjectData() || !this.isInWritableProject()) {
            throw new IOException("Move only supported within the same writable project");
        }
        GhidraFolder newGhidraParent = GhidraFolder.getDestinationFolder(newParent);
        return this.getFolderData().moveTo(newGhidraParent.getFolderData());
    }

    @Override
    public GhidraFolder copyTo(DomainFolder newParent, TaskMonitor monitor) throws IOException, CancelledException {
        GhidraFolder newGhidraParent = GhidraFolder.getDestinationFolder(newParent);
        return this.getFolderData().copyTo(newGhidraParent.getFolderData(), monitor != null ? monitor : TaskMonitor.DUMMY);
    }

    @Override
    public DomainFile copyToAsLink(DomainFolder newParent, boolean relative) throws IOException {
        GhidraFolder newGhidraParent = GhidraFolder.getDestinationFolder(newParent);
        return this.getFolderData().copyToAsLink(newGhidraParent.getFolderData(), relative);
    }

    boolean privateExists() {
        try {
            return this.getFolderData().privateExists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    boolean sharedExists() {
        try {
            return this.getFolderData().sharedExists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public void setActive() {
        this.listener.domainFolderSetActive(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GhidraFolder)) {
            return false;
        }
        GhidraFolder other = (GhidraFolder)obj;
        if (this.projectData != other.projectData) {
            return false;
        }
        return this.getPathname().equals(other.getPathname());
    }

    @Override
    public boolean isSameOrAncestor(DomainFolder folder) {
        if (!this.getProjectLocator().equals(folder.getProjectLocator()) && !SystemUtilities.isEqual((Object)this.projectData.getSharedProjectURL(), (Object)folder.getProjectData().getSharedProjectURL())) {
            return false;
        }
        String pathname = this.getPathname();
        for (DomainFolder f = folder; f != null; f = f.getParent()) {
            if (f != this && !pathname.equals(f.getPathname())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSame(DomainFolder folder) {
        if (!this.getProjectLocator().equals(folder.getProjectLocator()) && !SystemUtilities.isEqual((Object)this.projectData.getSharedProjectURL(), (Object)folder.getProjectData().getSharedProjectURL())) {
            return false;
        }
        return this.getPathname().equals(folder.getPathname());
    }

    public int hashCode() {
        return this.getPathname().hashCode();
    }

    public String toString() {
        ProjectLocator projectLocator = this.projectData.getProjectLocator();
        if (projectLocator.isTransient()) {
            return this.projectData.getProjectLocator().getName() + this.getPathname();
        }
        return this.projectData.getProjectLocator().getName() + ":" + this.getPathname();
    }
}

