/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.core.decompiler.taint.TaintOptions;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.services.ConsoleService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;

public class CreateTargetIndexTask
extends Task {
    private TaintPlugin plugin;
    private Program program;

    public CreateTargetIndexTask(TaintPlugin plugin, Program program) {
        super("Create Target Index Action", true, true, false, false);
        this.plugin = plugin;
        this.program = program;
    }

    private File getFilePath(String initial_directory, String title) {
        GhidraFileChooser chooser = new GhidraFileChooser(null);
        chooser.setCurrentDirectory(new File(initial_directory));
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setTitle(title);
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile != null) {
            return selectedFile;
        }
        return selectedFile;
    }

    private String getDirectoryPath(String path, String title) {
        GhidraFileChooser chooser = new GhidraFileChooser(null);
        chooser.setCurrentDirectory(new File(path));
        chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        chooser.setTitle(title);
        File selectedDir = chooser.getCurrentDirectory();
        if (selectedDir != null && !chooser.wasCancelled()) {
            return selectedDir.getAbsolutePath();
        }
        return null;
    }

    private boolean indexProgram(String engine_path, String facts_path, String index_directory) {
        boolean rvalue = true;
        ArrayList<String> param_list = new ArrayList<String>();
        this.plugin.getTaintState().buildIndex(param_list, engine_path, facts_path, index_directory);
        Msg.info((Object)((Object)this), (Object)("Index Param List: " + ((Object)param_list).toString()));
        try {
            ProcessBuilder pb = new ProcessBuilder(param_list);
            pb.directory(new File(facts_path));
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            Msg.error((Object)((Object)this), (Object)("Problems running index: " + String.valueOf(e)));
            rvalue = false;
        }
        return rvalue;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.program.getFunctionManager().getFunctionCount());
        PluginTool tool = this.plugin.getTool();
        ConsoleService consoleService = (ConsoleService)tool.getService(ConsoleService.class);
        ToolOptions options = tool.getOptions("Decompiler");
        String enginePathName = options.getString("Taint.Directories.Engine", "/home/user/workspace/engine_binary").trim();
        String factsDirectory = options.getString("Taint.Directories.Facts", "/tmp/export").trim();
        String indexDirectory = options.getString("Taint.Directories.Output", "/tmp/output").trim();
        String indexDBName = options.getString("Taint.Query.Index", "ctadlir.db").trim();
        indexDBName = TaintOptions.makeDBName(indexDBName, this.program.getName());
        Path enginePath = Path.of(enginePathName, new String[0]);
        File engineFile = enginePath.toFile();
        if (!engineFile.exists() || !engineFile.canExecute()) {
            Msg.info((Object)((Object)this), (Object)("The engine binary (" + engineFile.toString() + ") cannot be found or executed."));
            engineFile = this.getFilePath(enginePathName, "Select the engine binary");
        }
        consoleService.addMessage("Create Index", "using engine at: " + engineFile.toString());
        Path factsPath = Path.of(factsDirectory, new String[0]);
        if (!factsPath.toFile().exists() || !factsPath.toFile().isDirectory()) {
            Msg.info((Object)((Object)this), (Object)("Facts Path: " + factsPath.toString() + " does not exist."));
            factsDirectory = this.getDirectoryPath(factsDirectory, "Select full path to the directory containing the FACTS files");
            if (factsDirectory == null) {
                Msg.info((Object)((Object)this), (Object)"User cancelled operation; existing script.");
                return;
            }
            Msg.info((Object)((Object)this), (Object)("Using .facts files in: " + factsDirectory));
            options.setString("Taint.Directories.Facts", factsDirectory);
        } else {
            factsDirectory = factsPath.toString();
        }
        consoleService.addMessage("Create Index", "using facts path: " + factsDirectory);
        Path indexPath0 = Path.of(indexDirectory, new String[0]);
        Path indexPath = Path.of(indexDirectory, indexDBName);
        if (!indexPath0.toFile().exists() || !indexPath0.toFile().isDirectory()) {
            Msg.info((Object)((Object)this), (Object)("Index Path: " + indexPath.toString() + " does not exist."));
            indexDirectory = this.getDirectoryPath(indexDirectory, "Select full path to the directory to containthe INDEX file");
            indexPath = Path.of(indexDirectory, indexDBName);
            options.setString("Taint.Directories.Output", indexDirectory);
        }
        consoleService.addMessage("Create Index", "using index path: " + indexDirectory);
        Msg.info((Object)((Object)this), (Object)("Engine Path: " + engineFile.toString()));
        Msg.info((Object)((Object)this), (Object)("Facts Path: " + factsDirectory));
        Msg.info((Object)((Object)this), (Object)("Index Path: " + indexDirectory));
        boolean success = this.indexProgram(engineFile.toString(), factsDirectory, indexDirectory);
        consoleService.addMessage("Create Index", "indexing status: " + success);
        monitor.clearCancelled();
    }
}

