/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import com.contrastsecurity.sarif.SarifSchema210;
import com.google.gson.JsonSyntaxException;
import docking.ComponentProvider;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintOptions;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintQueryResult;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sarif.SarifService;

public abstract class AbstractTaintState
implements TaintState {
    public static String ENGINE_NAME = "";
    protected Set<TaintLabel> sources = new HashSet<TaintLabel>();
    protected Set<TaintLabel> sinks = new HashSet<TaintLabel>();
    protected Set<TaintLabel> gates = new HashSet<TaintLabel>();
    protected AddressSet taintAddressSet = new AddressSet();
    protected Map<Address, Set<TaintQueryResult>> taintVarnodeMap = new HashMap<Address, Set<TaintQueryResult>>();
    private AddressSet deltaAddressSet = new AddressSet();
    private Map<Address, Set<TaintQueryResult>> deltaVarnodeMap = new HashMap<Address, Set<TaintQueryResult>>();
    protected SarifSchema210 currentQueryData;
    protected TaintOptions taintOptions;
    protected TaintPlugin plugin;
    protected boolean usesIndex = true;
    private boolean cancellation;
    private TaintState.TaskType taskType = TaintState.TaskType.SET_TAINT;

    public AbstractTaintState(TaintPlugin plugin) {
        this.plugin = plugin;
    }

    public abstract void buildQuery(List<String> var1, String var2, File var3, String var4);

    @Override
    public abstract void buildIndex(List<String> var1, String var2, String var3, String var4);

    protected abstract void writeHeader(PrintWriter var1);

    protected abstract void writeRule(PrintWriter var1, TaintLabel var2, boolean var3);

    protected abstract void writeGate(PrintWriter var1, TaintLabel var2);

    protected abstract void writeFooter(PrintWriter var1);

    @Override
    public boolean wasCancelled() {
        return this.cancellation;
    }

    @Override
    public void setCancellation(boolean status) {
        this.cancellation = status;
    }

    @Override
    public Set<TaintLabel> getTaintLabels(TaintState.MarkType mtype) {
        return switch (mtype) {
            case TaintState.MarkType.SOURCE -> this.sources;
            case TaintState.MarkType.SINK -> this.sinks;
            case TaintState.MarkType.GATE -> this.gates;
            default -> new HashSet<TaintLabel>();
        };
    }

    @Override
    public TaintLabel toggleMark(TaintState.MarkType mtype, ClangToken token) throws PcodeException {
        TaintLabel labelToToggle = new TaintLabel(mtype, token);
        Msg.info((Object)this, (Object)("labelToToggle: " + String.valueOf(labelToToggle)));
        Set<TaintLabel> marks = this.getTaintLabels(mtype);
        return this.updateMarks(labelToToggle, marks);
    }

    private TaintLabel updateMarks(TaintLabel tlabel, Set<TaintLabel> marks) {
        for (TaintLabel existingLabel : marks) {
            if (!existingLabel.equals(tlabel)) continue;
            existingLabel.toggle();
            this.plugin.getTool().contextChanged((ComponentProvider)this.plugin.getDecompilerProvider());
            return existingLabel;
        }
        marks.add(tlabel);
        this.plugin.getTool().contextChanged((ComponentProvider)this.plugin.getDecompilerProvider());
        return tlabel;
    }

    @Override
    public TaintLabel getLabelForToken(TaintState.MarkType type, ClangToken token) {
        Set<TaintLabel> marks = this.getTaintLabels(type);
        for (TaintLabel existingLabel : marks) {
            if (!token.equals(existingLabel.getToken())) continue;
            return existingLabel;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.activeSources() || this.activeSinks();
    }

    private boolean activeSinks() {
        for (TaintLabel label : this.sinks) {
            if (!label.isActive()) continue;
            return true;
        }
        return false;
    }

    private boolean activeSources() {
        for (TaintLabel label : this.sources) {
            if (!label.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMarks() {
        return !this.sources.isEmpty() || !this.sinks.isEmpty() || !this.gates.isEmpty();
    }

    public boolean writeQueryFile(File queryTextFile) throws Exception {
        PrintWriter writer = new PrintWriter(queryTextFile);
        this.writeHeader(writer);
        for (TaintLabel mark : this.sources) {
            if (!mark.isActive()) continue;
            this.writeRule(writer, mark, true);
        }
        for (TaintLabel mark : this.sinks) {
            if (!mark.isActive()) continue;
            this.writeRule(writer, mark, false);
        }
        if (!this.gates.isEmpty()) {
            for (TaintLabel mark : this.gates) {
                if (!mark.isActive()) continue;
                this.writeGate(writer, mark);
            }
        }
        this.writeFooter(writer);
        writer.flush();
        writer.close();
        this.plugin.consoleMessage("Wrote Query File: " + String.valueOf(queryTextFile));
        return true;
    }

    @Override
    public boolean queryIndex(Program program, PluginTool tool, TaintState.QueryType queryType) {
        if (queryType.equals((Object)TaintState.QueryType.SRCSINK) && !this.isValid()) {
            Msg.showWarn((Object)this, (Component)tool.getActiveWindow(), (String)(this.getName() + " Query Warning"), (Object)(this.getName() + " query cannot be performed because there are no sources or sinks."));
            return false;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        File queryFile = null;
        this.taintOptions = this.plugin.getOptions();
        try {
            Path queryPath;
            Path engine = Path.of(this.taintOptions.getTaintEnginePath(), new String[0]);
            File engineFile = engine.toFile();
            if (!engineFile.exists()) {
                this.plugin.consoleMessage("The " + this.getName() + " binary (" + engineFile.getCanonicalPath() + ") cannot be found or executed.");
                engineFile = this.getFilePath(this.taintOptions.getTaintEnginePath(), "Select the " + this.getName() + " binary");
                if (engineFile == null) {
                    this.plugin.consoleMessage("No " + this.getName() + " engine has been specified; exiting query function.");
                    return false;
                }
            }
            this.plugin.consoleMessage("Using " + this.getName() + " binary: " + engineFile.toString());
            Path indexDirectory = Path.of(this.taintOptions.getTaintOutputDirectory(), new String[0]);
            Path indexDBPath = Path.of(this.taintOptions.getTaintOutputDirectory(), this.taintOptions.getTaintIndexDBName(program.getName()));
            File indexDBFile = indexDBPath.toFile();
            if (this.usesIndex) {
                this.plugin.consoleMessage("Attempting to use index: " + indexDBFile.toString());
                if (!indexDBFile.exists()) {
                    this.plugin.consoleMessage("The index database for the binary named: " + program.getName() + " does not exist; create it first.");
                    return false;
                }
                this.plugin.consoleMessage("Using index database: " + String.valueOf(indexDBFile));
            }
            switch (queryType) {
                case SRCSINK: {
                    queryPath = Path.of(this.taintOptions.getTaintOutputDirectory(), this.taintOptions.getTaintQueryDLName());
                    queryFile = queryPath.toFile();
                    this.writeQueryFile(queryFile);
                    this.plugin.consoleMessage("The datalog query file: " + queryFile.toString() + " has been written and can be referenced later if needed.");
                    break;
                }
                case DEFAULT: {
                    this.plugin.consoleMessage("Performing default query.");
                    break;
                }
                case CUSTOM: {
                    this.plugin.consoleMessage("Performing custom query.");
                    break;
                }
                default: {
                    this.plugin.consoleMessage("Unknown query type.");
                }
            }
            this.buildQuery(paramList, engineFile.toString(), indexDBFile, indexDirectory.toString());
            if (queryType.equals((Object)TaintState.QueryType.SRCSINK) || queryType.equals((Object)TaintState.QueryType.CUSTOM)) {
                if (queryType.equals((Object)TaintState.QueryType.CUSTOM)) {
                    queryPath = Path.of(this.taintOptions.getTaintOutputDirectory(), this.taintOptions.getTaintQueryDLName());
                    GhidraFileChooser chooser = new GhidraFileChooser((Component)this.plugin.getProvider().getComponent());
                    chooser.setCurrentDirectory(queryPath.toFile());
                    queryFile = chooser.getSelectedFile();
                    if (queryFile == null) {
                        return false;
                    }
                }
                paramList.add(queryFile.getAbsolutePath());
            }
            Msg.info((Object)this, (Object)("Query Param List: " + ((Object)paramList).toString()));
            try {
                ProcessBuilder pb = new ProcessBuilder(paramList);
                pb.directory(new File(this.taintOptions.getTaintOutputDirectory()));
                pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                Process p = pb.start();
                this.readQueryResultsIntoDataFrame(program, p.getInputStream());
                p.waitFor();
            }
            catch (InterruptedException e) {
                Msg.error((Object)this, (Object)e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Problems running query: " + String.valueOf(e)));
            return false;
        }
        return true;
    }

    protected void readQueryResultsIntoDataFrame(Program prog, InputStream is) {
        StringBuilder sb = new StringBuilder();
        String line = null;
        this.taintAddressSet.clear();
        this.taintVarnodeMap.clear();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            this.plugin.consoleMessage("IO Error Reading Query Results from Process: " + e.getMessage());
        }
        try {
            this.currentQueryData = this.plugin.getSarifService().readSarif(sb.toString());
        }
        catch (JsonSyntaxException e) {
            this.plugin.consoleMessage("Error in JSON in Sarif Output from " + this.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            this.plugin.consoleMessage("IO Exception Parsing JSON Sarif Output from " + this.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private File getFilePath(String initial_directory, String title) {
        GhidraFileChooser chooser = new GhidraFileChooser(null);
        chooser.setCurrentDirectory(new File(initial_directory));
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setTitle(title);
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile != null) {
            return selectedFile;
        }
        return selectedFile;
    }

    @Override
    public void loadTaintData(Program program, File sarifFile) {
        try {
            SarifService sarifService = this.plugin.getSarifService();
            SarifSchema210 sarif_data = sarifService.readSarif(sarifFile);
            sarifService.showSarif(sarifFile.getName(), sarif_data);
        }
        catch (JsonSyntaxException e) {
            this.plugin.consoleMessage("Syntax error in JSON taint data " + this.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            this.plugin.consoleMessage("IO Exception parsing in JSON taint data " + this.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void setTaintAddressSet(AddressSet aset) {
        switch (this.taskType) {
            case SET_TAINT: {
                this.taintAddressSet = aset;
                break;
            }
            case SET_DELTA: {
                this.deltaAddressSet = aset;
                break;
            }
        }
    }

    @Override
    public AddressSet getTaintAddressSet() {
        return switch (this.taskType) {
            case TaintState.TaskType.SET_TAINT -> this.taintAddressSet;
            case TaintState.TaskType.SET_DELTA -> this.deltaAddressSet;
            case TaintState.TaskType.APPLY_DELTA -> this.taintAddressSet.subtract((AddressSetView)this.deltaAddressSet);
            default -> new AddressSet();
        };
    }

    @Override
    public void setTaskType(TaintState.TaskType taskType) {
        this.taskType = taskType;
    }

    @Override
    public void augmentAddressSet(ClangToken token) {
        Address addr = token.getMinAddress();
        if (addr == null) {
            return;
        }
        switch (this.taskType) {
            case SET_TAINT: {
                this.taintAddressSet.add(addr);
                break;
            }
            case SET_DELTA: {
                this.deltaAddressSet.add(addr);
                break;
            }
            case APPLY_DELTA: {
                if (this.deltaAddressSet.contains(addr)) break;
                this.taintAddressSet.add(addr);
            }
        }
    }

    @Override
    public void setTaintVarnodeMap(Map<Address, Set<TaintQueryResult>> vmap, TaintState.TaskType delta) {
        switch (delta) {
            case SET_TAINT: {
                this.taintVarnodeMap = vmap;
                break;
            }
            case SET_DELTA: {
                this.deltaVarnodeMap = vmap;
                break;
            }
            case APPLY_DELTA: {
                this.taintVarnodeMap = vmap;
            }
        }
    }

    @Override
    public Map<Address, Set<TaintQueryResult>> getTaintVarnodeMap() {
        return this.taintVarnodeMap;
    }

    @Override
    public Set<TaintQueryResult> getQuerySet(Address key) {
        Set<TaintQueryResult> set = new HashSet<TaintQueryResult>();
        switch (this.taskType) {
            case SET_TAINT: {
                set = this.taintVarnodeMap.get(key);
                break;
            }
            case SET_DELTA: {
                set = this.deltaVarnodeMap.get(key);
                break;
            }
            case APPLY_DELTA: {
                Set<TaintQueryResult> A = this.taintVarnodeMap.get(key);
                if (A != null) {
                    set.addAll(A);
                }
                Set<TaintQueryResult> B = this.deltaVarnodeMap.get(key);
                if (A == null) break;
                set.removeAll(B);
            }
        }
        return set;
    }

    @Override
    public void clearTaint() {
        Msg.info((Object)this, (Object)"TaintState: clearTaint() - clearing address set");
        switch (this.taskType) {
            case SET_TAINT: {
                this.taintAddressSet.clear();
                this.taintVarnodeMap.clear();
                break;
            }
            case SET_DELTA: {
                this.deltaAddressSet.clear();
                this.deltaVarnodeMap.clear();
                break;
            }
        }
    }

    @Override
    public void clearMarkers() {
        this.sources.clear();
        this.sinks.clear();
        this.gates.clear();
    }

    @Override
    public boolean isSink(HighVariable hvar) {
        for (TaintLabel mark : this.sinks) {
            if (mark.getHighVariable() == null || !mark.getHighVariable().equals(hvar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SarifSchema210 getData() {
        if (this.currentQueryData == null) {
            Msg.warn((Object)this, (Object)"attempt to retrieve a sarif data frame that is null.");
        }
        return this.currentQueryData;
    }

    @Override
    public void clearData() {
        this.currentQueryData = null;
    }

    @Override
    public TaintOptions getOptions() {
        return this.plugin.getOptions();
    }

    @Override
    public String getName() {
        return ENGINE_NAME;
    }
}

