/*
 * Decompiled with CFR 0.152.
 */
package docking.util.image;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DropShadow {
    private Color shadowColor = GThemeDefaults.Colors.Palette.BLACK;
    private float shadowOpacity = 0.85f;

    private void applyShadow(BufferedImage image, int shadowSize) {
        int a;
        int history;
        int aSum;
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        int left = shadowSize - 1 >> 1;
        int right = shadowSize - left;
        int xStart = left;
        int xStop = imgWidth - right;
        int yStart = left;
        int yStop = imgHeight - right;
        int shadowRgb = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * imgWidth;
        float sumDivider = this.shadowOpacity / (float)shadowSize;
        int y = 0;
        int pixel = 0;
        while (y < imgHeight) {
            aSum = 0;
            history = 0;
            int x = 0;
            while (x < shadowSize) {
                aHistory[x] = a = data[pixel] >>> 24;
                aSum += a;
                ++x;
                ++pixel;
            }
            pixel -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                data[pixel] = a << 24 | shadowRgb;
                aSum -= aHistory[history];
                aHistory[history] = a = data[pixel + right] >>> 24;
                aSum += a;
                if (++history >= shadowSize) {
                    history -= shadowSize;
                }
                ++x;
                ++pixel;
            }
            pixel = ++y * imgWidth;
        }
        int x = 0;
        int bufferOffset = 0;
        while (x < imgWidth) {
            aSum = 0;
            history = 0;
            int y2 = 0;
            while (y2 < shadowSize) {
                aHistory[y2] = a = data[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += imgWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                data[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[history];
                aHistory[history] = a = data[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++history >= shadowSize) {
                    history -= shadowSize;
                }
                ++y2;
                bufferOffset += imgWidth;
            }
            bufferOffset = ++x;
        }
    }

    private BufferedImage prepareImage(BufferedImage image, int shadowSize) {
        int width = image.getWidth() + shadowSize * 2;
        int height = image.getHeight() + shadowSize * 2;
        BufferedImage subject = new BufferedImage(width, height, 2);
        Graphics2D g2 = subject.createGraphics();
        g2.drawImage(image, null, shadowSize, shadowSize);
        g2.dispose();
        return subject;
    }

    public Image createDropShadow(BufferedImage image, int shadowSize) {
        BufferedImage subject = this.prepareImage(image, shadowSize);
        this.applyShadow(subject, shadowSize);
        return subject;
    }

    public static void main(String[] args) {
        final DropShadow ds = new DropShadow();
        final JPanel canvas = new JPanel(){
            BufferedImage image = null;
            Image shadow = null;

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                GColor background = GThemeDefaults.Colors.Palette.WHITE;
                g.setColor((Color)background);
                Dimension size = this.getSize();
                g.fillRect(0, 0, size.width, size.height);
                GraphicsConfiguration gc = g2d.getDeviceConfiguration();
                VolatileImage newImage = gc.createCompatibleVolatileImage(size.width, size.height, 3);
                g2d = (Graphics2D)newImage.getGraphics();
                g2d.setComposite(AlphaComposite.Clear);
                g2d.fillRect(0, 0, size.width, size.height);
                g2d.setComposite(AlphaComposite.Src);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor((Color)GThemeDefaults.Colors.Palette.WHITE);
                g2d.fillOval(size.width / 4, size.height / 4, size.width / 2, size.height / 2);
                g2d.setComposite(AlphaComposite.SrcAtop);
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, (Color)GThemeDefaults.Colors.Palette.RED, 0.0f, size.height, (Color)GThemeDefaults.Colors.Palette.YELLOW));
                g2d.fillRect(0, 0, size.width, size.height);
                g2d.dispose();
                BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 2);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(newImage, 0, 0, null);
                graphics.dispose();
                this.image = bufferedImage;
                this.shadow = ds.createDropShadow(bufferedImage, 5);
                g.drawImage(this.shadow, 10, 10, null);
                g.drawImage(this.image, 0, 0, null);
            }
        };
        canvas.setPreferredSize(new Dimension(600, 600));
        JFrame frame = new JFrame("Test");
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(canvas);
        canvas.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                canvas.repaint();
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        frame.pack();
    }
}

