/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentNode;
import docking.ComponentPlaceholder;
import docking.DetachedWindowNode;
import docking.DockableComponent;
import docking.DockingFrame;
import docking.DockingWindowListener;
import docking.DockingWindowManager;
import docking.DropTargetFactory;
import docking.DropTargetHandler;
import docking.HiddenDockingFrame;
import docking.Node;
import docking.SplitNode;
import docking.StatusBar;
import docking.WindowNode;
import docking.WindowPosition;
import generic.util.WindowUtilities;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.Swing;
import ghidra.util.bean.GGlassPane;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.jdom.Content;
import org.jdom.Element;

class RootNode
extends WindowNode {
    static final String ROOT_NODE_ELEMENT_NAME = "ROOT_NODE";
    private WeakSet<DockingWindowListener> dockingWindowListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private String toolName;
    private Node child;
    private List<DetachedWindowNode> detachedWindows;
    private JPanel childPanel;
    private StatusBar statusBar;
    private SwingWindowWrapper windowWrapper;
    private DropTargetFactory dropTargetFactory;
    private DropTargetHandler rootDropTargetHandler;

    RootNode(DockingWindowManager mgr, String toolName, List<Image> images, boolean isModal, DropTargetFactory factory) {
        super(mgr);
        this.toolName = toolName;
        this.detachedWindows = new ArrayList<DetachedWindowNode>();
        if (isModal) {
            frame = new HiddenDockingFrame(toolName);
            this.setFrameIcon((Frame)frame, images);
            frame.setBounds(-100, 100, 10, 10);
            JDialog dialog = this.createDialog(toolName, frame);
            this.windowWrapper = new JDialogWindowWrapper(new JFrameWindowWrapper(frame), dialog);
        } else {
            frame = new DockingFrame(toolName);
            this.setFrameIcon((Frame)frame, images);
            this.windowWrapper = new JFrameWindowWrapper(frame);
        }
        Container c = this.windowWrapper.getContentPane();
        c.setLayout(new BorderLayout());
        this.childPanel = new JPanel(new BorderLayout());
        this.childPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        c.add((Component)this.childPanel, "Center");
        if (mgr.hasStatusBar()) {
            this.statusBar = new StatusBar();
            c.add((Component)this.statusBar, "South");
        }
        this.dropTargetFactory = factory;
        if (this.dropTargetFactory != null) {
            this.rootDropTargetHandler = factory.createDropTargetHandler(this.getFrame());
        }
    }

    private JDialog createDialog(String title, DockingFrame frame) {
        JDialog dialog = new JDialog((Frame)frame, true);
        dialog.setTitle(title);
        dialog.setGlassPane((Component)new GGlassPane());
        return dialog;
    }

    private void setFrameIcon(Frame frame, Image image) {
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(image);
        this.setFrameIcon(frame, list);
    }

    private void setFrameIcon(Frame frame, List<Image> images) {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X) {
            return;
        }
        if (images != null) {
            frame.setIconImages(images);
        }
    }

    void setHomeButton(Icon icon, Runnable callback) {
        if (!this.winMgr.hasStatusBar()) {
            return;
        }
        this.statusBar.setHomeButton(icon, () -> callback.run());
    }

    boolean isModal() {
        return this.windowWrapper.isModal();
    }

    @Override
    boolean isVisible() {
        return this.windowWrapper.isVisible();
    }

    void setToolName(String toolName) {
        this.toolName = toolName;
        this.windowWrapper.setTitle(toolName);
        for (DetachedWindowNode windowNode : this.detachedWindows) {
            windowNode.updateTitle();
        }
    }

    @Override
    List<Node> getChildren() {
        return Arrays.asList(this.child);
    }

    public String toString() {
        return this.printTree();
    }

    @Override
    public String getTitle() {
        return this.windowWrapper.getTitle();
    }

    @Override
    String getDescription() {
        return "Root Node: " + this.getTitle();
    }

    void setIcon(ImageIcon icon) {
        Image iconImage = icon.getImage();
        this.setFrameIcon((Frame)this.windowWrapper.getParentFrame(), iconImage);
        for (DetachedWindowNode windowNode : this.detachedWindows) {
            windowNode.setIcon(iconImage);
        }
    }

    void setVisible(boolean state) {
        Window mainWindow = this.getMainWindow();
        mainWindow.setVisible(state);
        if (state) {
            WindowUtilities.ensureOnScreen((Component)mainWindow);
        }
        for (DetachedWindowNode windowNode : this.detachedWindows) {
            windowNode.setVisible(state);
        }
    }

    void addToNewWindow(ComponentPlaceholder placeholder) {
        this.addToNewWindow(placeholder, null);
    }

    void addToNewWindow(ComponentPlaceholder placeholder, Point loc) {
        DockableComponent component = placeholder.getComponent();
        Dimension placeholderSize = null;
        if (component != null) {
            Dimension size = component.getSize();
            Dimension preferredSize = component.getPreferredSize();
            placeholderSize = new Dimension(size);
            int preferredArea = preferredSize.width * preferredSize.height;
            int area = size.width * size.height;
            if (preferredArea > area) {
                placeholderSize.width = preferredSize.width;
                placeholderSize.height = preferredSize.height;
            }
        }
        ComponentNode node = new ComponentNode(this.winMgr);
        placeholder.setNode(node);
        node.parent = this;
        DetachedWindowNode windowNode = new DetachedWindowNode(this.winMgr, this, node, this.dropTargetFactory);
        Point location = loc == null ? new Point() : loc;
        Dimension size = placeholderSize == null ? new Dimension() : placeholderSize;
        windowNode.setInitialBounds(new Rectangle(location, size));
        this.detachedWindows.add(windowNode);
        placeholder.getNode().add(placeholder);
        placeholder.requestFocusWhenReady();
        this.notifyWindowAdded(windowNode);
    }

    void add(ComponentPlaceholder placeholder, WindowPosition initialPosition) {
        if (initialPosition == WindowPosition.WINDOW) {
            this.addToNewWindow(placeholder);
            return;
        }
        ComponentNode node = new ComponentNode(this.winMgr);
        placeholder.setNode(node);
        if (this.child == null) {
            node.parent = this;
            this.child = node;
        } else {
            switch (initialPosition) {
                case TOP: {
                    this.child = new SplitNode(this.winMgr, node, this.child, false);
                    break;
                }
                case BOTTOM: {
                    this.child = new SplitNode(this.winMgr, this.child, (Node)node, false);
                    break;
                }
                case LEFT: {
                    this.child = new SplitNode(this.winMgr, node, this.child, true);
                    break;
                }
                default: {
                    this.child = new SplitNode(this.winMgr, this.child, (Node)node, true);
                }
            }
            this.child.parent = this;
        }
        placeholder.getNode().add(placeholder);
    }

    private void updateChild() {
        JComponent comp = null;
        if (this.child != null) {
            if (!this.child.invalid) {
                return;
            }
            comp = this.child.getComponent();
        }
        if (comp == null) {
            comp = new DockableComponent(null, true);
        }
        this.childPanel.removeAll();
        this.childPanel.add((Component)comp, "Center");
        this.childPanel.invalidate();
        this.clearContextTypes();
        this.notifyWindowChanged(this);
    }

    Window getWindow(ComponentPlaceholder info) {
        if (this.child != null && this.child.contains(info)) {
            return this.windowWrapper.getWindow();
        }
        for (DetachedWindowNode winNode : this.detachedWindows) {
            if (!winNode.contains(info)) continue;
            return winNode.getWindow();
        }
        return null;
    }

    void update() {
        if (this.invalid) {
            this.clearContextTypes();
            this.updateChild();
            for (DetachedWindowNode windowNode : this.detachedWindows) {
                windowNode.update();
            }
            this.invalid = false;
        }
        this.winMgr.getActionToGuiMapper().update();
        this.windowWrapper.validate();
    }

    void updateDialogs() {
        for (DetachedWindowNode windowNode : this.detachedWindows) {
            windowNode.updateDialog();
        }
    }

    @Override
    void setMenuBar(JMenuBar menuBar) {
        this.windowWrapper.setJMenuBar(menuBar);
    }

    @Override
    void validate() {
        this.windowWrapper.validate();
    }

    @Override
    void close() {
        throw new UnsupportedOperationException("Cannot call close on root node");
    }

    @Override
    JComponent getComponent() {
        return null;
    }

    @Override
    void removeNode(Node node) {
        if (this.child != node && !this.detachedWindows.contains(node)) {
            throw new IllegalArgumentException();
        }
        if (this.child == node) {
            this.child = null;
        } else {
            this.detachedWindows.remove(node);
            this.notifyWindowRemoved((DetachedWindowNode)node);
        }
        node.parent = null;
    }

    public JFrame getFrame() {
        return this.windowWrapper.getParentFrame();
    }

    JDialog getModalDialog() {
        if (this.windowWrapper.isModal()) {
            return (JDialog)this.windowWrapper.getWindow();
        }
        return null;
    }

    @Override
    void populateActiveComponents(List<ComponentPlaceholder> list) {
        if (this.child != null) {
            this.child.populateActiveComponents(list);
        }
    }

    String getName() {
        return this.toolName;
    }

    List<DetachedWindowNode> getDetachedWindows() {
        return this.detachedWindows;
    }

    String getToolName() {
        return this.toolName;
    }

    @Override
    void replaceNode(Node oldNode, Node newNode) {
        if (oldNode == this.child) {
            this.child = newNode;
            newNode.parent = this;
            this.child.invalidate();
            this.winMgr.scheduleUpdate();
        }
    }

    @Override
    Container getContentPane() {
        return this.windowWrapper.getContentPane();
    }

    @Override
    Element saveToXML() {
        Element root = new Element(ROOT_NODE_ELEMENT_NAME);
        JFrame frame = this.windowWrapper.getParentFrame();
        Rectangle r = this.getSaveableBounds();
        root.setAttribute("X_POS", "" + r.x);
        root.setAttribute("Y_POS", "" + r.y);
        root.setAttribute("WIDTH", "" + r.width);
        root.setAttribute("HEIGHT", "" + r.height);
        root.setAttribute("EX_STATE", "" + frame.getExtendedState());
        if (this.child != null) {
            root.addContent((Content)this.child.saveToXML());
        }
        for (DetachedWindowNode windowNode : this.detachedWindows) {
            root.addContent((Content)windowNode.saveToXML());
        }
        return root;
    }

    private Rectangle getSaveableBounds() {
        JFrame frame = this.windowWrapper.getParentFrame();
        int state = frame.getExtendedState();
        if (state != 6) {
            return frame.getBounds();
        }
        Rectangle bounds = this.windowWrapper.getLastBounds();
        if (bounds != null) {
            return bounds;
        }
        return frame.getBounds();
    }

    List<ComponentPlaceholder> restoreFromXML(Element rootNodeElement) {
        this.invalid = true;
        this.detachChild();
        this.setLastFocusedProviderInWindow(null);
        ArrayList<DetachedWindowNode> copy = new ArrayList<DetachedWindowNode>(this.detachedWindows);
        this.detachedWindows.clear();
        for (DetachedWindowNode windowNode : copy) {
            this.notifyWindowRemoved(windowNode);
            windowNode.disconnect();
        }
        int x = Integer.parseInt(rootNodeElement.getAttributeValue("X_POS"));
        int y = Integer.parseInt(rootNodeElement.getAttributeValue("Y_POS"));
        int width = Integer.parseInt(rootNodeElement.getAttributeValue("WIDTH"));
        int height = Integer.parseInt(rootNodeElement.getAttributeValue("HEIGHT"));
        int extendedState = Integer.parseInt(rootNodeElement.getAttributeValue("EX_STATE"));
        JFrame frame = this.windowWrapper.getParentFrame();
        Rectangle bounds = new Rectangle(x, y, width, height);
        WindowUtilities.ensureOnScreen((Component)frame, (Rectangle)bounds);
        frame.setBounds(bounds);
        this.windowWrapper.setLastBounds(bounds);
        Swing.runLater(() -> frame.setExtendedState(extendedState));
        ArrayList<ComponentPlaceholder> restoredPlaceholders = new ArrayList<ComponentPlaceholder>();
        for (Element elem : rootNodeElement.getChildren()) {
            if (elem.getName().equals("WINDOW_NODE")) {
                DetachedWindowNode node;
                DetachedWindowNode windowNode = node = new DetachedWindowNode(elem, this.winMgr, this, this.dropTargetFactory, restoredPlaceholders);
                this.detachedWindows.add(windowNode);
                this.notifyWindowAdded(windowNode);
                continue;
            }
            this.child = this.processChildElement(elem, this.winMgr, this, restoredPlaceholders);
        }
        return restoredPlaceholders;
    }

    private void detachChild() {
        if (this.child == null) {
            return;
        }
        this.child.parent = null;
        this.child = null;
    }

    @Override
    void dispose() {
        this.dockingWindowListeners.clear();
        if (this.child != null) {
            this.child.dispose();
        }
        super.dispose();
        if (this.rootDropTargetHandler != null) {
            this.rootDropTargetHandler.dispose();
        }
        for (DetachedWindowNode windowNode : this.detachedWindows) {
            this.notifyWindowRemoved(windowNode);
            windowNode.dispose();
        }
        this.detachedWindows.clear();
        this.windowWrapper.dispose();
    }

    @Override
    boolean contains(ComponentPlaceholder info) {
        if (this.child != null && this.child.contains(info)) {
            return true;
        }
        for (DetachedWindowNode winNode : this.detachedWindows) {
            if (!winNode.contains(info)) continue;
            return true;
        }
        return false;
    }

    public void addStatusItem(JComponent c, boolean addBorder, boolean rightSide) {
        if (this.statusBar != null) {
            this.statusBar.addStatusItem(c, addBorder, rightSide);
            this.windowWrapper.validate();
        }
    }

    public void removeStatusItem(JComponent c) {
        if (this.statusBar != null) {
            this.statusBar.removeStatusItem(c);
            this.windowWrapper.validate();
        }
    }

    public void clearStatusMessages() {
        if (this.statusBar == null) {
            return;
        }
        if (this.statusBar == null) {
            return;
        }
        this.statusBar.clearStatusMessages();
        for (DetachedWindowNode winNode : this.detachedWindows) {
            winNode.clearStatusMessages();
        }
    }

    public void setStatusText(String text) {
        if (this.statusBar == null) {
            return;
        }
        this.statusBar.setStatusText(text);
        for (DetachedWindowNode winNode : this.detachedWindows) {
            winNode.setStatusText(text);
        }
    }

    public String getStatusText() {
        return this.statusBar.getStatusText();
    }

    public Window getMainWindow() {
        return this.windowWrapper.getWindow();
    }

    @Override
    int getComponentCount() {
        return this.child.getComponentCount();
    }

    public void addDockingWindowListener(DockingWindowListener listener) {
        this.dockingWindowListeners.add((Object)listener);
    }

    public void removeDockingWindowListener(DockingWindowListener listener) {
        this.dockingWindowListeners.remove((Object)listener);
    }

    void notifyWindowAdded(DetachedWindowNode windowNode) {
        for (DockingWindowListener listener : this.dockingWindowListeners) {
            listener.dockingWindowAdded(windowNode);
        }
    }

    private void notifyWindowRemoved(DetachedWindowNode windowNode) {
        for (DockingWindowListener listener : this.dockingWindowListeners) {
            listener.dockingWindowRemoved(windowNode);
        }
    }

    void notifyWindowChanged(WindowNode windowNode) {
        for (DockingWindowListener listener : this.dockingWindowListeners) {
            listener.dockingWindowChanged(windowNode);
        }
    }

    void notifyWindowFocusChanged(WindowNode windowNode) {
        for (DockingWindowListener listener : this.dockingWindowListeners) {
            listener.dockingWindowFocusChanged(windowNode);
        }
    }

    @Override
    WindowNode getTopLevelNode() {
        return this;
    }

    public WindowNode getNodeForWindow(Window win) {
        if (this.windowWrapper.getWindow() == win) {
            return this;
        }
        for (DetachedWindowNode windowNode : this.detachedWindows) {
            if (windowNode.getWindow() != win) continue;
            return windowNode;
        }
        return null;
    }

    private class JDialogWindowWrapper
    extends SwingWindowWrapper {
        private final JDialog wrappedDialog;
        private final SwingWindowWrapper parentFrame;
        private WindowAdapter windowListener;

        public JDialogWindowWrapper(SwingWindowWrapper parentFrame, JDialog dialog) {
            super(RootNode.this);
            this.parentFrame = parentFrame;
            this.wrappedDialog = dialog;
            dialog.setSize(800, 400);
            dialog.setDefaultCloseOperation(0);
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    RootNode.this.winMgr.setVisible(false);
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    RootNode.this.winMgr.close();
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    RootNode.this.winMgr.setActive(JDialogWindowWrapper.this.wrappedDialog, true);
                }

                @Override
                public void windowStateChanged(WindowEvent e) {
                    JDialogWindowWrapper.this.setLastBounds(JDialogWindowWrapper.this.wrappedDialog.getBounds());
                }
            };
            dialog.addWindowListener(this.windowListener);
            dialog.addWindowStateListener(this.windowListener);
        }

        @Override
        public void dispose() {
            this.wrappedDialog.setVisible(false);
            this.wrappedDialog.removeWindowListener(this.windowListener);
            this.wrappedDialog.dispose();
            this.parentFrame.dispose();
        }

        @Override
        public Container getContentPane() {
            return this.wrappedDialog.getContentPane();
        }

        @Override
        public Window getWindow() {
            return this.wrappedDialog;
        }

        @Override
        public JFrame getParentFrame() {
            return this.parentFrame.getParentFrame();
        }

        @Override
        public boolean isVisible() {
            return this.wrappedDialog.isVisible();
        }

        @Override
        public void setJMenuBar(JMenuBar menuBar) {
            this.wrappedDialog.setJMenuBar(menuBar);
        }

        @Override
        public void validate() {
            this.wrappedDialog.validate();
        }

        @Override
        public void setTitle(String title) {
            this.wrappedDialog.setTitle(title);
        }

        @Override
        public String getTitle() {
            return this.wrappedDialog.getTitle();
        }

        @Override
        public boolean isModal() {
            return true;
        }
    }

    private class JFrameWindowWrapper
    extends SwingWindowWrapper {
        private final JFrame wrappedFrame;
        private WindowAdapter windowListener;

        public JFrameWindowWrapper(final JFrame wrappedFrame) {
            super(RootNode.this);
            this.wrappedFrame = wrappedFrame;
            wrappedFrame.setDefaultCloseOperation(0);
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    RootNode.this.winMgr.setVisible(false);
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    RootNode.this.winMgr.close();
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    RootNode.this.winMgr.setActive(wrappedFrame, true);
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    RootNode.this.winMgr.setActive(wrappedFrame, false);
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    RootNode.this.winMgr.iconify();
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    RootNode.this.winMgr.deIconify();
                }

                @Override
                public void windowStateChanged(WindowEvent e) {
                    JFrameWindowWrapper.this.setLastBounds(wrappedFrame.getBounds());
                }
            };
            wrappedFrame.addWindowListener(this.windowListener);
            wrappedFrame.addWindowStateListener(this.windowListener);
            wrappedFrame.setSize(800, 400);
        }

        @Override
        public void dispose() {
            this.wrappedFrame.removeWindowListener(this.windowListener);
            this.wrappedFrame.setVisible(false);
            this.wrappedFrame.dispose();
        }

        @Override
        public Container getContentPane() {
            return this.wrappedFrame.getContentPane();
        }

        @Override
        public Window getWindow() {
            return this.wrappedFrame;
        }

        @Override
        public JFrame getParentFrame() {
            return this.wrappedFrame;
        }

        @Override
        public boolean isVisible() {
            return this.wrappedFrame.isVisible();
        }

        @Override
        public void setJMenuBar(JMenuBar menuBar) {
            this.wrappedFrame.setJMenuBar(menuBar);
        }

        @Override
        public void validate() {
            this.wrappedFrame.validate();
        }

        @Override
        public void setTitle(String title) {
            this.wrappedFrame.setTitle(title);
        }

        @Override
        public String getTitle() {
            return this.wrappedFrame.getTitle();
        }

        @Override
        public boolean isModal() {
            return false;
        }
    }

    private abstract class SwingWindowWrapper {
        private Rectangle lastBounds;

        private SwingWindowWrapper(RootNode rootNode) {
        }

        abstract boolean isVisible();

        abstract boolean isModal();

        abstract void validate();

        abstract Container getContentPane();

        abstract void setJMenuBar(JMenuBar var1);

        abstract void dispose();

        abstract Window getWindow();

        abstract JFrame getParentFrame();

        abstract void setTitle(String var1);

        abstract String getTitle();

        public void setLastBounds(Rectangle bounds) {
            Rectangle screenSize;
            Rectangle screenBounds = WindowUtilities.getScreenBounds((Component)this.getWindow());
            if (screenBounds == null) {
                return;
            }
            Rectangle boundsSize = new Rectangle(bounds.getSize());
            if (boundsSize.contains(screenSize = new Rectangle(screenBounds.getSize()))) {
                return;
            }
            this.lastBounds = bounds;
        }

        public Rectangle getLastBounds() {
            return this.lastBounds;
        }
    }
}

