/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;
import java.util.Arrays;

public class FunctionRepeatableCommentFieldLocation
extends FunctionLocation {
    private String[] commentArray;

    public FunctionRepeatableCommentFieldLocation(Program program, Address locationAddr, Address functionAddr, String[] comment, int row, int charOffset) {
        super(program, locationAddr, functionAddr, row, 0, charOffset);
        this.commentArray = comment;
    }

    public FunctionRepeatableCommentFieldLocation(Program program, Address functionAddr, String[] comment, int row, int col) {
        this(program, functionAddr, functionAddr, comment, row, col);
    }

    public FunctionRepeatableCommentFieldLocation() {
    }

    public String[] getComment() {
        return this.commentArray;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.commentArray);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionRepeatableCommentFieldLocation other = (FunctionRepeatableCommentFieldLocation)obj;
        return Arrays.equals(this.commentArray, other.commentArray);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putStrings("_COMMENT", this.commentArray);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.commentArray = obj.getStrings("_COMMENT", null);
    }
}

